/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Session;
import org.jboss.seam.core.Manager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConversationContext
implements Context {
    private final Session session;
    private final Map<String, Object> additions = new HashMap<String, Object>();
    private final Set<String> removals = new HashSet<String>();
    private final String id;
    private final LinkedList<String> idStack;

    private LinkedList<String> getIdStack() {
        return this.idStack == null ? Manager.instance().getCurrentConversationIdStack() : this.idStack;
    }

    private String getId() {
        return this.id == null ? Manager.instance().getCurrentConversationId() : this.id;
    }

    @Override
    public ScopeType getType() {
        return ScopeType.CONVERSATION;
    }

    private String getKey(String name) {
        return this.getPrefix(this.getId()) + name;
    }

    private String getKey(String name, String id) {
        return this.getPrefix(id) + name;
    }

    private String getPrefix(String id) {
        return ScopeType.CONVERSATION.getPrefix() + '#' + id + '$';
    }

    public ServerConversationContext(Session session) {
        this.session = session;
        this.id = null;
        this.idStack = null;
    }

    public ServerConversationContext(Session session, String id) {
        this.session = session;
        this.id = id;
        this.idStack = new LinkedList();
        this.idStack.add(id);
    }

    @Override
    public Object get(String name) {
        Object result = this.additions.get(name);
        if (result != null) {
            return result;
        }
        if (this.removals.contains(name)) {
            return null;
        }
        LinkedList<String> stack = this.getIdStack();
        if (stack == null) {
            return this.session.getAttribute(this.getKey(name));
        }
        for (String id : stack) {
            result = this.session.getAttribute(this.getKey(name, id));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void set(String name, Object value) {
        if (value == null) {
            this.remove(name);
        } else {
            this.removals.remove(name);
            this.additions.put(name, value);
        }
    }

    @Override
    public boolean isSet(String name) {
        return this.get(name) != null;
    }

    @Override
    public void remove(String name) {
        this.additions.remove(name);
        this.removals.add(name);
    }

    @Override
    public String[] getNames() {
        Set<String> results = this.getNamesFromSession();
        results.addAll(this.additions.keySet());
        return results.toArray(new String[0]);
    }

    private Set<String> getNamesFromSession() {
        HashSet<String> results = new HashSet<String>();
        Enumeration names = this.session.getAttributeNames();
        String prefix = this.getPrefix(this.getId());
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(prefix) || this.removals.contains(name = name.substring(prefix.length()))) continue;
            results.add(name);
        }
        return results;
    }

    @Override
    public Object get(Class clazz) {
        return this.get(Seam.getComponentName(clazz));
    }

    public void clear() {
        this.additions.clear();
        this.removals.addAll(this.getNamesFromSession());
    }

    @Override
    public void flush() {
        boolean longRunning;
        boolean bl = longRunning = Manager.instance().isLongRunningConversation() || !Manager.instance().getCurrentConversationId().equals(this.getId());
        if (longRunning) {
            for (String string : this.removals) {
                this.session.removeAttribute(this.getKey(string));
            }
            this.removals.clear();
            for (Map.Entry entry : this.additions.entrySet()) {
                this.session.setAttribute(this.getKey((String)entry.getKey()), entry.getValue());
            }
            this.additions.clear();
        } else {
            for (String string : this.getNamesFromSession()) {
                this.session.removeAttribute(this.getKey(string));
            }
        }
    }

    public String toString() {
        return "ConversationContext(" + this.getId() + ")";
    }
}

