Richfaces.TreeSelectEvent = "Richfaces.TreeSelectEvent";
Richfaces.TreeExpandEvent = "Richfaces.TreeExpandEvent";
Richfaces.TreeCollapseEvent = "Richfaces.TreeCollapseEvent";

Tree = Class.create();
Tree.ID_DEVIDER = ":";
Tree.ID_CONTENT = "content";
Tree.ID_CHILDS_ROW = "childs";
Tree.ID_CHILDS_TD = "td";
Tree.ID_HANDLE = "handle";
Tree.ID_HANDLE_IMG_EXPANDED = "img:expanded";
Tree.ID_HANDLE_IMG_COLLAPSED = "img:collapsed";
Tree.ID_ICON = "icon";
Tree.ID_TEXT = "text";
Tree.CLASS_ITEM_SELECTED = "dr-tree-i-sel";
Tree.CLASS_ITEM_EXPANDED = "dr-tree-h-ic-line-exp";
Tree.CLASS_ITEM_COLLAPSED = "dr-tree-h-ic-line-clp";
Tree.CLASS_AJAX_SELECTED_LISTENER_FLAG = "ajax_selected_listener_flag";

Tree.prototype = {
	initialize: function(id, input, switchType, events, onAjaxSelect, dragIndicatorId) {
		this.items = [];
		this.childs = [];
		this.elements = {};

		this.id = id;
		this.switchType = switchType;
		this.dragIndicatorId = dragIndicatorId;
		this.onselect = new Function('event', events.onselect);
		this.onexpand = new Function('event', events.onexpand);
		this.oncollapse = new Function('event', events.oncollapse);
		this.onAjaxSelect = onAjaxSelect;
		this.element = $(id);
		this.inputId = input;
		this.input = $(this.inputId);
		
		var options = Object.extend({
				columnCount: 0
			}, arguments[1] || {}
		);
		this.options = options;

		this.getElements();
		this.selectionManager = new Tree.SelectionManager(this);
		this.selectionManager.restoreSelection();

		//this.correctSizes();

		Event.observe(this.element, "click", function(event) {
			if (Richfaces.eventIsSynthetic(event)) {
				if (event[Richfaces.TreeSelectEvent]){
					Event.stop(event);
					this.onselect(event);	
					
					var attr = $(event.selectedNode + Tree.ID_DEVIDER + Tree.ID_ICON).attributes['rich:ajaxselectedlistener'];
					if (attr && attr.nodeValue) {
						this.onAjaxSelect(event);
					}
				} else if (event[Richfaces.TreeExpandEvent]){
					Event.stop(event);
					this.onexpand(event);	
				} else if (event[Richfaces.TreeCollapseEvent]){
					Event.stop(event);
					this.oncollapse(event);	
				}
			}
		}.bindAsEventListener(this));

		//this.eventResize = this.correctSizes.bindAsEventListener(this);
		// commented by nick
		//IL.Event.observe(this.element, "resizex", this.eventResize);
	},

	getElements: function() {
		var contentId = this.id + Tree.ID_DEVIDER + Tree.ID_CHILDS_ROW + Tree.ID_DEVIDER + Tree.ID_CHILDS_TD;

		this.elements.contentTd = $(contentId);

		for (var i = 0; i < this.elements.contentTd.childNodes.length; i++) {
			var child = this.elements.contentTd.childNodes[i];
			if (child.nodeType == 1 && child.tagName.toLowerCase() == "table") {
				this.addChild(new Tree.Item(child.id, this, this, this.childs.length, this.switchType));
			}
		}
	},

	correctSizes: function() {
		if (!this.options.width) this.options.width = "100%";
		if (!this.options.height) this.options.height = "100%";

		var parentDim = Element.getDimensions(this.element.parentNode);
		var dim = {};

		var bc = {width: 0, height: 0};
		
		/* - commented by nick
		if (/MSIE/.test(navigator.userAgent)) {
			bc.width = parseInt(Element.getStyle(this.element, "border-left-width")) + parseInt(Element.getStyle(this.element, "border-right-width"));
			bc.height = parseInt(Element.getStyle(this.element, "border-top-width")) + parseInt(Element.getStyle(this.element, "border-bottom-width"));
		}
		*/

		if (this.options.width.slice(-1) == "%") {
			dim.width = (parentDim.width * parseInt(this.options.width) / 100);
		} else {
			dim.width = parseInt(this.options.width);
		}
		if (this.options.height.slice(-1) == "%") {
			dim.height = (parentDim.height * parseInt(this.options.height) / 100);
		} else {
			dim.height = parseInt(this.options.height);
		}

		Element.setStyle(this.element, {width: (dim.width - bc.width) + "px", height: (dim.height - bc.height) + "px"});
	},

	addChild: function(child) {
		this.childs.push(child);
		this.addItem(child);
	},

	addItem: function(item) {
		this.items.push(item);
	},

	deselectAll: function() {
		this.items.each(function(item) {item.deselect();} );
	},

	getNodeElements: function(node, nodeId) {
		if (node.id == nodeId) {
			node.getElements();
			node.observeEvents();
			this.selectionManager.restoreSelection();
			this.input = $(this.inputId);
		} else {
			for (var i = 0; i < node.childs.length; i++) {
				this.getNodeElements(node.childs[i], nodeId);
			}
		}
	},
	
	showNode: function(itemNode) {
		var node = itemNode;
		var offsetTopItem = 0;
		while(node && Element.isChildOf(node,this.element)) {
			offsetTopItem += node.offsetTop;
			node = node.offsetParent;
		}
		node = itemNode;
		var nodeBottom = offsetTopItem + node.offsetHeight;
		var visibleTop = this.element.scrollTop;
		var visibleBottom = visibleTop + this.element.clientHeight;
		if (offsetTopItem < visibleTop) {
			this.element.scrollTop = offsetTopItem;
		} else if (nodeBottom > visibleBottom) {
			this.element.scrollTop = nodeBottom - this.element.clientHeight;
		}
	},
	
	getElement: function() {
		return $(this.id);
	}
}

