/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.spi.TypeResolver;

public class ClassTypeResolver
implements TypeResolver {
    private final List imports;
    private final ClassLoader classLoader;
    private Map cachedImports = new HashMap();

    public ClassTypeResolver(List list) {
        this(list, null);
    }

    public ClassTypeResolver(List list, ClassLoader classLoader) {
        this.imports = list;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public List getImports() {
        return this.imports;
    }

    public void addImport(String string) {
        if (!this.imports.contains(string)) {
            this.imports.add(string);
        }
    }

    public Class lookupFromCache(String string) {
        return (Class)this.cachedImports.get(string);
    }

    public Class resolveType(String string) throws ClassNotFoundException {
        Class clazz = null;
        clazz = this.lookupFromCache(string);
        if (clazz == null) {
            try {
                clazz = this.classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
        }
        if (clazz == null) {
            HashSet<Class> hashSet = new HashSet<Class>();
            Iterator iterator = this.imports.iterator();
            while (iterator.hasNext()) {
                clazz = this.importClass((String)iterator.next(), string);
                if (clazz == null) continue;
                hashSet.add(clazz);
            }
            if (hashSet.size() > 1) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    if (0 != stringBuffer.length()) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(((Class)iterator2.next()).getName());
                }
                throw new Error("Unable to find unambiguously defined class '" + string + "', candidates are: [" + stringBuffer.toString() + "]");
            }
            clazz = hashSet.size() == 1 ? (Class)hashSet.toArray()[0] : null;
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Unable to find class '" + string + "'");
        }
        return clazz;
    }

    private Class importClass(String string, String string2) {
        String string3 = null;
        Class<?> clazz = null;
        if (string.endsWith("*")) {
            string3 = string.substring(0, string.indexOf(42)) + string2;
        } else if (string.endsWith("." + string2)) {
            string3 = string;
        } else if (string.equals(string2)) {
            string3 = string;
        }
        if (string3 != null) {
            try {
                clazz = this.classLoader.loadClass(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            if (clazz == null) {
                try {
                    int n = string3.lastIndexOf(46);
                    string3 = string3.substring(0, n) + "$" + string3.substring(n + 1);
                    clazz = this.classLoader.loadClass(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = null;
                }
            }
        }
        if (clazz != null) {
            if (this.cachedImports == Collections.EMPTY_MAP) {
                this.cachedImports = new HashMap();
            }
            this.cachedImports.put(string2, clazz);
        }
        return clazz;
    }

    public boolean isEmpty() {
        return this.imports.isEmpty();
    }
}

