/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.ajax.repeat.DataVisitor;
import org.ajax4jsf.ajax.repeat.Range;
import org.richfaces.component.AbstractTreeDataModel;
import org.richfaces.component.ListRowKey;
import org.richfaces.component.TreeNode;
import org.richfaces.component.TreeNodeImpl;
import org.richfaces.component.TreeRowKey;
import org.richfaces.component.state.TreeRange;

public class TreeDataModel
extends AbstractTreeDataModel {
    private TreeRowKey currentRowKey;
    private TreeRowKey oldRowKey;
    private TreeNode rowTreeData;

    public Object getRowKey() {
        return this.currentRowKey;
    }

    public void setRowKey(Object rowKey) {
        if (rowKey != null) {
            ListRowKey newRowKey = (ListRowKey)rowKey;
            this.currentRowKey = newRowKey;
        } else {
            this.currentRowKey = null;
            this.oldRowKey = null;
            this.rowTreeData = null;
        }
    }

    public void walk(FacesContext context, DataVisitor dataVisitor, Range range, TreeRowKey rowKey, Object argument, boolean last) throws IOException {
        TreeRange treeRange;
        ListRowKey listRowKey = (ListRowKey)rowKey;
        TreeNode node = this.locateTreeNode(listRowKey);
        if (node != null && ((treeRange = (TreeRange)range) == null || treeRange.processNode(rowKey))) {
            if (node.getParent() != null) {
                this.processElement(context, dataVisitor, argument, rowKey, last);
            }
            if ((treeRange == null || treeRange.processChildren(rowKey)) && !node.isLeaf()) {
                TreeNode nextChildNode;
                Object identifier;
                TreeNode childNode;
                Map.Entry childEntry;
                Iterator children = node.getChildren();
                Map.Entry entry = childEntry = children.hasNext() ? (Map.Entry)children.next() : null;
                if (childEntry != null) {
                    childNode = (TreeNode)childEntry.getValue();
                    identifier = childEntry.getKey();
                } else {
                    childNode = null;
                    identifier = null;
                }
                do {
                    Object nextIdentifier;
                    Map.Entry nextChildEntry;
                    Map.Entry entry2 = nextChildEntry = children.hasNext() ? (Map.Entry)children.next() : null;
                    if (nextChildEntry != null) {
                        nextChildNode = (TreeNode)nextChildEntry.getValue();
                        nextIdentifier = nextChildEntry.getKey();
                    } else {
                        nextChildNode = null;
                        nextIdentifier = null;
                    }
                    if (childNode != null) {
                        boolean isLast = nextChildNode == null;
                        ListRowKey newRowKey = rowKey != null ? new ListRowKey(listRowKey, identifier) : new ListRowKey((Object)identifier);
                        this.walk(context, dataVisitor, range, newRowKey, argument, isLast);
                    }
                    identifier = nextIdentifier;
                } while ((childNode = nextChildNode) != null);
            }
        }
    }

    protected TreeNode locateTreeNode(TreeRowKey rowKey) {
        return this.locateTreeNode(rowKey, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TreeNode locateTreeNode(TreeRowKey rowKey, boolean allowCreate) {
        boolean useCached;
        boolean bl = useCached = this.rowTreeData != null && rowKey != null && rowKey.equals(this.oldRowKey);
        if (useCached) return this.rowTreeData;
        TreeNode rootNode = (TreeNode)this.getWrappedData();
        if (rootNode == null) return null;
        if (rowKey == null) return rootNode;
        int commonPathLength = rowKey.getCommonPathLength(this.oldRowKey);
        if (this.oldRowKey == null) {
            this.rowTreeData = rootNode;
        } else {
            int currentUpOpsCount;
            int currentOpsCount;
            int rootOpsCount = rowKey.depth();
            if (rootOpsCount > (currentOpsCount = (currentUpOpsCount = this.oldRowKey.depth() - commonPathLength) + rootOpsCount - commonPathLength)) {
                for (int i = 0; i < this.oldRowKey.depth() - commonPathLength; ++i) {
                    this.rowTreeData = this.rowTreeData.getParent();
                }
            } else {
                commonPathLength = 0;
                this.rowTreeData = rootNode;
                this.oldRowKey = null;
            }
        }
        this.oldRowKey = rowKey;
        Iterator iterator = rowKey.getSubPathIterator(commonPathLength);
        while (iterator.hasNext()) {
            Object pathSegment = iterator.next();
            TreeNode childRowTreeData = this.rowTreeData.getChild(pathSegment);
            if (childRowTreeData == null) {
                if (!allowCreate) {
                    return null;
                }
                childRowTreeData = new TreeNodeImpl();
                this.rowTreeData.addChild(pathSegment, childRowTreeData);
            }
            this.rowTreeData = childRowTreeData;
        }
        return this.rowTreeData;
    }

    public boolean isRowAvailable() {
        TreeNode data = this.locateTreeNode(this.currentRowKey);
        return data != null;
    }

    public Object getRowData() {
        TreeNode treeNode = this.locateTreeNode(this.currentRowKey);
        if (treeNode != null) {
            return treeNode.getData();
        }
        return null;
    }

    public boolean isLeaf() {
        TreeNode treeNode = this.locateTreeNode(this.currentRowKey);
        if (treeNode != null) {
            return treeNode.isLeaf();
        }
        throw new IllegalStateException("No tree element available or row key not set!");
    }

    public void walkModel(FacesContext context, DataVisitor visitor, TreeRange range, TreeRowKey key, Object argument, boolean last) throws IOException {
        this.walk(context, visitor, range, key, argument, last);
    }
}

