/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.persistence.db.type;

import java.io.Reader;

public class StringBufferReader
extends Reader {
    private final StringBuffer buffer;
    private final int length;
    private int next;
    private int mark;

    public StringBufferReader(StringBuffer buffer) {
        super(buffer);
        this.buffer = buffer;
        this.length = buffer.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        Object object = this.lock;
        synchronized (object) {
            if (this.next >= this.length) {
                return -1;
            }
            return this.buffer.charAt(this.next++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.next >= this.length) {
                return -1;
            }
            int n = Math.min(this.length - this.next, len);
            this.buffer.getChars(this.next, this.next += n, cbuf, off);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long ns) {
        Object object = this.lock;
        synchronized (object) {
            if (this.next >= this.length) {
                return 0L;
            }
            long n = Math.min((long)(this.length - this.next), ns);
            n = Math.max((long)(-this.next), n);
            this.next = (int)((long)this.next + n);
            return n;
        }
    }

    public boolean ready() {
        return true;
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readAheadLimit) {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mark = this.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.next = this.mark;
        }
    }

    public void close() {
    }
}

