/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc.recovery;

import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import oracle.jdbc.xa.client.OracleXADataSource;

public class OracleXARecovery
implements XAResourceRecovery {
    public static final String DATABASE_URL = "DatabaseURL";
    public static final String USER_NAME = "UserName";
    public static final String PASSWORD = "Password";
    private XAConnection _connection;
    private XADataSource _dataSource;
    private LocalConnectionEventListener _connectionEventListener;
    private Properties _props;
    private String _dbURL;
    private String _user;
    private String _password;
    private boolean _hasMoreResources;
    static /* synthetic */ Class class$com$arjuna$common$internal$util$propertyservice$plugins$io$XMLFilePlugin;

    public OracleXARecovery() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(1L, 4L, 2048L, "JDBCXARecovery()");
        }
        this._props = null;
        this._hasMoreResources = false;
        this._connectionEventListener = new LocalConnectionEventListener();
    }

    public boolean initialise(String parameter) throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(1L, 4L, 2048L, "JDBCXARecovery.initialise(" + parameter + ")");
        }
        if (parameter == null) {
            return false;
        }
        try {
            jdbcPropertyManager.propertyManager.load((class$com$arjuna$common$internal$util$propertyservice$plugins$io$XMLFilePlugin == null ? (class$com$arjuna$common$internal$util$propertyservice$plugins$io$XMLFilePlugin = OracleXARecovery.class$("com.arjuna.common.internal.util.propertyservice.plugins.io.XMLFilePlugin")) : class$com$arjuna$common$internal$util$propertyservice$plugins$io$XMLFilePlugin).getName(), parameter);
            this._props = jdbcPropertyManager.propertyManager.getProperties();
            this._dbURL = this._props.getProperty(DATABASE_URL);
            this._user = this._props.getProperty(USER_NAME);
            this._password = this._props.getProperty(PASSWORD);
        }
        catch (Exception e) {
            if (jdbcLogger.loggerI18N.isWarnEnabled()) {
                jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.recovery.oracle.initexp", new Object[]{e});
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public synchronized XAResource getXAResource() throws SQLException {
        this.createConnection();
        return this._connection.getXAResource();
    }

    public boolean hasMoreResources() {
        if (this._dataSource == null) {
            try {
                this.createDataSource();
            }
            catch (SQLException sqlException) {
                return false;
            }
        }
        if (this._dataSource != null) {
            this._hasMoreResources = !this._hasMoreResources;
            return this._hasMoreResources;
        }
        return false;
    }

    private final void createDataSource() throws SQLException {
        try {
            if (this._dataSource == null) {
                OracleXADataSource dataSource = new OracleXADataSource();
                dataSource.setURL(this._dbURL);
                this._dataSource = dataSource;
                if (this._dataSource == null) {
                    throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.oracle.recjndierror"));
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.toString());
        }
    }

    private final void createConnection() throws SQLException {
        try {
            if (this._dataSource == null) {
                this.createDataSource();
            }
            if (this._connection == null) {
                this._connection = this._user == null && this._password == null ? this._dataSource.getXAConnection() : this._dataSource.getXAConnection(this._user, this._password);
                this._connection.addConnectionEventListener(this._connectionEventListener);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LocalConnectionEventListener
    implements ConnectionEventListener {
        private LocalConnectionEventListener() {
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            OracleXARecovery.this._connection.removeConnectionEventListener(OracleXARecovery.this._connectionEventListener);
            OracleXARecovery.this._connection = null;
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            OracleXARecovery.this._connection.removeConnectionEventListener(OracleXARecovery.this._connectionEventListener);
            OracleXARecovery.this._connection = null;
        }
    }
}

