/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.group;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jboss.util.Classes;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.group.ValueList;

public interface ValueListHandler {
    public static final ValueListHandler IMMUTABLE = new ValueListHandler(){

        public Object newInstance(ValueList valueList) {
            Class cls = valueList.getTargetClass();
            Map map = valueList.getNonRequiredValues();
            Collection values = map.values();
            if (values.isEmpty()) {
                throw new JBossXBRuntimeException("Value list does not contain non-required values.");
            }
            Constructor<?> ctor = null;
            Constructor<?>[] ctors = cls.getConstructors();
            if (ctors == null || ctors.length == 0) {
                throw new JBossXBRuntimeException("The class has no declared constructors: " + cls);
            }
            for (int i = 0; i < ctors.length; ++i) {
                Class<?>[] types = ctors[i].getParameterTypes();
                if (types == null || types.length == 0) {
                    throw new IllegalStateException("Found no-arg constructor for immutable " + cls);
                }
                if (types.length != map.size()) continue;
                ctor = ctors[i];
                int typeInd = 0;
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    Class type;
                    if ((type = types[typeInd++]).isPrimitive()) {
                        type = Classes.getPrimitiveWrapper(type);
                    }
                    if (type.isAssignableFrom(iter.next().getClass())) continue;
                    ctor = null;
                    break;
                }
                if (ctor != null) break;
            }
            if (ctor == null) {
                StringBuffer buf = new StringBuffer();
                buf.append("There is no ctor in ").append(cls).append(" that would take the following arguments:\n");
                int cnt = 0;
                Iterator i = values.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    buf.append(' ').append(++cnt).append(") ").append(o.getClass()).append(": ").append(o).append('\n');
                }
                throw new IllegalStateException(buf.toString());
            }
            try {
                return ctor.newInstance(values.toArray());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create immutable instance of " + cls + " using arguments: " + values + ": " + e.getMessage());
            }
        }
    };

    public Object newInstance(ValueList var1);
}

