DnD.getDnDDefaultParams = function(elt) {
	var attr = elt.attributes["rich:defaultdndparams"];

	if (attr) {
		return attr.value.parseJSON();
	}

	return null;
}

DnD.getDnDMergedParams = function(elt, name) {
	var params = DnD.getDnDDefaultParams(elt);

	var attr = elt.attributes[name];

	if (attr) {
		var dndParams = attr.value.parseJSON();
		if (params) {
			if (dndParams) {
				Object.extend(params, dndParams);
			}
		} else {
			params = dndParams;
		}
	}

	return params;
};

DnD.getDnDDragParams = function(elt) {
	return DnD.getDnDMergedParams(elt, "rich:dragdndparams");
};

DnD.getDnDDropParams = function(elt) {
	return DnD.getDnDMergedParams(elt, "rich:dropdndparams");
};

DnD.setDefaultDnDParams = function(params) {
	if (params) {
		if (drag && drag.source && drag.source.getDraggableItems && drag.source.getDraggableItems() > 1) {
	    	if (!params) {
	        	params = {};
	        }
	            
            var itemsCount = drag.source.getDraggableItems();
            params["count"] = itemsCount;
			if (!params["label"]) {
				params["label"] = params["count"] + " " + (params["units"] ? 
					params["units"] : "items");
			}
		}
	}
};
