/**
 * @author Maksim Kaszynski
 * base class for draggable component.
 */
DnD.Draggable = function() {};

DnD.Draggable.prototype = {

	getElement: function() {
		return $(this.id);
	},

	getDnDDefaultParams: function() {
		return DnD.getDnDDefaultParams(this.getElement());
	},

	getDnDDragParams: function() {
		return DnD.getDnDDragParams(this.getElement());
	},

	/**
	 * @return type of draggable content
	 */
	getContentType: function() {
		return "ZZZZZ";
	},
	/**
	 * implementations are responsible for getting drag indicator
	 * @return DnD.Indicator
	 */
	getIndicator: function() {
		return null;
	},

	getOrCreateDefaultIndicator: function() {
        var dragDiv = $("_rfDefaultDragIndicator");
        if (!dragDiv) {        		
	   		dragDiv = document.createElement("div");
	        dragDiv.id = "_rfDefaultDragIndicatorLeft";
	        document.body.appendChild(dragDiv);
	        dragDiv = document.createElement("div");
	        dragDiv.id = "_rfDefaultDragIndicatorRight";
	        document.body.appendChild(dragDiv);
	        dragDiv = document.createElement("div");
	        dragDiv.id = "_rfDefaultDragIndicatorBottom";
	        Element.setStyle(dragDiv, {"font-size" : "0px"});
	        document.body.appendChild(dragDiv);
        	
            dragDiv = document.createElement("div");
            dragDiv.id = "_rfDefaultDragIndicator";
            Element.setStyle(dragDiv, {"font-size" : "0px"});
            Object.extend(dragDiv, DefaultDragIndicator);            	
            document.body.appendChild(dragDiv);
        }
        DefaultDragIndicator.changeIndicatorColor(dragDiv, "black");
        
        return dragDiv;
    },

    setIndicator: function(event) {
		var indicator = this.getIndicator();

		if (indicator) {
			var dndParams = this.getDnDDragParams();

			DnD.setDefaultDnDParams(dndParams);

            if (this.getDraggableItems && this.getDraggableItems() > 1) {
	            indicator.setContent("default", false, dndParams);
            } else {
	            indicator.setContent("default", true, dndParams);
            }
		}
	},

	startDrag : function(event) {
		var type = this.getContentType();
		var indicator = this.getIndicator();
		var drag = new DnD.Drag(this, indicator, type);
		
		if (indicator.id.indexOf("_rfDefaultDragIndicator") != -1) {			
			var target = drag.source.getElement();
			var offSets = Position.cumulativeOffset(target);
			indicator.indicatorWidth = Element.getWidth(target);
	        indicator.indicatorHeight = Element.getHeight(target);
			indicator.position(offSets[0], offSets[1]);
			indicator.removalX = Event.pointerX(event) - offSets[0];
			indicator.removalY = Event.pointerY(event) - offSets[1];			
		}
		
		DnD.startDrag(drag);
		DnD.updateDrag(event);
		this.ondragstart(event, drag);
		if (indicator) {			 
			indicator.show();
		}	

		if( this.options && this.options.ondragstart) {
			this.options.ondragstart();
		}

        // cancel out any text selections
        document.body.focus();

        // prevent text selection in IE
        this.onSelectStartHandler = document.onselectstart;
        document.onselectstart = function () { return false; };
    },
	/**
	 *
	 * @param {DnD.Drag} drag
	 */
	endDrag: function(event, drag) {
        document.onselectstart = this.onSelectStartHandler;

        var indicator = drag.indicator;
		if (indicator) {
			indicator.hide();
		}
		this.ondragend(event, drag);

		if( this.options && this.options.ondragend) {
			this.options.ondragend();
		}
    },
	/**
	 * cubclasses may define custom behavior
	 * @param {Object} drag
	 */
	ondragstart: function(event, drag) {
	
	},

	ondragend: function (event, drag) {

	}
};

DefaultDragIndicator = {

    setContent: function(name, single, params) {
	},

	show: function() {
        if (window.drag && window.drag.source) {
            var target = window.drag.source.getElement();

            Element.setStyle(this, {"width": Element.getWidth(target) + "px", "height": "1px"});
            Element.show(this);
            this.style.position = 'absolute';
            
            var elt = $("_rfDefaultDragIndicatorLeft");
    		if (elt) {
    			Element.setStyle(elt, {"width": "1px", "height": Element.getHeight(target) + "px"});
    			Element.show(elt);
		           elt.style.position = 'absolute';
    		}
    		elt = $("_rfDefaultDragIndicatorRight");
    		if (elt) {
    			Element.setStyle(elt, {"width": "1px", "height": Element.getHeight(target) + "px"});
    			Element.show(elt);
		    	elt.style.position = 'absolute';
    		}    			
    		elt = $("_rfDefaultDragIndicatorBottom");
    		if (elt) {
    			Element.setStyle(elt, {"width": Element.getWidth(target) + "px", "height": "1px"});
    			Element.show(elt);
		        elt.style.position = 'absolute';    			
    		}            
        }
    },

	hide: function() {
		Element.hide(this);
		this.style.position = '';
		
		var elt = $("_rfDefaultDragIndicatorLeft");
    	if (elt) {
    		Element.hide(elt);
			elt.style.position = '';
    	}
    	elt = $("_rfDefaultDragIndicatorRight");
    	if (elt) {
    		Element.hide(elt);
			elt.style.position = '';
    	}    			
    	elt = $("_rfDefaultDragIndicatorBottom");
    	if (elt) {
    		Element.hide(elt);
			elt.style.position = '';
    	} 
	},

    position: function(x, y) {
   		if (this.removalX && this.removalY) {
				x -= (this.removalX + 5);
				y -= (this.removalY + 14);
		} 
        Element.setStyle(this, {"left": x + "px", "top": y + "px"});
        
        var elt = $("_rfDefaultDragIndicatorLeft");
    	if (elt) {    				
    		Element.setStyle(elt, {"left": x + "px", "top": y + "px"});
    	}
    	x += this.indicatorWidth;				
    	elt = $("_rfDefaultDragIndicatorRight");
    	if (elt) {
    		Element.setStyle(elt, {"left": x + "px", "top": y + "px"});
    	} 
    	x -= this.indicatorWidth;				
    	y += this.indicatorHeight;   			
    	elt = $("_rfDefaultDragIndicatorBottom");
    	if (elt) {
    		Element.setStyle(elt, {"left": x + "px", "top": y + "px"});
    	}
    },

    accept: function() {
    	this.changeIndicatorColor(this, "green");
    },

    reject: function() {
	    this.changeIndicatorColor(this, "red");
    },

    leave: function() {
    	this.changeIndicatorColor(this, "black");
    },
    
    changeIndicatorColor: function(indicator, color) {
    	Element.setStyle(indicator, {"border-top" : "1px dashed "+color});
    			
		var elt = $("_rfDefaultDragIndicatorLeft");
		if (elt) {
			Element.setStyle(elt, {"border-left" : "1px dashed "+color});
		}
		elt = $("_rfDefaultDragIndicatorRight");
		if (elt) {
			Element.setStyle(elt, {"border-right" : "1px dashed "+color});
		}
		elt = $("_rfDefaultDragIndicatorBottom");
		if (elt) {
			Element.setStyle(elt, {"border-bottom" : "1px dashed "+color});
		}
    }
};
