/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.docproc.revdiff.test;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.hibernate.docproc.revdiff.ModuleElementsComparator;
import org.hibernate.docproc.revdiff.ModuleElementsExtractor;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RevDiffTest
extends TestCase {
    private XMLReader parser;
    private String orgFileName = "org/hibernate/docproc/revdiff/test/test.xml";
    private String copyFileName = "org/hibernate/docproc/revdiff/test/test.copy.xml";
    private Set moduleElements = new HashSet();

    public RevDiffTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.parser = XMLReaderFactory.createXMLReader();
        this.parser.setFeature("http://xml.org/sax/features/validation", false);
        this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }

    public void testModuleElementExtraction() throws Exception {
        this.parser.setContentHandler(new ModuleElementsExtractor(this.moduleElements));
        this.parser.parse(this.orgFileName);
        RevDiffTest.assertEquals((int)this.moduleElements.size(), (int)4);
    }

    public void testModuleElementComparision() throws Exception {
        this.parser.setContentHandler(new ModuleElementsComparator(this.moduleElements));
        this.parser.parse(this.copyFileName);
        RevDiffTest.assertEquals((int)this.moduleElements.size(), (int)5);
    }
}

