/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection.pojo;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Transient;
import org.hibernate.Session;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.entity.InjectedEntityManager;
import org.jboss.ejb3.entity.InjectedHibernateSession;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.injection.pojo.InjectionHelper;
import org.jboss.ejb3.injection.pojo.PojoInjector;

public class PersistenceContextInjector
implements PojoInjector {
    private Hashtable initialContextProperties;

    public PersistenceContextInjector(Hashtable initialContextProperties) {
        this.initialContextProperties = initialContextProperties;
    }

    protected Object getEntityManager(boolean isTransient, Class emType, PersistenceContextType type, ManagedEntityManagerFactory factory) {
        if (type == PersistenceContextType.EXTENDED) {
            throw new RuntimeException("Extended persistence contexts can only be injected in stateful beans");
        }
        Serializable entityManager = emType.getName().equals(Session.class.getName()) ? new InjectedHibernateSession(factory, this.initialContextProperties) : new InjectedEntityManager(factory, this.initialContextProperties);
        return entityManager;
    }

    protected ManagedEntityManagerFactory getManagedEntityManagerFactory(PersistenceContext ref) throws NamingException {
        if (ref.unitName() == null || ref.unitName().equals("")) {
            throw new RuntimeException("You must specify a unit name for @PersistenceContext");
        }
        InitialContext ctx = EJB3Util.getInitialContext(this.initialContextProperties);
        ManagedEntityManagerFactory factory = (ManagedEntityManagerFactory)ctx.lookup("java:/managedEntityFactories/" + ref.unitName());
        return factory;
    }

    public void inject(Method m, Annotation annotation, Object pojo) {
        InjectionHelper.checkMethodSignature(m, annotation);
        try {
            boolean isTransient = m.isAnnotationPresent(Transient.class);
            PersistenceContext pc = m.getAnnotation(PersistenceContext.class);
            ManagedEntityManagerFactory factory = this.getManagedEntityManagerFactory(pc);
            Object entityManager = this.getEntityManager(isTransient, m.getParameterTypes()[0], pc.type(), factory);
            m.invoke(pojo, entityManager);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void inject(Field f, Annotation annotation, Object pojo) {
        try {
            boolean isTransient = f.isAnnotationPresent(Transient.class);
            PersistenceContext pc = f.getAnnotation(PersistenceContext.class);
            ManagedEntityManagerFactory factory = this.getManagedEntityManagerFactory(pc);
            Object entityManager = this.getEntityManager(isTransient, f.getType(), pc.type(), factory);
            f.setAccessible(true);
            f.set(pojo, entityManager);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

