/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.filter;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.RequestConstants;
import com.opensymphony.module.sitemesh.filter.PageResponse;
import com.opensymphony.module.sitemesh.filter.WriterResponse;
import com.opensymphony.module.sitemesh.util.Container;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class PageFilter
implements Filter,
RequestConstants {
    private FilterConfig filterConfig = null;
    private Factory factory = null;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getAttribute("__sitemesh__filterapplied") != null) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            Page page;
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            Object object = (HttpServletResponse)servletResponse;
            httpServletRequest.setAttribute("__sitemesh__filterapplied", (Object)Boolean.TRUE);
            if (Container.get() == 1) {
                httpServletRequest.getSession(true);
            }
            if (Container.get() == 3 || Container.get() == 1) {
                object = new WriterResponse((HttpServletResponse)object);
            }
            if ((page = this.parsePage(httpServletRequest, (HttpServletResponse)object, filterChain)) != null) {
                page.setRequest(httpServletRequest);
                Decorator decorator = this.factory.getDecoratorMapper().getDecorator(httpServletRequest, page);
                if (decorator != null && decorator.getPage() != null) {
                    this.applyDecorator(page, decorator, httpServletRequest, (HttpServletResponse)object);
                    page = null;
                    return;
                }
                this.writeOriginal((HttpServletResponse)object, page);
                page = null;
            }
        }
    }

    public void init(FilterConfig filterConfig) {
        if (filterConfig != null) {
            this.filterConfig = filterConfig;
            this.factory = Factory.getInstance(new Config(filterConfig));
        } else {
            this.destroy();
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.init(filterConfig);
    }

    public void destroy() {
        this.factory = null;
    }

    private Page parsePage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            PageResponse pageResponse = new PageResponse(httpServletResponse, new Config(this.filterConfig));
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)pageResponse);
            Page page = (Page)httpServletRequest.getAttribute("__sitemesh__page");
            if (page == null) {
                page = pageResponse.getPage();
            }
            pageResponse.closeStream();
            return page;
        }
        catch (IllegalStateException illegalStateException) {
            if (Container.get() != 4) {
                throw illegalStateException;
            }
            return null;
        }
    }

    private void writeOriginal(HttpServletResponse httpServletResponse, Page page) throws IOException {
        httpServletResponse.setContentLength(page.getContentLength());
        page.writePage((OutputStream)httpServletResponse.getOutputStream());
    }

    private void applyDecorator(Page page, Decorator decorator, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            httpServletRequest.setAttribute("__sitemesh__page", (Object)page);
            ServletContext servletContext = this.filterConfig.getServletContext();
            if (decorator.getURIPath() != null && servletContext.getContext(decorator.getURIPath()) != null) {
                servletContext = servletContext.getContext(decorator.getURIPath());
            }
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(decorator.getPage());
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            if (Container.get() == 1) {
                httpServletResponse.getWriter().flush();
                httpServletResponse.getOutputStream().flush();
            }
            httpServletRequest.removeAttribute("__sitemesh__page");
        }
        catch (RuntimeException runtimeException) {
            if (Container.get() == 1) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
    }
}

