/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;

public class SeamVariableResolver
extends VariableResolver {
    private static final Log log = LogFactory.getLog(SeamVariableResolver.class);
    private VariableResolver jsfVariableResolver;

    public SeamVariableResolver(VariableResolver jsfVariableResolver) {
        this.jsfVariableResolver = jsfVariableResolver;
    }

    public Object resolveVariable(FacesContext facesContext, String name) throws EvaluationException {
        name = name.replace('$', '.');
        log.debug((Object)("resolving name: " + name));
        Object component = Component.getInstance(name, true);
        Object managedBean = this.jsfVariableResolver.resolveVariable(facesContext, name);
        if (component == null) {
            if (managedBean == null) {
                log.debug((Object)"could not resolve name");
                return null;
            }
            log.debug((Object)"resolved name to managed bean");
            return managedBean;
        }
        if (managedBean != null && managedBean != component) {
            log.warn((Object)"Seam component hides managed bean with same name");
        }
        log.debug((Object)"resolved name to seam component");
        return component;
    }
}

