/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.microcontainer;

import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.util.ReflectHelper;
import org.jboss.seam.util.Naming;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateFactory {
    private String cfgResourceName;
    private Properties cfgProperties;
    private List<String> mappingClasses;
    private List<String> mappingFiles;
    private List<String> mappingJars;
    private List<String> mappingPackages;
    private List<String> mappingResources;

    public Object getSessionFactory() throws Exception {
        AnnotationConfiguration acfg = new AnnotationConfiguration();
        if (this.cfgProperties != null) {
            acfg.setProperties(this.cfgProperties);
        }
        if (Naming.getInitialContextProperties() != null) {
            Hashtable hash = Naming.getInitialContextProperties();
            for (Map.Entry entry : hash.entrySet()) {
                acfg.setProperty("hibernate.jndi." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.cfgProperties == null && this.cfgResourceName == null) {
            acfg.configure();
        } else if (this.cfgProperties == null && this.cfgResourceName != null) {
            acfg.configure(this.cfgResourceName);
        }
        if (this.mappingClasses != null) {
            for (String className : this.mappingClasses) {
                acfg.addAnnotatedClass(ReflectHelper.classForName((String)className));
            }
        }
        if (this.mappingFiles != null) {
            for (String fileName : this.mappingFiles) {
                acfg.addFile(fileName);
            }
        }
        if (this.mappingJars != null) {
            for (String jarName : this.mappingJars) {
                acfg.addJar(new File(jarName));
            }
        }
        if (this.mappingPackages != null) {
            for (String packageName : this.mappingPackages) {
                acfg.addPackage(packageName);
            }
        }
        if (this.mappingResources != null) {
            for (String resourceName : this.mappingResources) {
                acfg.addResource(resourceName);
            }
        }
        return acfg.buildSessionFactory();
    }

    public String getCfgResourceName() {
        return this.cfgResourceName;
    }

    public void setCfgResourceName(String cfgFileName) {
        this.cfgResourceName = cfgFileName;
    }

    public Properties getCfgProperties() {
        return this.cfgProperties;
    }

    public void setCfgProperties(Properties cfgProperties) {
        this.cfgProperties = cfgProperties;
    }

    public List<String> getMappingClasses() {
        return this.mappingClasses;
    }

    public void setMappingClasses(List<String> mappingClasses) {
        this.mappingClasses = mappingClasses;
    }

    public List<String> getMappingFiles() {
        return this.mappingFiles;
    }

    public void setMappingFiles(List<String> mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    public List<String> getMappingJars() {
        return this.mappingJars;
    }

    public void setMappingJars(List<String> mappingJars) {
        this.mappingJars = mappingJars;
    }

    public List<String> getMappingPackages() {
        return this.mappingPackages;
    }

    public void setMappingPackages(List<String> mappingPackages) {
        this.mappingPackages = mappingPackages;
    }

    public List<String> getMappingResources() {
        return this.mappingResources;
    }

    public void setMappingResources(List<String> mappingResources) {
        this.mappingResources = mappingResources;
    }
}

