/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.xslt;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import webwork.util.ValueStack;

public class XMLResultAdapter {
    Map classes = new HashMap();
    Map pdCache = new HashMap();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;

    public void markupObject(StringBuffer buff, Object o, String propertyName) {
        this.markupObject(buff, new Stack(), o, propertyName);
    }

    protected void markupObject(StringBuffer buff, Stack visitedObjects, Object o, String propertyName) {
        if (o == null) {
            buff.append("null");
        } else if (this.isBasicType(o)) {
            this.markupBasicType(buff, visitedObjects, o, propertyName);
        } else if (o instanceof String) {
            this.markupString(buff, visitedObjects, (String)o, propertyName);
        } else if (o instanceof Properties) {
            this.markupProperties(buff, visitedObjects, (Properties)o, propertyName);
        } else if (o instanceof Map) {
            this.markupMap(buff, visitedObjects, (Map)o, propertyName);
        } else if (o instanceof Collection) {
            this.markupCollection(buff, visitedObjects, (Collection)o, propertyName);
        } else if (o instanceof Node) {
            this.markupNode(buff, visitedObjects, (Node)o, propertyName);
        } else if (o.getClass().isArray()) {
            this.markupArray(buff, visitedObjects, o, propertyName);
        } else {
            this.markupBean(buff, visitedObjects, o, propertyName);
        }
    }

    protected void markupBean(StringBuffer buff, Stack visitedObjects, Object object, String propertyName) {
        block11: {
            visitedObjects.push(object);
            try {
                PropertyDescriptor[] pd = this.getPropertyDescriptors(object);
                if (pd.length > 0) {
                    buff.append("<");
                    buff.append(propertyName);
                    buff.append(">");
                    int i = 0;
                    while (i < pd.length) {
                        try {
                            Method readMethod = pd[i].getReadMethod();
                            if (readMethod != null) {
                                Object value = readMethod.invoke(object, null);
                                while (value instanceof ValueStack.ValueHolder) {
                                    value = ((ValueStack.ValueHolder)value).getValue();
                                }
                                if (visitedObjects.contains(value)) {
                                    LogFactory.getLog(this.getClass()).debug((Object)("Skipping duplicate" + value + "[" + value.getClass() + "]"));
                                } else {
                                    this.markupObject(buff, visitedObjects, value, pd[i].getName());
                                }
                            }
                        }
                        catch (InvocationTargetException e) {
                            LogFactory.getLog(this.getClass()).error((Object)e.getTargetException());
                        }
                        catch (IllegalAccessException e) {
                            LogFactory.getLog(this.getClass()).error((Object)e);
                        }
                        ++i;
                    }
                    buff.append("</");
                    buff.append(propertyName);
                    buff.append(">");
                    break block11;
                }
                this.markupAny(buff, visitedObjects, object, propertyName);
            }
            catch (IntrospectionException e) {
                LogFactory.getLog(this.getClass()).error((Object)e.getMessage());
            }
        }
        visitedObjects.pop();
    }

    protected void markupBasicType(StringBuffer buff, Stack visitedObjects, Object object, String propertyName) {
        buff.append("<");
        buff.append(propertyName);
        buff.append(">");
        buff.append(object.toString());
        buff.append("</");
        buff.append(propertyName);
        buff.append(">");
    }

    protected void markupString(StringBuffer buff, Stack visitedObjects, String object, String propertyName) {
        buff.append("<");
        buff.append(propertyName);
        buff.append(">");
        buff.append(object);
        buff.append("</");
        buff.append(propertyName);
        buff.append(">");
    }

    protected void markupAny(StringBuffer buff, Stack visitedObjects, Object object, String propertyName) {
        buff.append("<");
        buff.append(propertyName);
        buff.append(">");
        buff.append(object.toString());
        buff.append("</");
        buff.append(propertyName);
        buff.append(">");
    }

    protected void markupMap(StringBuffer buff, Stack visitedObjects, Map map, String propertyName) {
        buff.append("<");
        buff.append(propertyName);
        buff.append(">");
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            buff.append("<entry>");
            this.markupObject(buff, visitedObjects, e.getKey(), "key");
            this.markupObject(buff, visitedObjects, e.getValue(), "value");
            buff.append("</entry>");
        }
        buff.append("</");
        buff.append(propertyName);
        buff.append(">");
    }

    protected void markupProperties(StringBuffer buff, Stack visitedObjects, Properties props, String propertyName) {
        buff.append("<");
        buff.append(propertyName);
        buff.append(">");
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            buff.append("<entry>");
            this.markupObject(buff, visitedObjects, key, "key");
            this.markupObject(buff, visitedObjects, props.getProperty(key), "value");
            buff.append("</entry>");
        }
        buff.append("</");
        buff.append(propertyName);
        buff.append(">");
    }

    protected void markupCollection(StringBuffer buff, Stack visitedObjects, Collection col, String propertyName) {
        buff.append("<");
        buff.append(propertyName);
        buff.append(">");
        Iterator i = col.iterator();
        while (i.hasNext()) {
            this.markupObject(buff, visitedObjects, i.next(), "item");
        }
        buff.append("</");
        buff.append(propertyName);
        buff.append(">");
    }

    protected void markupArray(StringBuffer buff, Stack visitedObjects, Object o, String propertyName) {
        buff.append("<");
        buff.append(propertyName);
        buff.append(">");
        int i = 0;
        while (i < Array.getLength(o)) {
            this.markupObject(buff, visitedObjects, Array.get(o, i), "item");
            ++i;
        }
        buff.append("</");
        buff.append(propertyName);
        buff.append(">");
    }

    protected void markupNode(StringBuffer buff, Stack visitedObjects, Node node, String propertyName) {
        if (propertyName != null) {
            buff.append("<");
            buff.append(propertyName);
            buff.append(">");
        }
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        boolean canonical = false;
        switch (type) {
            case 9: {
                NodeList children = node.getChildNodes();
                int iChild = 0;
                while (iChild < children.getLength()) {
                    this.markupNode(buff, visitedObjects, children.item(iChild), null);
                    ++iChild;
                }
                break;
            }
            case 1: {
                buff.append('<');
                buff.append(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    buff.append(' ');
                    buff.append(attr.getNodeName());
                    buff.append("=\"");
                    buff.append(this.normalize(attr.getNodeValue()));
                    buff.append('\"');
                    ++i;
                }
                buff.append('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i2 = 0;
                while (i2 < len) {
                    this.markupNode(buff, visitedObjects, children.item(i2), null);
                    ++i2;
                }
                break;
            }
            case 5: {
                if (canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    int i = 0;
                    while (i < len) {
                        this.markupNode(buff, visitedObjects, children.item(i), null);
                        ++i;
                    }
                    break;
                }
                buff.append('&');
                buff.append(node.getNodeName());
                buff.append(';');
                break;
            }
            case 4: {
                if (canonical) {
                    buff.append(this.normalize(node.getNodeValue()));
                    break;
                }
                buff.append("<![CDATA[");
                buff.append(node.getNodeValue());
                buff.append("]]>");
                break;
            }
            case 3: {
                buff.append(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                buff.append("<?");
                buff.append(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    buff.append(' ');
                    buff.append(data);
                }
                buff.append("?>");
                break;
            }
        }
        if (type == 1) {
            buff.append("</");
            buff.append(node.getNodeName());
            buff.append('>');
        }
        if (propertyName != null) {
            buff.append("<");
            buff.append(propertyName);
            buff.append(">");
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < len - 1) {
            String name = array[i2].getNodeName();
            int index = i2;
            int j = i2 + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\'': {
                    str.append("&apos;");
                    break;
                }
                case '\n': 
                case '\r': {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    protected boolean isBasicType(Object o) {
        Class<?> type = o.getClass();
        return type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Short.TYPE) || type.equals(Byte.TYPE) || type.equals(Boolean.TYPE) || type.equals(Character.TYPE) || type.equals(Float.TYPE) || type.equals(Double.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = XMLResultAdapter.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(type) || (class$java$lang$Long == null ? (class$java$lang$Long = XMLResultAdapter.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(type) || (class$java$lang$Short == null ? (class$java$lang$Short = XMLResultAdapter.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(type) || (class$java$lang$Byte == null ? (class$java$lang$Byte = XMLResultAdapter.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(type) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XMLResultAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(type) || (class$java$lang$Float == null ? (class$java$lang$Float = XMLResultAdapter.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type) || (class$java$lang$Character == null ? (class$java$lang$Character = XMLResultAdapter.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(type) || (class$java$lang$Double == null ? (class$java$lang$Double = XMLResultAdapter.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type);
    }

    private PropertyDescriptor[] getPropertyDescriptors(Object o) throws IntrospectionException {
        PropertyDescriptor[] pd = (PropertyDescriptor[])this.pdCache.get(o.getClass());
        if (pd == null) {
            pd = Introspector.getBeanInfo(o.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = XMLResultAdapter.class$("java.lang.Object")) : class$java$lang$Object).getPropertyDescriptors();
            this.pdCache.put(o.getClass(), pd);
        }
        return pd;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

