/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc.tags;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import xjavadoc.XTagFactory;

public final class TagIntrospector {
    static /* synthetic */ Class class$xjavadoc$XTag;

    public void registerTags(String classpath, XTagFactory tagFactory) {
        StringTokenizer st = new StringTokenizer(classpath, System.getProperty("path.separator"));
        while (st.hasMoreTokens()) {
            File classpathElement = new File(st.nextToken());
            if (classpathElement.exists()) {
                List javaBeans = this.findJavaBeans(classpathElement);
                this.registerTags(javaBeans, tagFactory);
                continue;
            }
            System.out.println(classpathElement.getAbsolutePath() + " was on classpath, but doesn't exist.");
        }
    }

    private void registerTags(List javaBeans, XTagFactory tagFactory) {
        Iterator i = javaBeans.iterator();
        while (i.hasNext()) {
            Class javaBean;
            if (!(class$xjavadoc$XTag == null ? TagIntrospector.class$("xjavadoc.XTag") : class$xjavadoc$XTag).isAssignableFrom(javaBean = (Class)i.next())) continue;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(javaBean);
                String tagName = beanInfo.getBeanDescriptor().getName();
                tagFactory.registerTagClass(tagName, javaBean);
            }
            catch (IntrospectionException e) {
                System.out.println("No BeanInfo for " + javaBean.getName());
            }
        }
    }

    private List findJavaBeans(File dirOrJar) {
        ArrayList result = new ArrayList();
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{dirOrJar.toURL()}, this.getClass().getClassLoader());
            Manifest manifest = null;
            if (dirOrJar.isDirectory()) {
                try {
                    manifest = new Manifest(new FileInputStream(new File(dirOrJar, "META-INF/MANIFEST.MF")));
                }
                catch (IOException e) {}
            } else {
                try {
                    JarFile jarFile = new JarFile(dirOrJar);
                    manifest = jarFile.getManifest();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (manifest != null) {
                Iterator<String> entryNames = manifest.getEntries().keySet().iterator();
                while (entryNames.hasNext()) {
                    Attributes attributes;
                    String javaBean;
                    String entryName = entryNames.next();
                    if (!entryName.endsWith(".class") || !"true".equalsIgnoreCase(javaBean = (attributes = manifest.getAttributes(entryName)).getValue("Java-Bean"))) continue;
                    String className = entryName.substring(0, entryName.length() - 6);
                    className = className.replace('/', '.');
                    try {
                        Class<?> beanClass = classLoader.loadClass(className);
                        result.add(beanClass);
                    }
                    catch (ClassNotFoundException e) {
                        String errorMessage = className + " was declared as a Java-Bean in the manifest, but the class was not found.";
                        e.printStackTrace();
                        throw new IllegalStateException(errorMessage);
                    }
                }
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

