/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.struct;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.bpel.graph.def.LinkDefinition;
import org.jbpm.bpel.graph.struct.StructuredActivity;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class Flow
extends StructuredActivity {
    private Map links = new HashMap();
    private static final Log log = LogFactory.getLog((Class)Flow.class);
    private static final long serialVersionUID = 1L;

    public Flow() {
    }

    public Flow(String name) {
        super(name);
    }

    public void execute(ExecutionContext exeContext) {
        Token flowToken = this.initializeLinks(exeContext.getToken());
        Token[] concurrentTokens = this.createConcurrentTokens(flowToken);
        List activities = this.getNodes();
        int n = concurrentTokens.length;
        for (int i = 0; i < n && !flowToken.hasEnded(); ++i) {
            Activity activity = (Activity)((Object)activities.get(i));
            Token concurrentToken = concurrentTokens[i];
            this.begin.leave(new ExecutionContext(concurrentToken), activity.getDefaultArrivingTransition());
        }
    }

    public Token initializeLinks(Token token) {
        if (!this.links.isEmpty()) {
            token = new Token(token, this.getName());
            Iterator linkIt = this.links.values().iterator();
            while (linkIt.hasNext()) {
                LinkDefinition link = (LinkDefinition)linkIt.next();
                link.createInstance(token);
            }
        }
        return token;
    }

    public void terminate(ExecutionContext exeContext) {
        Iterator concurrentTokenIt = exeContext.getToken().getChildren().values().iterator();
        while (concurrentTokenIt.hasNext()) {
            Token concurrentToken = (Token)concurrentTokenIt.next();
            if (concurrentToken.isAbleToReactivateParent()) {
                Activity activity = (Activity)concurrentToken.getNode();
                activity.terminate(new ExecutionContext(concurrentToken));
            }
            concurrentToken.end(false);
        }
    }

    public void leave(ExecutionContext exeContext) {
        Token childToken = exeContext.getToken();
        if (!childToken.isAbleToReactivateParent()) {
            return;
        }
        childToken.setAbleToReactivateParent(false);
        Token parentToken = childToken.getParent();
        if (this.mustReactivateToken(parentToken)) {
            if (!this.links.isEmpty()) {
                parentToken.end(false);
                parentToken = parentToken.getParent();
            }
            this.getEnd().leave(new ExecutionContext(parentToken));
        }
    }

    public Token[] createConcurrentTokens(Token parent) {
        List activities = this.getNodes();
        int activityCount = activities.size();
        Token[] tokens = new Token[activityCount];
        for (int i = 0; i < activityCount; ++i) {
            Activity activity = (Activity)((Object)activities.get(i));
            String tokenName = Flow.generateTokenName(parent, activity.getName());
            tokens[i] = new Token(parent, tokenName);
        }
        return tokens;
    }

    private static String generateTokenName(Token parent, String activityName) {
        if (!parent.hasChild(activityName)) {
            return activityName;
        }
        Map childTokens = parent.getChildren();
        return Flow.generateName(activityName, childTokens != null ? childTokens.keySet() : Collections.EMPTY_SET);
    }

    private static String generateName(String baseText, Set existingNames) {
        StringBuffer nameBuffer = new StringBuffer(baseText);
        int baseLength = baseText.length();
        for (int i = 2; i < Integer.MAX_VALUE; ++i) {
            String altName = nameBuffer.append(i).toString();
            if (!existingNames.contains(altName)) {
                return altName;
            }
            nameBuffer.setLength(baseLength);
        }
        throw new RuntimeException("could not generate name: base=" + baseText);
    }

    protected boolean mustReactivateToken(Token token) {
        Iterator concurrentTokenIt = token.getChildren().values().iterator();
        while (concurrentTokenIt.hasNext()) {
            Token concurrentToken = (Token)concurrentTokenIt.next();
            if (!concurrentToken.isAbleToReactivateParent()) continue;
            log.debug((Object)("flow will not reactivate parent yet, found concurrent token: " + concurrentToken));
            return false;
        }
        return true;
    }

    protected boolean isChildInitial(Activity child) {
        return true;
    }

    public LinkDefinition findLink(String name) {
        LinkDefinition link = this.getLink(name);
        return link != null ? link : super.findLink(name);
    }

    public void addLink(LinkDefinition link) {
        this.links.put(link.getName(), link);
    }

    public Map getLinks() {
        return this.links;
    }

    public LinkDefinition getLink(String linkName) {
        return (LinkDefinition)this.links.get(linkName);
    }

    public void accept(BpelVisitor visitor) {
        visitor.visit(this);
    }
}

