/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.wsdl.parser;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jboss.com.sun.tools.ws.util.xml.XmlUtil;
import org.jboss.com.sun.tools.ws.wsdl.document.BindingOperation;
import org.jboss.com.sun.tools.ws.wsdl.document.Definitions;
import org.jboss.com.sun.tools.ws.wsdl.document.Documentation;
import org.jboss.com.sun.tools.ws.wsdl.document.Fault;
import org.jboss.com.sun.tools.ws.wsdl.document.Operation;
import org.jboss.com.sun.tools.ws.wsdl.document.Port;
import org.jboss.com.sun.tools.ws.wsdl.document.PortType;
import org.jboss.com.sun.tools.ws.wsdl.document.Service;
import org.jboss.com.sun.tools.ws.wsdl.document.jaxws.CustomName;
import org.jboss.com.sun.tools.ws.wsdl.document.jaxws.Exception;
import org.jboss.com.sun.tools.ws.wsdl.document.jaxws.JAXWSBinding;
import org.jboss.com.sun.tools.ws.wsdl.document.jaxws.JAXWSBindingsConstants;
import org.jboss.com.sun.tools.ws.wsdl.document.jaxws.Parameter;
import org.jboss.com.sun.tools.ws.wsdl.framework.Extensible;
import org.jboss.com.sun.tools.ws.wsdl.framework.Extension;
import org.jboss.com.sun.tools.ws.wsdl.framework.ParserContext;
import org.jboss.com.sun.tools.ws.wsdl.framework.WriterContext;
import org.jboss.com.sun.tools.ws.wsdl.parser.ExtensionHandlerBase;
import org.jboss.com.sun.tools.ws.wsdl.parser.NamespaceContextImpl;
import org.jboss.com.sun.tools.ws.wsdl.parser.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXWSBindingExtensionHandler
extends ExtensionHandlerBase {
    private static final XPathFactory xpf = XPathFactory.newInstance();
    private final XPath xpath = xpf.newXPath();

    public String getNamespaceURI() {
        return "http://java.sun.com/xml/ns/jaxws";
    }

    private boolean parseGlobalJAXWSBindings(ParserContext context, Extensible parent, Element e) {
        Element e2;
        String attr;
        context.push();
        context.registerNamespaces(e);
        JAXWSBinding jaxwsBinding = JAXWSBindingExtensionHandler.getJAXWSExtension(parent);
        if (jaxwsBinding == null) {
            jaxwsBinding = new JAXWSBinding();
        }
        if ((attr = XmlUtil.getAttributeOrNull(e, "wsdlLocation")) != null) {
            jaxwsBinding.setWsdlLocation(attr);
        }
        if ((attr = XmlUtil.getAttributeOrNull(e, "node")) != null) {
            jaxwsBinding.setNode(attr);
        }
        if ((attr = XmlUtil.getAttributeOrNull(e, "version")) != null) {
            jaxwsBinding.setVersion(attr);
        }
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.PACKAGE)) {
                this.parsePackage(context, jaxwsBinding, e2);
                if (jaxwsBinding.getJaxwsPackage() == null || jaxwsBinding.getJaxwsPackage().getJavaDoc() == null) continue;
                ((Definitions)parent).setDocumentation(new Documentation(jaxwsBinding.getJaxwsPackage().getJavaDoc()));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                this.parseWrapperStyle(context, jaxwsBinding, e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                this.parseAsynMapping(context, jaxwsBinding, e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                this.parseMimeContent(context, jaxwsBinding, e2);
                continue;
            }
            Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
            return false;
        }
        parent.addExtension(jaxwsBinding);
        context.pop();
        context.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jaxwsBinding);
        return true;
    }

    private static JAXWSBinding getJAXWSExtension(Extensible extensible) {
        Iterator iter = extensible.extensions();
        while (iter.hasNext()) {
            Extension extension = (Extension)iter.next();
            if (!extension.getClass().equals(JAXWSBinding.class)) continue;
            return (JAXWSBinding)extension;
        }
        return null;
    }

    private void parseProvider(ParserContext context, Extensible parent, Element e) {
        String val = e.getTextContent();
        if (val == null) {
            return;
        }
        if (val.equals("false") || val.equals("0")) {
            ((JAXWSBinding)parent).setProvider(Boolean.FALSE);
        } else if (val.equals("true") || val.equals("1")) {
            ((JAXWSBinding)parent).setProvider(Boolean.TRUE);
        }
    }

    private void parseJAXBBindings(ParserContext context, Extensible parent, Element e) {
        JAXWSBinding binding = (JAXWSBinding)parent;
        binding.addJaxbBindings(e);
    }

    private void parsePackage(ParserContext context, Extensible parent, Element e) {
        String packageName = XmlUtil.getAttributeOrNull(e, "name");
        JAXWSBinding binding = (JAXWSBinding)parent;
        binding.setJaxwsPackage(new CustomName(packageName, this.getJavaDoc(e)));
    }

    private void parseWrapperStyle(ParserContext context, Extensible parent, Element e) {
        String val = e.getTextContent();
        if (val == null) {
            return;
        }
        if (val.equals("false") || val.equals("0")) {
            ((JAXWSBinding)parent).setEnableWrapperStyle(Boolean.FALSE);
        } else if (val.equals("true") || val.equals("1")) {
            ((JAXWSBinding)parent).setEnableWrapperStyle(Boolean.TRUE);
        }
    }

    private void parseAsynMapping(ParserContext context, Extensible parent, Element e) {
        String val = e.getTextContent();
        if (val == null) {
            return;
        }
        if (val.equals("false") || val.equals("0")) {
            ((JAXWSBinding)parent).setEnableAsyncMapping(Boolean.FALSE);
        } else if (val.equals("true") || val.equals("1")) {
            ((JAXWSBinding)parent).setEnableAsyncMapping(Boolean.TRUE);
        }
    }

    private void parseMimeContent(ParserContext context, Extensible parent, Element e) {
        String val = e.getTextContent();
        if (val == null) {
            return;
        }
        if (val.equals("false") || val.equals("0")) {
            ((JAXWSBinding)parent).setEnableMimeContentMapping(Boolean.FALSE);
        } else if (val.equals("true") || val.equals("1")) {
            ((JAXWSBinding)parent).setEnableMimeContentMapping(Boolean.TRUE);
        }
    }

    private void parseMethod(ParserContext context, JAXWSBinding jaxwsBinding, Element e) {
        String methodName = XmlUtil.getAttributeOrNull(e, "name");
        String javaDoc = this.getJavaDoc(e);
        CustomName name = new CustomName(methodName, javaDoc);
        jaxwsBinding.setMethodName(name);
    }

    private void parseParameter(ParserContext context, JAXWSBinding jaxwsBinding, Element e) {
        String part = XmlUtil.getAttributeOrNull(e, "part");
        Element msgPartElm = this.evaluateXPathNode(e.getOwnerDocument(), part, new NamespaceContextImpl(e));
        Node msgElm = msgPartElm.getParentNode();
        String partName = XmlUtil.getAttributeOrNull(msgPartElm, "name");
        String msgName = XmlUtil.getAttributeOrNull((Element)msgElm, "name");
        if (partName == null || msgName == null) {
            return;
        }
        String val = XmlUtil.getAttributeOrNull(msgPartElm, "element");
        String element = XmlUtil.getAttributeOrNull(e, "childElementName");
        String name = XmlUtil.getAttributeOrNull(e, "name");
        QName elementName = null;
        if (element != null) {
            String uri = e.lookupNamespaceURI(XmlUtil.getPrefix(element));
            elementName = uri == null ? null : new QName(uri, XmlUtil.getLocalPart(element));
        }
        jaxwsBinding.addParameter(new Parameter(msgName, partName, elementName, name));
    }

    private Element evaluateXPathNode(Node target, String expression, NamespaceContext namespaceContext) {
        NodeList nlst;
        try {
            this.xpath.setNamespaceContext(namespaceContext);
            nlst = (NodeList)this.xpath.evaluate(expression, target, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            Util.fail("internalizer.XPathEvaluationError", e.getMessage());
            return null;
        }
        if (nlst.getLength() == 0) {
            Util.fail("internalizer.XPathEvaluatesToNoTarget", new Object[]{expression});
            return null;
        }
        if (nlst.getLength() != 1) {
            Util.fail("internalizer.XPathEvaulatesToTooManyTargets", new Object[]{expression, nlst.getLength()});
            return null;
        }
        Node rnode = nlst.item(0);
        if (!(rnode instanceof Element)) {
            Util.fail("internalizer.XPathEvaluatesToNonElement", new Object[]{expression});
            return null;
        }
        return (Element)rnode;
    }

    private void parseClass(ParserContext context, JAXWSBinding jaxwsBinding, Element e) {
        String className = XmlUtil.getAttributeOrNull(e, "name");
        String javaDoc = this.getJavaDoc(e);
        jaxwsBinding.setClassName(new CustomName(className, javaDoc));
    }

    private void parseException(ParserContext context, JAXWSBinding jaxwsBinding, Element e) {
        Element e2;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (!XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.CLASS)) continue;
            String className = XmlUtil.getAttributeOrNull(e2, "name");
            String javaDoc = this.getJavaDoc(e2);
            jaxwsBinding.setException(new Exception(new CustomName(className, javaDoc)));
        }
    }

    protected boolean handleDefinitionsExtension(ParserContext context, Extensible parent, Element e) {
        return this.parseGlobalJAXWSBindings(context, parent, e);
    }

    protected boolean handleTypesExtension(ParserContext context, Extensible parent, Element e) {
        return false;
    }

    protected boolean handlePortTypeExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding();
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                    this.parseWrapperStyle(context, jaxwsBinding, e2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                    this.parseAsynMapping(context, jaxwsBinding, e2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(context, jaxwsBinding, e2);
                    if (jaxwsBinding.getClassName() == null || jaxwsBinding.getClassName().getJavaDoc() == null) continue;
                    ((PortType)parent).setDocumentation(new Documentation(jaxwsBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            parent.addExtension(jaxwsBinding);
            context.pop();
            context.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jaxwsBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handleOperationExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            if (parent instanceof Operation) {
                return this.handlePortTypeOperation(context, (Operation)parent, e);
            }
            if (parent instanceof BindingOperation) {
                return this.handleBindingOperation(context, (BindingOperation)parent, e);
            }
        } else {
            Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
            return false;
        }
        return false;
    }

    private boolean handleBindingOperation(ParserContext context, BindingOperation operation, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding();
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                    this.parseMimeContent(context, jaxwsBinding, e2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.PARAMETER)) {
                    this.parseParameter(context, jaxwsBinding, e2);
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            operation.addExtension(jaxwsBinding);
            context.pop();
            context.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jaxwsBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    private boolean handlePortTypeOperation(ParserContext context, Operation parent, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        JAXWSBinding jaxwsBinding = new JAXWSBinding();
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                this.parseWrapperStyle(context, jaxwsBinding, e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                this.parseAsynMapping(context, jaxwsBinding, e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.METHOD)) {
                this.parseMethod(context, jaxwsBinding, e2);
                if (jaxwsBinding.getMethodName() == null || jaxwsBinding.getMethodName().getJavaDoc() == null) continue;
                parent.setDocumentation(new Documentation(jaxwsBinding.getMethodName().getJavaDoc()));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.PARAMETER)) {
                this.parseParameter(context, jaxwsBinding, e2);
                continue;
            }
            Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
            return false;
        }
        parent.addExtension(jaxwsBinding);
        context.pop();
        context.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jaxwsBinding);
        return true;
    }

    protected boolean handleBindingExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding();
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                    this.parseMimeContent(context, jaxwsBinding, e2);
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            parent.addExtension(jaxwsBinding);
            context.pop();
            context.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jaxwsBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handleInputExtension(ParserContext context, Extensible parent, Element e) {
        return false;
    }

    protected boolean handleOutputExtension(ParserContext context, Extensible parent, Element e) {
        return false;
    }

    protected boolean handleFaultExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding();
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(context, jaxwsBinding, e2);
                    if (jaxwsBinding.getClassName() == null || jaxwsBinding.getClassName().getJavaDoc() == null) continue;
                    ((Fault)parent).setDocumentation(new Documentation(jaxwsBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            parent.addExtension(jaxwsBinding);
            context.pop();
            context.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jaxwsBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handleServiceExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding();
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(context, jaxwsBinding, e2);
                    if (jaxwsBinding.getClassName() == null || jaxwsBinding.getClassName().getJavaDoc() == null) continue;
                    ((Service)parent).setDocumentation(new Documentation(jaxwsBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            parent.addExtension(jaxwsBinding);
            context.pop();
            context.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jaxwsBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handlePortExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            JAXWSBinding jaxwsBinding = new JAXWSBinding();
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.PROVIDER)) {
                    this.parseProvider(context, jaxwsBinding, e2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.METHOD)) {
                    this.parseMethod(context, jaxwsBinding, e2);
                    if (jaxwsBinding.getMethodName() == null || jaxwsBinding.getMethodName().getJavaDoc() == null) continue;
                    ((Port)parent).setDocumentation(new Documentation(jaxwsBinding.getMethodName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", e2.getTagName(), e2.getNamespaceURI());
                return false;
            }
            parent.addExtension(jaxwsBinding);
            context.pop();
            context.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jaxwsBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handleMIMEPartExtension(ParserContext context, Extensible parent, Element e) {
        return false;
    }

    private String getJavaDoc(Element e) {
        Element e2;
        Iterator iter = XmlUtil.getAllChildren(e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (!XmlUtil.matchesTagNS(e2, JAXWSBindingsConstants.JAVADOC)) continue;
            return XmlUtil.getTextForNode(e2);
        }
        return null;
    }

    public void doHandleExtension(WriterContext context, Extension extension) throws IOException {
        if (!(extension instanceof JAXWSBinding)) {
            throw new IllegalArgumentException();
        }
        JAXWSBinding binding = (JAXWSBinding)extension;
        System.out.println("binding.getElementName: " + binding.getElementName());
        context.writeStartTag(binding.getElementName());
        context.writeStartTag(JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE);
        context.writeChars(binding.isEnableWrapperStyle().toString());
        context.writeEndTag(JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE);
        context.writeEndTag(binding.getElementName());
    }
}

