/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import org.hsqldb.util.DataAccessPoint;
import org.hsqldb.util.SQLStatements;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferResultSet;

class TransferTable
implements Serializable {
    Hashtable hTypes;
    DataAccessPoint sourceDb;
    DataAccessPoint destDb;
    SQLStatements Stmts = new SQLStatements();
    Traceable tracer;

    TransferTable(DataAccessPoint dataAccessPoint, String string, String string2, String string3, Traceable traceable) {
        this.sourceDb = dataAccessPoint;
        this.Stmts.sSchema = "";
        if (string2 != null && string2.length() > 0) {
            this.Stmts.sSchema = string2;
        }
        this.Stmts.sType = string3;
        this.Stmts.sDatabaseToConvert = dataAccessPoint.databaseToConvert;
        this.Stmts.sSourceTable = this.Stmts.sDestTable = string;
        this.tracer = traceable;
        if (this.Stmts.sType.compareTo("TABLE") == 0) {
            this.Stmts.sSourceSelect = "SELECT * FROM " + dataAccessPoint.helper.formatName(this.Stmts.sSourceTable) + ";";
        } else if (this.Stmts.sType.compareTo("VIEW") == 0) {
            this.Stmts.sSourceSelect = "";
        }
    }

    void setDest(String string, DataAccessPoint dataAccessPoint) throws Exception {
        this.destDb = dataAccessPoint;
        dataAccessPoint.helper.setSchema(string);
    }

    void extractTableStructure(DataAccessPoint dataAccessPoint, DataAccessPoint dataAccessPoint2) throws Exception {
        this.initTypes();
        dataAccessPoint.getTableStructure(this, dataAccessPoint2);
    }

    void transferStructure() throws Exception {
        String string = new String("");
        if (this.destDb.helper.needTransferTransaction()) {
            try {
                this.destDb.setAutoCommit(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.Stmts.bTransfer) {
            this.tracer.trace("Table " + this.Stmts.sSourceTable + " not transfered");
            return;
        }
        this.tracer.trace("Table " + this.Stmts.sSourceTable + ": start transfer");
        try {
            int n;
            if (this.Stmts.bDropIndex) {
                if (this.Stmts.sDestDropIndex.charAt(this.Stmts.sDestDropIndex.length() - 1) != ';') {
                    this.Stmts.sDestDropIndex = this.Stmts.sDestDropIndex + ";";
                }
                int n2 = 0;
                n = this.Stmts.sDestDropIndex.indexOf(59);
                while (n > n2) {
                    string = this.Stmts.sDestDropIndex.substring(n2, n);
                    while (string.charAt(string.length() - 1) == ';') {
                        string = string.substring(0, string.length() - 1);
                    }
                    try {
                        this.tracer.trace("Executing " + string);
                        this.destDb.execute(string);
                    }
                    catch (Exception exception) {
                        this.tracer.trace("Ignoring error " + exception.getMessage());
                    }
                    n2 = n + 1;
                    n = n2 + this.Stmts.sDestDropIndex.substring(n2).indexOf(59);
                }
            }
            if (this.Stmts.bDelete) {
                if (this.Stmts.sDestDelete.charAt(this.Stmts.sDestDelete.length() - 1) != ';') {
                    this.Stmts.sDestDelete = this.Stmts.sDestDelete + ";";
                }
                int n3 = 0;
                n = this.Stmts.sDestDelete.indexOf(59);
                while (n > n3) {
                    string = this.Stmts.sDestDelete.substring(n3, n);
                    while (string.charAt(string.length() - 1) == ';') {
                        string = string.substring(0, string.length() - 1);
                    }
                    try {
                        this.tracer.trace("Executing " + string);
                        this.destDb.execute(string);
                    }
                    catch (Exception exception) {
                        this.tracer.trace("Ignoring error " + exception.getMessage());
                    }
                    n3 = n + 1;
                    n = n3 + this.Stmts.sDestDelete.substring(n3).indexOf(59);
                }
            }
            if (this.Stmts.bDrop) {
                if (this.Stmts.sDestDrop.charAt(this.Stmts.sDestDrop.length() - 1) != ';') {
                    this.Stmts.sDestDrop = this.Stmts.sDestDrop + ";";
                }
                int n4 = 0;
                n = this.Stmts.sDestDrop.indexOf(59);
                while (n > n4) {
                    string = this.Stmts.sDestDrop.substring(n4, n);
                    while (string.charAt(string.length() - 1) == ';') {
                        string = string.substring(0, string.length() - 1);
                    }
                    try {
                        this.tracer.trace("Executing " + string);
                        this.destDb.execute(string);
                    }
                    catch (Exception exception) {
                        this.tracer.trace("Ignoring error " + exception.getMessage());
                    }
                    n4 = n + 1;
                    n = n4 + this.Stmts.sDestDrop.substring(n4).indexOf(59);
                }
            }
            if (this.Stmts.bCreate) {
                if (this.Stmts.sDestCreate.charAt(this.Stmts.sDestCreate.length() - 1) != ';') {
                    this.Stmts.sDestCreate = this.Stmts.sDestCreate + ";";
                }
                int n5 = 0;
                n = this.Stmts.sDestCreate.indexOf(59);
                while (n > n5) {
                    string = this.Stmts.sDestCreate.substring(n5, n);
                    while (string.charAt(string.length() - 1) == ';') {
                        string = string.substring(0, string.length() - 1);
                    }
                    this.tracer.trace("Executing " + string);
                    this.destDb.execute(string);
                    n5 = n + 1;
                    n = n5 + this.Stmts.sDestCreate.substring(n5).indexOf(59);
                }
            }
        }
        catch (Exception exception) {
            try {
                if (!this.destDb.getAutoCommit()) {
                    this.destDb.rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        if (!this.destDb.getAutoCommit()) {
            this.destDb.commit();
            try {
                this.destDb.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void transferData(int n) throws Exception, SQLException {
        block17: {
            if (this.destDb.helper.needTransferTransaction()) {
                try {
                    this.destDb.setAutoCommit(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (!this.Stmts.bInsert) break block17;
                if (this.destDb.helper.needTransferTransaction()) {
                    try {
                        this.destDb.setAutoCommit(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.tracer.trace("Executing " + this.Stmts.sSourceSelect);
                TransferResultSet transferResultSet = this.sourceDb.getData(this.Stmts.sSourceSelect);
                this.tracer.trace("Start transfering data...");
                this.destDb.beginDataTransfer();
                this.tracer.trace("Executing " + this.Stmts.sDestInsert);
                this.destDb.putData(this.Stmts.sDestInsert, transferResultSet, n);
                this.destDb.endDataTransfer();
                this.tracer.trace("Finished");
                if (!this.destDb.getAutoCommit()) {
                    this.destDb.commit();
                    try {
                        this.destDb.setAutoCommit(true);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                try {
                    if (!this.destDb.getAutoCommit()) {
                        this.destDb.rollback();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw exception;
            }
        }
        if (!this.destDb.getAutoCommit()) {
            this.destDb.commit();
            try {
                this.destDb.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void transferAlter() throws Exception {
        block23: {
            String string = new String("");
            if (this.destDb.helper.needTransferTransaction()) {
                try {
                    this.destDb.setAutoCommit(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.Stmts.bTransfer) {
                this.tracer.trace("Table " + this.Stmts.sSourceTable + " not transfered");
                return;
            }
            this.tracer.trace("Table " + this.Stmts.sSourceTable + ": start alter");
            try {
                int n;
                if (this.Stmts.bCreateIndex) {
                    if (this.Stmts.sDestCreateIndex.charAt(this.Stmts.sDestCreateIndex.length() - 1) != ';') {
                        this.Stmts.sDestCreateIndex = this.Stmts.sDestCreateIndex + ";";
                    }
                    int n2 = 0;
                    n = this.Stmts.sDestCreateIndex.indexOf(59);
                    while (n > n2) {
                        string = this.Stmts.sDestCreateIndex.substring(n2, n);
                        while (string.charAt(string.length() - 1) == ';') {
                            string = string.substring(0, string.length() - 1);
                        }
                        try {
                            this.tracer.trace("Executing " + this.Stmts.sDestCreateIndex);
                            this.destDb.execute(string);
                        }
                        catch (Exception exception) {
                            this.tracer.trace("Ignoring error " + exception.getMessage());
                        }
                        n2 = n + 1;
                        n = n2 + this.Stmts.sDestCreateIndex.substring(n2).indexOf(59);
                    }
                }
                if (!this.Stmts.bAlter) break block23;
                if (this.Stmts.sDestAlter.charAt(this.Stmts.sDestAlter.length() - 1) != ';') {
                    this.Stmts.sDestAlter = this.Stmts.sDestAlter + ";";
                }
                int n3 = 0;
                n = this.Stmts.sDestAlter.indexOf(59);
                while (n > n3) {
                    string = this.Stmts.sDestAlter.substring(n3, n);
                    while (string.charAt(string.length() - 1) == ';') {
                        string = string.substring(0, string.length() - 1);
                    }
                    try {
                        this.tracer.trace("Executing " + string);
                        this.destDb.execute(string);
                    }
                    catch (Exception exception) {
                        this.tracer.trace("Ignoring error " + exception.getMessage());
                    }
                    n3 = n + 1;
                    n = n3 + this.Stmts.sDestAlter.substring(n3).indexOf(59);
                }
            }
            catch (Exception exception) {
                try {
                    if (!this.destDb.getAutoCommit()) {
                        this.destDb.rollback();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw exception;
            }
        }
        if (!this.destDb.getAutoCommit()) {
            this.destDb.commit();
            try {
                this.destDb.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initTypes() throws SQLException {
        if (this.hTypes != null) {
            return;
        }
        this.hTypes = this.destDb.helper.getSupportedTypes();
    }
}

