/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import java.lang.reflect.Method;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.transaction.TransactionManager;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aspects.tx.TxInterceptor;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ejb3.tx.BMTInterceptor;
import org.jboss.ejb3.tx.Ejb3TxPolicy;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;
import org.jboss.tm.TxManager;

public class TxInterceptorFactory
extends org.jboss.aspects.tx.TxInterceptorFactory {
    private static final Logger log = Logger.getLogger(TxInterceptorFactory.class);

    protected String resolveTxType(Advisor advisor, Joinpoint jp) {
        Method method = ((MethodJoinpoint)jp).getMethod();
        TransactionAttribute tx = (TransactionAttribute)advisor.resolveAnnotation(method, TransactionAttribute.class);
        String value = "REQUIRED";
        if (tx != null) {
            TransactionAttributeType type = tx.value();
            value = type == null ? "REQUIRED" : (type == TransactionAttributeType.NOT_SUPPORTED ? "NOTSUPPORTED" : (type == TransactionAttributeType.REQUIRES_NEW ? "REQUIRESNEW" : type.name()));
        }
        return value;
    }

    protected int resolveTransactionTimeout(Advisor advisor, Method method) {
        TransactionTimeout annotation = (TransactionTimeout)advisor.resolveAnnotation(method, TransactionTimeout.class);
        if (annotation != null) {
            return annotation.value();
        }
        return -1;
    }

    protected void initializePolicy() {
        this.policy = new Ejb3TxPolicy();
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        TransactionManagementType type = TxUtil.getTransactionManagementType(advisor);
        if (type == TransactionManagementType.BEAN) {
            return new BMTInterceptor((TransactionManager)TxManager.getInstance(), advisor instanceof StatelessContainer);
        }
        Method method = ((MethodJoinpoint)jp).getMethod();
        int timeout = this.resolveTransactionTimeout(advisor, method);
        if (this.policy == null) {
            // empty if block
        }
        super.initialize();
        String txType = this.resolveTxType(advisor, jp).toUpperCase();
        if (txType.equals("REQUIRED")) {
            return new TxInterceptor.Required((TransactionManager)TxManager.getInstance(), this.policy, timeout);
        }
        if (txType.equals("REQUIRESNEW")) {
            return new TxInterceptor.RequiresNew((TransactionManager)TxManager.getInstance(), this.policy, timeout);
        }
        return super.createPerJoinpoint(advisor, jp);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

