/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.tests.perf.Data;
import org.jgroups.tests.perf.MemberInfo;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;
import org.jgroups.util.Util;

public class Test
implements Receiver {
    String props = null;
    Properties config;
    boolean sender = false;
    Transport transport = null;
    Object local_addr = null;
    Map senders = new ConcurrentReaderHashMap(10);
    final ArrayList members = new ArrayList();
    long start = 0L;
    long stop = 0L;
    int num_members = 0;
    int num_senders = 0;
    long num_msgs_expected = 0L;
    long num_msgs_received = 0L;
    long num_bytes_received = 0L;
    Log log = LogFactory.getLog(this.getClass());
    boolean all_received = false;
    boolean final_results_received = false;
    Map results = new HashMap();
    private ResultsPublisher publisher = new ResultsPublisher();
    List heard_from = new ArrayList();
    boolean dump_transport_stats = false;
    long log_interval = 1000L;
    long counter = 1L;
    long msg_size = 1000L;
    boolean jmx = false;
    long processing_delay = 0L;
    FileWriter output = null;
    QueuedExecutor response_sender = new QueuedExecutor();
    static NumberFormat f = NumberFormat.getNumberInstance();

    public void start(Properties c, boolean verbose, boolean jmx, String output) throws Exception {
        String line;
        String config_file = "config.txt";
        Properties tmp = new Properties();
        if (output != null) {
            this.output = new FileWriter(output, false);
        }
        this.response_sender.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Test.ResponseSender");
            }
        });
        config_file = c.getProperty("config");
        BufferedReader fileReader = new BufferedReader(new FileReader(config_file));
        while ((line = fileReader.readLine()) != null) {
            if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, "=", false);
            String key = st.nextToken().toLowerCase();
            String val = st.nextToken();
            tmp.put(key, val);
        }
        fileReader.close();
        tmp.putAll((Map<?, ?>)c);
        this.config = tmp;
        StringBuffer sb = new StringBuffer();
        sb.append("\n\n----------------------- TEST -----------------------\n");
        sb.append("Date: ").append(new Date()).append('\n');
        sb.append("Run by: ").append(System.getProperty("user.name")).append("\n\n");
        if (verbose) {
            sb.append("Properties: ").append(this.printProperties()).append("\n-------------------------\n\n");
        }
        Iterator<Map.Entry<Object, Object>> it = this.config.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            sb.append(entry.getKey()).append(":\t").append(entry.getValue()).append('\n');
        }
        sb.append("JGroups version: ").append("2.4.2.GA_CP01").append('\n');
        System.out.println("Configuration is: " + sb);
        this.output(sb.toString());
        this.props = this.config.getProperty("props");
        this.num_members = Integer.parseInt(this.config.getProperty("num_members"));
        this.num_senders = Integer.parseInt(this.config.getProperty("num_senders"));
        long num_msgs = Long.parseLong(this.config.getProperty("num_msgs"));
        this.num_msgs_expected = (long)this.num_senders * num_msgs;
        this.sender = Boolean.valueOf(this.config.getProperty("sender"));
        this.msg_size = Long.parseLong(this.config.getProperty("msg_size"));
        String tmp2 = this.config.getProperty("dump_transport_stats", "false");
        if (Boolean.valueOf(tmp2).booleanValue()) {
            this.dump_transport_stats = true;
        }
        if ((tmp2 = this.config.getProperty("log_interval")) != null) {
            this.log_interval = Long.parseLong(tmp2);
        }
        sb = new StringBuffer();
        sb.append("\n##### msgs_received");
        sb.append(", current time (in ms)");
        sb.append(", msgs/sec");
        sb.append(", throughput/sec [KB]");
        sb.append(", free_mem [KB] ");
        sb.append(", total_mem [KB] ");
        this.output(sb.toString());
        if (jmx) {
            this.config.setProperty("jmx", "true");
        }
        this.jmx = new Boolean(this.config.getProperty("jmx"));
        String tmp3 = this.config.getProperty("processing_delay");
        if (tmp3 != null) {
            this.processing_delay = Long.parseLong(tmp3);
        }
        String transport_name = this.config.getProperty("transport");
        this.transport = (Transport)Util.loadClass(transport_name, this.getClass()).newInstance();
        this.transport.create(this.config);
        this.transport.setReceiver(this);
        this.transport.start();
        this.local_addr = this.transport.getLocalAddress();
    }

    private void output(String msg) {
        if (this.output != null) {
            try {
                this.output.write(msg + "\n");
                this.output.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String printProperties() {
        StringBuffer sb = new StringBuffer();
        Properties p = System.getProperties();
        Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public void stop() {
        if (this.transport != null) {
            this.transport.stop();
            this.transport.destroy();
        }
        if (this.response_sender != null) {
            this.response_sender.shutdownNow();
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Object sender, byte[] payload) {
        if (payload == null || payload.length == 0) {
            System.err.println("payload is incorrect (sender=" + sender + "): " + payload);
            return;
        }
        try {
            byte type = payload[0];
            if (type == 1) {
                int len = payload.length - 1;
                this.handleData(sender, len);
                return;
            }
            byte[] tmp = new byte[payload.length - 1];
            System.arraycopy(payload, 1, tmp, 0, tmp.length);
            Data d = (Data)Util.streamableFromByteBuffer(Data.class, tmp);
            switch (d.getType()) {
                case 1: {
                    this.sendDiscoveryResponse();
                    break;
                }
                case 2: {
                    ArrayList arrayList = this.members;
                    synchronized (arrayList) {
                        if (!this.members.contains(sender)) {
                            this.members.add(sender);
                            System.out.println("-- " + sender + " joined");
                            if (d.sender) {
                                ArrayList arrayList2 = this.members;
                                synchronized (arrayList2) {
                                    if (!this.senders.containsKey(sender)) {
                                        this.senders.put(sender, new MemberInfo(d.num_msgs));
                                    }
                                }
                            }
                            this.members.notifyAll();
                        }
                        break;
                    }
                }
                case 5: {
                    this.publisher.stop();
                    if (!this.final_results_received) {
                        this.dumpResults(d.results);
                        this.final_results_received = true;
                    }
                    Test test = this;
                    synchronized (test) {
                        this.notifyAll();
                        break;
                    }
                }
                case 4: {
                    this.results.put(sender, d.result);
                    this.heard_from.remove(sender);
                    if (this.heard_from.size() == 0) {
                        for (int i = 0; i < 3; ++i) {
                            this.sendFinalResults();
                            Util.sleep(100L);
                        }
                    }
                    break;
                }
                default: {
                    this.log.error((Object)("received invalid data type: " + payload[0]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleData(Object sender, int num_bytes) {
        MemberInfo info;
        if (this.all_received) {
            return;
        }
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
        ++this.num_msgs_received;
        this.num_bytes_received += (long)num_bytes;
        if (this.num_msgs_received >= this.num_msgs_expected) {
            if (this.stop == 0L) {
                this.stop = System.currentTimeMillis();
            }
            this.all_received = true;
        }
        if (this.num_msgs_received % this.log_interval == 0L) {
            System.out.println(new StringBuffer("-- received ").append(this.num_msgs_received).append(" messages"));
        }
        if (this.counter % this.log_interval == 0L) {
            this.output(this.dumpStats(this.counter));
        }
        if ((info = (MemberInfo)this.senders.get(sender)) != null) {
            if (info.start == 0L) {
                info.start = System.currentTimeMillis();
            }
            ++info.num_msgs_received;
            ++this.counter;
            info.total_bytes_received += (long)num_bytes;
            if (info.num_msgs_received >= info.num_msgs_expected) {
                info.done = true;
                if (info.stop == 0L) {
                    info.stop = System.currentTimeMillis();
                }
            } else if (this.processing_delay > 0L) {
                Util.sleep(this.processing_delay);
            }
        } else {
            this.log.error((Object)("-- sender " + sender + " not found in senders hashmap"));
        }
        if (this.all_received) {
            if (!this.sender) {
                this.dumpSenders();
            }
            this.publisher.start();
        }
    }

    private void sendResults() throws Exception {
        Data d = new Data(4);
        MemberInfo info = new MemberInfo(this.num_msgs_expected);
        info.done = true;
        info.num_msgs_received = this.num_msgs_received;
        info.start = this.start;
        info.stop = this.stop;
        info.total_bytes_received = this.num_bytes_received;
        d.result = info;
        byte[] buf = this.generatePayload(d, null);
        this.transport.send(null, buf);
    }

    private void sendFinalResults() throws Exception {
        Data d = new Data(5);
        d.results = new ConcurrentReaderHashMap(this.results);
        final byte[] buf = this.generatePayload(d, null);
        this.response_sender.execute(new Runnable(){

            public void run() {
                try {
                    Test.this.transport.send(null, buf);
                }
                catch (Exception e) {
                    Test.this.log.error((Object)"failed sending discovery response", (Throwable)e);
                }
            }
        });
    }

    boolean allReceived() {
        return this.all_received;
    }

    boolean receivedFinalResults() {
        return this.final_results_received;
    }

    void sendMessages(long interval, int nanos, boolean busy_sleep) throws Exception {
        long total_msgs = 0L;
        int msgSize = Integer.parseInt(this.config.getProperty("msg_size"));
        int num_msgs = Integer.parseInt(this.config.getProperty("num_msgs"));
        byte[] buf = new byte[msgSize];
        for (int k = 0; k < msgSize; ++k) {
            buf[k] = 46;
        }
        Data d = new Data(3);
        byte[] payload = this.generatePayload(d, buf);
        System.out.println("-- sending " + num_msgs + " " + Util.printBytes(msgSize) + " messages");
        for (int i = 0; i < num_msgs; ++i) {
            this.transport.send(null, payload);
            if (++total_msgs % this.log_interval == 0L) {
                System.out.println("++ sent " + total_msgs);
            }
            if (interval <= 0L && nanos <= 0) continue;
            if (busy_sleep) {
                Util.sleep(interval, busy_sleep);
                continue;
            }
            Util.sleep(interval, nanos);
        }
    }

    byte[] generatePayload(Data d, byte[] buf) throws Exception {
        byte[] tmp = buf != null ? buf : Util.streamableToByteBuffer(d);
        byte[] payload = new byte[tmp.length + 1];
        payload[0] = this.intToByte(d.getType());
        System.arraycopy(tmp, 0, payload, 1, tmp.length);
        return payload;
    }

    private byte intToByte(int type) {
        switch (type) {
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    private void dumpResults(Map final_results) {
        double tmp = 0.0;
        StringBuffer sb = new StringBuffer();
        sb.append("\n-- results:\n");
        Iterator it = final_results.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object member = entry.getKey();
            MemberInfo val = (MemberInfo)entry.getValue();
            tmp += val.getMessageSec();
            sb.append("\n").append(member);
            if (member.equals(this.local_addr)) {
                sb.append(" (myself)");
            }
            sb.append(":\n");
            sb.append(val);
            sb.append('\n');
        }
        double combined_msgs_sec = tmp / (double)final_results.size();
        long combined_tp = (long)combined_msgs_sec * this.msg_size;
        sb.append("\ncombined: ").append(f.format(combined_msgs_sec)).append(" msgs/sec averaged over all receivers (throughput=" + Util.printBytes(combined_tp) + "/sec)\n");
        System.out.println(sb.toString());
        this.output(sb.toString());
    }

    private void dumpSenders() {
        StringBuffer sb = new StringBuffer();
        this.dump(this.senders, sb);
        System.out.println(sb.toString());
    }

    private void dump(Map map, StringBuffer sb) {
        MemberInfo combined = new MemberInfo(0L);
        combined.start = Long.MAX_VALUE;
        combined.stop = Long.MIN_VALUE;
        sb.append("\n-- local results:\n");
        Iterator it2 = map.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            Object mySender = entry.getKey();
            MemberInfo mi = (MemberInfo)entry.getValue();
            combined.start = Math.min(combined.start, mi.start);
            combined.stop = Math.max(combined.stop, mi.stop);
            combined.num_msgs_expected += mi.num_msgs_expected;
            combined.num_msgs_received += mi.num_msgs_received;
            combined.total_bytes_received += mi.total_bytes_received;
            sb.append("sender: ").append(mySender).append(": ").append(mi).append('\n');
        }
    }

    private String dumpStats(long received_msgs) {
        Map stats;
        StringBuffer sb = new StringBuffer();
        sb.append(received_msgs).append(' ');
        long current = System.currentTimeMillis();
        sb.append(current).append(' ');
        double msgs_sec = (double)received_msgs / ((double)(current - this.start) / 1000.0);
        double throughput_sec = msgs_sec * (double)this.msg_size;
        sb.append(f.format(msgs_sec)).append(' ').append(f.format(throughput_sec)).append(' ');
        sb.append((double)Runtime.getRuntime().freeMemory() / 1000.0).append(' ');
        sb.append((double)Runtime.getRuntime().totalMemory() / 1000.0);
        if (this.dump_transport_stats && (stats = this.transport.dumpStats()) != null) {
            this.print(stats, sb);
        }
        return sb.toString();
    }

    public String dumpTransportStats() {
        Map stats = this.transport.dumpStats();
        StringBuffer sb = new StringBuffer(128);
        if (stats != null) {
            Iterator it = stats.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                sb.append("\n").append(key).append(":\n");
                Iterator it2 = value.entrySet().iterator();
                while (it2.hasNext()) {
                    sb.append(it2.next()).append("\n");
                }
            }
        }
        return sb.toString();
    }

    private void print(Map stats, StringBuffer sb) {
        sb.append("\nTransport stats:\n\n");
        Iterator it = stats.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runDiscoveryPhase() throws Exception {
        this.sendDiscoveryRequest();
        this.sendDiscoveryResponse();
        ArrayList arrayList = this.members;
        synchronized (arrayList) {
            System.out.println("-- waiting for " + this.num_members + " members to join");
            while (this.members.size() < this.num_members) {
                this.members.wait(2000L);
                this.sendDiscoveryRequest();
                this.sendDiscoveryResponse();
            }
            this.heard_from.addAll(this.members);
            System.out.println("-- members: " + this.members.size());
        }
    }

    void sendDiscoveryRequest() throws Exception {
        Data d = new Data(1);
        this.transport.send(null, this.generatePayload(d, null));
    }

    void sendDiscoveryResponse() throws Exception {
        final Data d2 = new Data(2);
        if (this.sender) {
            d2.sender = true;
            d2.num_msgs = Long.parseLong(this.config.getProperty("num_msgs"));
        }
        this.response_sender.execute(new Runnable(){

            public void run() {
                try {
                    Test.this.transport.send(null, Test.this.generatePayload(d2, null));
                }
                catch (Exception e) {
                    Test.this.log.error((Object)"failed sending discovery response", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Properties config = new Properties();
        boolean sender = false;
        boolean verbose = false;
        boolean jmx = false;
        boolean dump_stats = false;
        Test t = null;
        String output = null;
        long interval = 0L;
        int interval_nanos = 0;
        boolean busy_sleep = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-sender".equals(args[i])) {
                config.put("sender", "true");
                sender = true;
                continue;
            }
            if ("-receiver".equals(args[i])) {
                config.put("sender", "false");
                sender = false;
                continue;
            }
            if ("-config".equals(args[i])) {
                String config_file = args[++i];
                config.put("config", config_file);
                continue;
            }
            if ("-props".equals(args[i])) {
                String props = args[++i];
                config.put("props", props);
                continue;
            }
            if ("-verbose".equals(args[i])) {
                verbose = true;
                continue;
            }
            if ("-jmx".equals(args[i])) {
                jmx = true;
                continue;
            }
            if ("-dump_stats".equals(args[i])) {
                dump_stats = true;
                continue;
            }
            if ("-interval".equals(args[i])) {
                interval = Long.parseLong(args[++i]);
                continue;
            }
            if ("-nanos".equals(args[i])) {
                interval_nanos = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-busy_sleep".equals(args[i])) {
                busy_sleep = true;
                continue;
            }
            if ("-f".equals(args[i])) {
                output = args[++i];
                continue;
            }
            Test.help();
            return;
        }
        try {
            t = new Test();
            t.start(config, verbose, jmx, output);
            t.runDiscoveryPhase();
            if (sender) {
                t.sendMessages(interval, interval_nanos, busy_sleep);
            }
            Test i = t;
            synchronized (i) {
                while (!t.receivedFinalResults()) {
                    t.wait(2000L);
                }
            }
            if (dump_stats) {
                String stats = t.dumpTransportStats();
                System.out.println("\nTransport statistics:\n" + stats);
            }
            if (t.jmx) {
                System.out.println("jmx=true: not terminating");
                if (t != null) {
                    t.stop();
                    t = null;
                }
                while (true) {
                    Util.sleep(60000L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (t != null) {
                t.stop();
            }
        }
    }

    static void help() {
        System.out.println("Test [-help] ([-sender] | [-receiver]) [-config <config file>] [-props <stack config>] [-verbose] [-jmx] [-dump_stats] [-f <filename>] [-interval <ms between sends>] [-nanos <additional nanos to sleep in interval>] [-busy_sleep (cancels out -nanos)]");
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }

    private class ResultsPublisher
    implements Runnable {
        final long interval = 1000L;
        boolean running = true;
        Thread t;

        private ResultsPublisher() {
        }

        void start() {
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "ResultsPublisher");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            if (this.t != null && this.t.isAlive()) {
                Thread tmp = this.t;
                this.t = null;
                tmp.interrupt();
            }
        }

        public void run() {
            try {
                while (this.t != null) {
                    Test.this.sendResults();
                    Util.sleep(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

