/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.connection;

import cirrus.hibernate.Environment;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.connection.ConnectionProvider;
import cirrus.hibernate.connection.ConnectionProviderFactory;
import cirrus.hibernate.helpers.JDBCExceptionReporter;
import cirrus.hibernate.helpers.PropertiesHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DriverManagerConnectionProvider
implements ConnectionProvider {
    private String url;
    private Properties connectionProps;
    private Integer isolation;
    private final Stack cache = new Stack();
    private int poolSize;
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$connection$DriverManagerConnectionProvider == null ? (class$cirrus$hibernate$connection$DriverManagerConnectionProvider = DriverManagerConnectionProvider.class$("cirrus.hibernate.connection.DriverManagerConnectionProvider")) : class$cirrus$hibernate$connection$DriverManagerConnectionProvider));
    static /* synthetic */ Class class$cirrus$hibernate$connection$DriverManagerConnectionProvider;

    public void configure(Properties props) throws HibernateException {
        String driverClass = props.getProperty("hibernate.connection.driver_class");
        this.poolSize = PropertiesHelper.getInt("hibernate.connection.pool_size", props, 20);
        log.info((Object)("Hibernate connection pool size: " + this.poolSize));
        this.isolation = PropertiesHelper.getInteger("hibernate.connection.isolation", props);
        if (this.isolation != null) {
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation)));
        }
        if (driverClass == null) {
            log.warn((Object)"No JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException cnfe) {
                String msg = "JDBC Driver class not found: " + driverClass;
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
        }
        this.url = props.getProperty("hibernate.connection.url");
        if (this.url == null) {
            String msg = "JDBC URL was not specified by property hibernate.connection.url";
            log.fatal((Object)msg);
            throw new HibernateException(msg);
        }
        this.connectionProps = ConnectionProviderFactory.getJdbcConnectionProperties(props);
        log.info((Object)("Using driver: " + driverClass + " at URL: " + this.url));
        log.info((Object)("Connection properties: " + this.connectionProps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Connection conn;
        Stack stack = this.cache;
        synchronized (stack) {
            if (!this.cache.isEmpty()) {
                log.trace((Object)"Using cached JDBC connection");
                return (Connection)this.cache.pop();
            }
        }
        log.debug((Object)"Opening new JDBC connection");
        try {
            conn = DriverManager.getConnection(this.url, this.connectionProps);
            if (this.isolation != null) {
                conn.setTransactionIsolation(this.isolation);
            }
            conn.setAutoCommit(false);
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created connection to: " + this.url + ", Isolation Level: " + conn.getTransactionIsolation()));
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection conn) throws SQLException {
        Stack stack = this.cache;
        synchronized (stack) {
            if (this.cache.size() < this.poolSize) {
                log.trace((Object)"returning connection to pool");
                this.cache.push(conn);
                return;
            }
        }
        log.debug((Object)"Closing JDBC connection");
        try {
            conn.close();
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public boolean isStatementCache() {
        return false;
    }

    protected void finalize() {
        log.info((Object)("Cleaning up dereferenced connection pool: " + this.url));
        Iterator iter = this.cache.iterator();
        while (iter.hasNext()) {
            try {
                ((Connection)iter.next()).close();
            }
            catch (SQLException sqle) {
                log.warn((Object)"problem closing pooled connection", (Throwable)sqle);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

