/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.MappingException;
import cirrus.hibernate.engine.Cascades;
import cirrus.hibernate.map.Component;
import cirrus.hibernate.map.Root;
import cirrus.hibernate.map.Value;
import cirrus.hibernate.type.AbstractComponentType;
import cirrus.hibernate.type.Type;
import java.util.Iterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Property {
    private final String name;
    private final Value value;
    private String cascade;

    public String toString() {
        return "Property: " + this.name;
    }

    public Type getType() {
        return this.value.getType();
    }

    public int getColumnSpan() {
        return this.value.getColumnSpan();
    }

    public Iterator getColumnIterator() {
        return this.value.getColumnIterator();
    }

    public String getName() {
        return this.name;
    }

    public boolean isComposite() {
        return this.value instanceof Component;
    }

    public Property(Node node, Value value, Root root) throws MappingException {
        this.name = Property.getPropertyName(node);
        this.value = value;
        Type type = value.getType();
        if (type == null) {
            throw new MappingException("Could not determine a property type for: " + this.name);
        }
        Node cascadeNode = node.getAttributes().getNamedItem("cascade");
        this.cascade = cascadeNode == null ? root.getDefaultCascade() : cascadeNode.getNodeValue();
    }

    public Value getValue() {
        return this.value;
    }

    public static String getPropertyName(Node node) {
        NamedNodeMap atts = node.getAttributes();
        if (atts == null) {
            return null;
        }
        Node propertyName = atts.getNamedItem("name");
        if (propertyName == null) {
            propertyName = atts.getNamedItem("role");
        }
        return propertyName == null ? null : propertyName.getNodeValue();
    }

    public Cascades.CascadeStyle cascade() throws MappingException {
        if (this.value.getType().isComponentType()) {
            AbstractComponentType actype = (AbstractComponentType)this.value.getType();
            int length = actype.getSubtypes().length;
            int i = 0;
            while (i < length) {
                if (actype.cascade(i) != Cascades.STYLE_NONE) {
                    return Cascades.STYLE_ALL;
                }
                ++i;
            }
            return Cascades.STYLE_NONE;
        }
        if (this.cascade.equals("all")) {
            return Cascades.STYLE_ALL;
        }
        if (this.cascade.equals("none")) {
            return Cascades.STYLE_NONE;
        }
        if (this.cascade.equals("save/update") || this.cascade.equals("save-update")) {
            return Cascades.STYLE_EXCEPT_DELETE;
        }
        if (this.cascade.equals("delete")) {
            return Cascades.STYLE_ONLY_DELETE;
        }
        throw new MappingException("Unsupported cascade style: " + this.cascade);
    }
}

