/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.none;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import javax.jms.JMSException;
import javax.management.ObjectName;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.CacheStore;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.none.PersistenceManagerMBean;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;
import org.jboss.system.ServiceMBeanSupport;

public class PersistenceManager
extends ServiceMBeanSupport
implements PersistenceManagerMBean,
org.jboss.mq.pm.PersistenceManager,
CacheStore {
    SynchronizedLong nextTransactionid = new SynchronizedLong(0L);
    ObjectName delegateName;
    org.jboss.mq.pm.PersistenceManager delegate;
    TxManager txManager;
    ConcurrentHashMap cache = new ConcurrentHashMap();

    public ObjectName getDelegatePM() {
        return this.delegateName;
    }

    public void setDelegatePM(ObjectName delegateName) {
        this.delegateName = delegateName;
    }

    public void add(MessageReference message, Tx txId) throws JMSException {
        if (this.delegate != null && !message.inMemory()) {
            this.delegate.add(message, txId);
        }
    }

    public void closeQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        if (this.delegate != null) {
            this.delegate.closeQueue(jmsDest, dest);
        }
    }

    public void commitPersistentTx(Tx txId) throws JMSException {
        if (this.delegate != null) {
            this.delegate.commitPersistentTx(txId);
        }
    }

    public Tx createPersistentTx() throws JMSException {
        if (this.delegate != null) {
            return this.delegate.createPersistentTx();
        }
        Tx tx = new Tx(this.nextTransactionid.increment());
        return tx;
    }

    public MessageCache getMessageCacheInstance() {
        if (this.delegate != null) {
            return this.delegate.getMessageCacheInstance();
        }
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public void remove(MessageReference message, Tx txId) throws JMSException {
        if (this.delegate != null && !message.inMemory()) {
            this.delegate.remove(message, txId);
        }
    }

    public void restoreQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        if (this.delegate != null) {
            this.delegate.restoreQueue(jmsDest, dest);
        }
    }

    public void rollbackPersistentTx(Tx txId) throws JMSException {
        if (this.delegate != null) {
            this.delegate.rollbackPersistentTx(txId);
        }
    }

    public void update(MessageReference message, Tx txId) throws JMSException {
        if (this.delegate != null && !message.inMemory()) {
            this.delegate.update(message, txId);
        }
    }

    public Object getInstance() {
        return this;
    }

    public ObjectName getMessageCache() {
        if (this.delegateName != null) {
            try {
                return (ObjectName)this.server.getAttribute(this.delegateName, "MessageCache");
            }
            catch (Exception e) {
                this.log.trace("Unable to retrieve message cache from delegate", e);
            }
        }
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    public void setMessageCache(ObjectName messageCache) {
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    public SpyMessage loadFromStorage(MessageReference mh) throws JMSException {
        if (this.delegate == null || mh.inMemory()) {
            return (SpyMessage)this.cache.get((Object)mh);
        }
        return ((CacheStore)((Object)this.delegate)).loadFromStorage(mh);
    }

    public void removeFromStorage(MessageReference mh) throws JMSException {
        if (this.delegate == null || mh.inMemory()) {
            this.cache.remove((Object)mh);
            mh.setStored(1);
        } else {
            ((CacheStore)((Object)this.delegate)).removeFromStorage(mh);
        }
    }

    public void saveToStorage(MessageReference mh, SpyMessage message) throws JMSException {
        if (this.delegate == null || mh.inMemory()) {
            this.cache.put((Object)mh, (Object)message);
            mh.setStored(2);
        } else {
            ((CacheStore)((Object)this.delegate)).saveToStorage(mh, message);
        }
    }

    protected void startService() throws Exception {
        if (this.delegateName != null) {
            this.delegate = (org.jboss.mq.pm.PersistenceManager)this.getServer().getAttribute(this.delegateName, "Instance");
            if (!(this.delegate instanceof CacheStore)) {
                throw new UnsupportedOperationException("The delegate persistence manager must also be a CacheStore");
            }
            this.txManager = this.delegate.getTxManager();
        } else {
            this.txManager = new TxManager(this);
        }
    }
}

