/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUtilsBean {
    private FastHashMap descriptorsCache = null;
    private FastHashMap mappedDescriptorsCache = null;
    private Log log = LogFactory.getLog(PropertyUtils.class);

    protected static PropertyUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getPropertyUtils();
    }

    public PropertyUtilsBean() {
        this.descriptorsCache = new FastHashMap();
        this.descriptorsCache.setFast(true);
        this.mappedDescriptorsCache = new FastHashMap();
        this.mappedDescriptorsCache.setFast(true);
    }

    public void clearDescriptors() {
        this.descriptorsCache.clear();
        this.mappedDescriptorsCache.clear();
        Introspector.flushCaches();
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                Object value;
                String name = origDescriptors[i].getName();
                if (dest instanceof DynaBean) {
                    if (!this.isWriteable(dest, name)) continue;
                    value = ((DynaBean)orig).get(name);
                    ((DynaBean)dest).set(name, value);
                    continue;
                }
                if (!this.isWriteable(dest, name)) continue;
                value = ((DynaBean)orig).get(name);
                this.setSimpleProperty(dest, name, value);
            }
        } else if (orig instanceof Map) {
            for (String name : ((Map)orig).keySet()) {
                Object value;
                if (dest instanceof DynaBean) {
                    if (!this.isWriteable(dest, name)) continue;
                    value = ((Map)orig).get(name);
                    ((DynaBean)dest).set(name, value);
                    continue;
                }
                if (!this.isWriteable(dest, name)) continue;
                value = ((Map)orig).get(name);
                this.setSimpleProperty(dest, name, value);
            }
        } else {
            PropertyDescriptor[] origDescriptors = this.getPropertyDescriptors(orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                Object value;
                String name = origDescriptors[i].getName();
                if (!this.isReadable(orig, name)) continue;
                if (dest instanceof DynaBean) {
                    if (!this.isWriteable(dest, name)) continue;
                    value = this.getSimpleProperty(orig, name);
                    ((DynaBean)dest).set(name, value);
                    continue;
                }
                if (!this.isWriteable(dest, name)) continue;
                value = this.getSimpleProperty(orig, name);
                this.setSimpleProperty(dest, name, value);
            }
        }
    }

    public Map describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        HashMap<String, Object> description = new HashMap<String, Object>();
        if (bean instanceof DynaBean) {
            DynaProperty[] descriptors = ((DynaBean)bean).getDynaClass().getDynaProperties();
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                description.put(name, this.getProperty(bean, name));
            }
        } else {
            PropertyDescriptor[] descriptors = this.getPropertyDescriptors(bean);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if (descriptors[i].getReadMethod() == null) continue;
                description.put(name, this.getProperty(bean, name));
            }
        }
        return description;
    }

    public Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int delim = name.indexOf(91);
        int delim2 = name.indexOf(93);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        int index = -1;
        try {
            String subscript = name.substring(delim + 1, delim2);
            index = Integer.parseInt(subscript);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        name = name.substring(0, delim);
        return this.getIndexedProperty(bean, name, index);
    }

    public Object getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "'");
            }
            return ((DynaBean)bean).get(name, index);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor && (readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod()) != null) {
            Object[] subscript = new Object[]{new Integer(index)};
            try {
                return this.invokeMethod(readMethod, bean, subscript);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof ArrayIndexOutOfBoundsException) {
                    throw (ArrayIndexOutOfBoundsException)e.getTargetException();
                }
                throw e;
            }
        }
        readMethod = this.getReadMethod(descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object value = this.invokeMethod(readMethod, bean, new Object[0]);
        if (!value.getClass().isArray()) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Property '" + name + "' is not indexed");
            }
            return ((List)value).get(index);
        }
        return Array.get(value, index);
    }

    public Object getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int delim = name.indexOf(40);
        int delim2 = name.indexOf(41);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "'");
        }
        String key = name.substring(delim + 1, delim2);
        name = name.substring(0, delim);
        return this.getMappedProperty(bean, name, key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor != null) return ((DynaBean)bean).get(name, key);
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        Object result = null;
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method readMethod = ((MappedPropertyDescriptor)descriptor).getMappedReadMethod();
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method");
            Object[] keyArray = new Object[]{key};
            return this.invokeMethod(readMethod, bean, keyArray);
        }
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method");
        Object invokeResult = this.invokeMethod(readMethod, bean, new Object[0]);
        if (!(invokeResult instanceof Map)) return result;
        return ((Map)invokeResult).get(key);
    }

    public FastHashMap getMappedPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            return null;
        }
        return (FastHashMap)this.mappedDescriptorsCache.get((Object)beanClass);
    }

    public FastHashMap getMappedPropertyDescriptors(Object bean) {
        if (bean == null) {
            return null;
        }
        return this.getMappedPropertyDescriptors(bean.getClass());
    }

    public Object getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int indexOfINDEXED_DELIM = -1;
        int indexOfMAPPED_DELIM = -1;
        int indexOfMAPPED_DELIM2 = -1;
        int indexOfNESTED_DELIM = -1;
        while (true) {
            indexOfNESTED_DELIM = name.indexOf(46);
            indexOfMAPPED_DELIM = name.indexOf(40);
            indexOfMAPPED_DELIM2 = name.indexOf(41);
            indexOfNESTED_DELIM = indexOfMAPPED_DELIM2 >= 0 && indexOfMAPPED_DELIM >= 0 && (indexOfNESTED_DELIM < 0 || indexOfNESTED_DELIM > indexOfMAPPED_DELIM) ? name.indexOf(46, indexOfMAPPED_DELIM2) : name.indexOf(46);
            if (indexOfNESTED_DELIM < 0) break;
            String next = name.substring(0, indexOfNESTED_DELIM);
            indexOfINDEXED_DELIM = next.indexOf(91);
            indexOfMAPPED_DELIM = next.indexOf(40);
            if ((bean = bean instanceof Map ? ((Map)bean).get(next) : (indexOfMAPPED_DELIM >= 0 ? this.getMappedProperty(bean, next) : (indexOfINDEXED_DELIM >= 0 ? this.getIndexedProperty(bean, next) : this.getSimpleProperty(bean, next)))) == null) {
                throw new NestedNullException("Null property value for '" + name.substring(0, indexOfNESTED_DELIM) + "'");
            }
            name = name.substring(indexOfNESTED_DELIM + 1);
        }
        indexOfINDEXED_DELIM = name.indexOf(91);
        indexOfMAPPED_DELIM = name.indexOf(40);
        bean = bean instanceof Map ? ((Map)bean).get(name) : (indexOfMAPPED_DELIM >= 0 ? this.getMappedProperty(bean, name) : (indexOfINDEXED_DELIM >= 0 ? this.getIndexedProperty(bean, name) : this.getSimpleProperty(bean, name)));
        return bean;
    }

    public Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name);
    }

    public PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int period;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        while ((period = this.findNextNestedIndex(name)) >= 0) {
            String next = name.substring(0, period);
            int indexOfINDEXED_DELIM = next.indexOf(91);
            int indexOfMAPPED_DELIM = next.indexOf(40);
            bean = indexOfMAPPED_DELIM >= 0 && (indexOfINDEXED_DELIM < 0 || indexOfMAPPED_DELIM < indexOfINDEXED_DELIM) ? this.getMappedProperty(bean, next) : (indexOfINDEXED_DELIM >= 0 ? this.getIndexedProperty(bean, next) : this.getSimpleProperty(bean, next));
            if (bean == null) {
                throw new IllegalArgumentException("Null property value for '" + name.substring(0, period) + "'");
            }
            name = name.substring(period + 1);
        }
        int left = name.indexOf(91);
        if (left >= 0) {
            name = name.substring(0, left);
        }
        if ((left = name.indexOf(40)) >= 0) {
            name = name.substring(0, left);
        }
        if (bean == null || name == null) {
            return null;
        }
        PropertyDescriptor[] descriptors = this.getPropertyDescriptors(bean);
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                if (!name.equals(descriptors[i].getName())) continue;
                return descriptors[i];
            }
        }
        PropertyDescriptor result = null;
        FastHashMap mappedDescriptors = this.getMappedPropertyDescriptors(bean);
        if (mappedDescriptors == null) {
            mappedDescriptors = new FastHashMap();
            mappedDescriptors.setFast(true);
            this.mappedDescriptorsCache.put(bean.getClass(), (Object)mappedDescriptors);
        }
        if ((result = (PropertyDescriptor)mappedDescriptors.get((Object)name)) == null) {
            try {
                result = new MappedPropertyDescriptor(name, (Class)bean.getClass());
            }
            catch (IntrospectionException ie) {
                // empty catch block
            }
            if (result != null) {
                mappedDescriptors.put((Object)name, (Object)result);
            }
        }
        return result;
    }

    private int findNextNestedIndex(String expression) {
        int bracketCount = 0;
        int size = expression.length();
        block5: for (int i = 0; i < size; ++i) {
            char at = expression.charAt(i);
            switch (at) {
                case '.': {
                    if (bracketCount >= 1) continue block5;
                    return i;
                }
                case '(': 
                case '[': {
                    ++bracketCount;
                    continue block5;
                }
                case ')': 
                case ']': {
                    --bracketCount;
                }
            }
        }
        return -1;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] descriptors = null;
        descriptors = (PropertyDescriptor[])this.descriptorsCache.get((Object)beanClass);
        if (descriptors != null) {
            return descriptors;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        this.descriptorsCache.put((Object)beanClass, (Object)descriptors);
        return descriptors;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        return this.getPropertyDescriptors(bean.getClass());
    }

    public Class getPropertyEditorClass(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor != null) {
            return descriptor.getPropertyEditorClass();
        }
        return null;
    }

    public Class getPropertyType(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                return null;
            }
            Class type = descriptor.getType();
            if (type == null) {
                return null;
            }
            if (type.isArray()) {
                return type.getComponentType();
            }
            return type;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            return null;
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType();
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            return ((MappedPropertyDescriptor)descriptor).getMappedPropertyType();
        }
        return descriptor.getPropertyType();
    }

    public Method getReadMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getReadMethod());
    }

    public Object getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nested property names are not allowed");
        }
        if (name.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Indexed property names are not allowed");
        }
        if (name.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Mapped property names are not allowed");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "'");
            }
            return ((DynaBean)bean).get(name);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        Method readMethod = this.getReadMethod(descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object value = this.invokeMethod(readMethod, bean, new Object[0]);
        return value;
    }

    public Method getWriteMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getWriteMethod());
    }

    public boolean isReadable(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean, name);
            if (desc != null) {
                Method readMethod = desc.getReadMethod();
                if (readMethod == null && desc instanceof IndexedPropertyDescriptor) {
                    readMethod = ((IndexedPropertyDescriptor)desc).getIndexedReadMethod();
                }
                return readMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isWriteable(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean, name);
            if (desc != null) {
                Method writeMethod = desc.getWriteMethod();
                if (writeMethod == null && desc instanceof IndexedPropertyDescriptor) {
                    writeMethod = ((IndexedPropertyDescriptor)desc).getIndexedWriteMethod();
                }
                return writeMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void setIndexedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int delim = name.indexOf(91);
        int delim2 = name.indexOf(93);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        int index = -1;
        try {
            String subscript = name.substring(delim + 1, delim2);
            index = Integer.parseInt(subscript);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        name = name.substring(0, delim);
        this.setIndexedProperty(bean, name, index, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIndexedProperty(Object bean, String name, int index, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method writeMethod;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "'");
            }
            ((DynaBean)bean).set(name, index, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor && (writeMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod()) != null) {
            Object[] subscript = new Object[]{new Integer(index), value};
            try {
                if (this.log.isTraceEnabled()) {
                    String valueClassName = value == null ? "<null>" : value.getClass().getName();
                    this.log.trace((Object)("setSimpleProperty: Invoking method " + writeMethod + " with index=" + index + ", value=" + value + " (class " + valueClassName + ")"));
                }
                this.invokeMethod(writeMethod, bean, subscript);
                return;
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof ArrayIndexOutOfBoundsException)) throw e;
                throw (ArrayIndexOutOfBoundsException)e.getTargetException();
            }
        }
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object array = this.invokeMethod(readMethod, bean, new Object[0]);
        if (!array.getClass().isArray()) {
            if (!(array instanceof List)) throw new IllegalArgumentException("Property '" + name + "' is not indexed");
            ((List)array).set(index, value);
            return;
        } else {
            Array.set(array, index, value);
        }
    }

    public void setMappedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int delim = name.indexOf(40);
        int delim2 = name.indexOf(41);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "'");
        }
        String key = name.substring(delim + 1, delim2);
        name = name.substring(0, delim);
        this.setMappedProperty(bean, name, key, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMappedProperty(Object bean, String name, String key, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "'");
            }
            ((DynaBean)bean).set(name, key, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method mappedWriteMethod = ((MappedPropertyDescriptor)descriptor).getMappedWriteMethod();
            if (mappedWriteMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped setter method");
            Object[] params = new Object[]{key, value};
            if (this.log.isTraceEnabled()) {
                String valueClassName = value == null ? "<null>" : value.getClass().getName();
                this.log.trace((Object)("setSimpleProperty: Invoking method " + mappedWriteMethod + " with key=" + key + ", value=" + value + " (class " + valueClassName + ")"));
            }
            this.invokeMethod(mappedWriteMethod, bean, params);
            return;
        } else {
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method");
            Object invokeResult = this.invokeMethod(readMethod, bean, new Object[0]);
            if (!(invokeResult instanceof Map)) return;
            ((Map)invokeResult).put(key, value);
        }
    }

    public void setNestedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int delim;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int indexOfINDEXED_DELIM = -1;
        int indexOfMAPPED_DELIM = -1;
        while ((delim = name.indexOf(46)) >= 0) {
            String next = name.substring(0, delim);
            indexOfINDEXED_DELIM = next.indexOf(91);
            indexOfMAPPED_DELIM = next.indexOf(40);
            if ((bean = bean instanceof Map ? ((Map)bean).get(next) : (indexOfMAPPED_DELIM >= 0 ? this.getMappedProperty(bean, next) : (indexOfINDEXED_DELIM >= 0 ? this.getIndexedProperty(bean, next) : this.getSimpleProperty(bean, next)))) == null) {
                throw new IllegalArgumentException("Null property value for '" + name.substring(0, delim) + "'");
            }
            name = name.substring(delim + 1);
        }
        indexOfINDEXED_DELIM = name.indexOf(91);
        indexOfMAPPED_DELIM = name.indexOf(40);
        if (bean instanceof Map) {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
            if (descriptor == null) {
                ((Map)bean).put(name, value);
            } else {
                this.setSimpleProperty(bean, name, value);
            }
        } else if (indexOfMAPPED_DELIM >= 0) {
            this.setMappedProperty(bean, name, value);
        } else if (indexOfINDEXED_DELIM >= 0) {
            this.setIndexedProperty(bean, name, value);
        } else {
            this.setSimpleProperty(bean, name, value);
        }
    }

    public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.setNestedProperty(bean, name, value);
    }

    public void setSimpleProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nested property names are not allowed");
        }
        if (name.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Indexed property names are not allowed");
        }
        if (name.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Mapped property names are not allowed");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "'");
            }
            ((DynaBean)bean).set(name, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        Method writeMethod = this.getWriteMethod(descriptor);
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method");
        }
        Object[] values = new Object[]{value};
        if (this.log.isTraceEnabled()) {
            String valueClassName = value == null ? "<null>" : value.getClass().getName();
            this.log.trace((Object)("setSimpleProperty: Invoking method " + writeMethod + " with value " + value + " (class " + valueClassName + ")"));
        }
        this.invokeMethod(writeMethod, bean, values);
    }

    private Object invokeMethod(Method method, Object bean, Object[] values) throws IllegalAccessException, InvocationTargetException {
        try {
            return method.invoke(bean, values);
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)"Method invocation failed.", (Throwable)e);
            throw new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " - " + e.getMessage());
        }
    }
}

