/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.def.LinkDefinition;
import org.jbpm.bpel.sublang.def.JoinCondition;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public abstract class StructuredActivity
extends CompositeActivity
implements NodeCollection {
    protected List nodes = new ArrayList();
    protected Begin begin = new Begin(this);
    protected End end = new End(this);
    private transient Map nodesMap;

    protected StructuredActivity() {
    }

    protected StructuredActivity(String name) {
        super(name);
    }

    public void enter(ExecutionContext exeContext) {
        this.begin.enter(exeContext);
    }

    public void execute(ExecutionContext exeContext) {
        this.begin.leave(exeContext, this.begin.getDefaultLeavingTransition());
    }

    public void leave(ExecutionContext exeContext) {
        this.end.leave(exeContext);
    }

    public void skip(ExecutionContext exeContext) {
        this.eliminatePath(exeContext.getToken());
        this.end.leave(exeContext, this.getDefaultLeavingTransition());
    }

    public void eliminatePath(Token token) {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            Activity activity = (Activity)((Object)this.nodes.get(i));
            activity.eliminatePath(token);
        }
        this.end.eliminatePath(token);
    }

    public Begin getBegin() {
        return this.begin;
    }

    public End getEnd() {
        return this.end;
    }

    public Node addNode(Node node) {
        if (!(node instanceof Activity)) {
            throw new IllegalArgumentException("cannot add non-bpel activity to structure: " + node);
        }
        this.addActivity((Activity)node);
        return node;
    }

    protected void addActivity(Activity activity) {
        this.addImplicitTransitions(activity);
        activity.detachFromParent();
        this.adoptActivity(activity);
        this.nodes.add(activity);
        if (this.nodesMap != null) {
            this.nodesMap.put(activity.getName(), activity);
        }
    }

    public Node removeNode(Node node) {
        if (!this.nodes.contains(node)) {
            return null;
        }
        this.removeActivity((Activity)node);
        return node;
    }

    protected void removeActivity(Activity activity) {
        this.removeImplicitTransitions(activity);
        this.disadoptActivity(activity);
        this.nodes.remove((Object)activity);
        if (this.nodesMap != null) {
            this.nodesMap.remove(activity.getName());
        }
    }

    public void reorderNode(int oldIndex, int newIndex) {
        this.nodes.add(newIndex, this.nodes.remove(oldIndex));
    }

    public List getNodes() {
        return this.nodes;
    }

    public Map getNodesMap() {
        if (this.nodesMap == null && this.nodes != null) {
            this.nodesMap = new HashMap();
            int n = this.nodes.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)this.nodes.get(i);
                this.nodesMap.put(node.getName(), node);
            }
        }
        return this.nodesMap;
    }

    public Node getNode(String name) {
        Map nodesMap = this.getNodesMap();
        return nodesMap != null ? (Node)nodesMap.get(name) : null;
    }

    public boolean hasNode(String name) {
        Map nodesMap = this.getNodesMap();
        return nodesMap != null ? nodesMap.containsKey(name) : false;
    }

    protected void addImplicitTransitions(Activity activity) {
        this.begin.connect(activity);
        activity.connect(this.end);
    }

    protected void removeImplicitTransitions(Activity activity) {
        this.begin.disconnect(activity);
        activity.disconnect(this.end);
    }

    public JoinCondition getJoinCondition() {
        return this.begin.getJoinCondition();
    }

    public void setJoinCondition(JoinCondition joinCondition) {
        this.begin.setJoinCondition(joinCondition);
    }

    public List getSources() {
        return this.end.getSources();
    }

    public void addSource(LinkDefinition link) {
        this.end.addSource(link);
    }

    public LinkDefinition getSource(String linkName) {
        return this.end.getSource(linkName);
    }

    public LinkDefinition getTarget(String linkName) {
        return this.begin.getTarget(linkName);
    }

    public List getTargets() {
        return this.begin.getTargets();
    }

    public void addTarget(LinkDefinition link) {
        this.begin.addTarget(link);
    }

    public Transition getDefaultArrivingTransition() {
        return this.begin.getDefaultArrivingTransition();
    }

    public Transition getDefaultLeavingTransition() {
        return this.end.getDefaultLeavingTransition();
    }

    public Transition addArrivingTransition(Transition transition) {
        return this.begin.addArrivingTransition(transition);
    }

    public Transition addLeavingTransition(Transition transition) {
        return this.end.addLeavingTransition(transition);
    }

    public static class End
    extends Activity {
        private static final long serialVersionUID = 1L;

        End() {
        }

        End(StructuredActivity structure) {
            super("end");
            structure.adoptActivity(this);
        }

        public void execute(ExecutionContext exeContext) {
            this.getCompositeActivity().leave(exeContext);
        }
    }

    public static class Begin
    extends Activity {
        private static final long serialVersionUID = 1L;

        Begin() {
        }

        Begin(StructuredActivity structure) {
            super("begin");
            structure.adoptActivity(this);
        }

        public void execute(ExecutionContext exeContext) {
            this.getCompositeActivity().execute(exeContext);
        }

        public void skip(ExecutionContext exeContext) {
            this.getCompositeActivity().skip(exeContext);
        }
    }
}

