/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.messaging.util.CompatibleExecutor;
import org.jboss.messaging.util.ExecutorFactory;

public final class OrderedExecutorFactory
implements ExecutorFactory {
    private final Executor parent;
    private final Set<ChildExecutor> runningChildren = Collections.synchronizedSet(new HashSet());

    public OrderedExecutorFactory(Executor parent) {
        this.parent = parent;
    }

    public CompatibleExecutor getExecutor(String name) {
        return new ChildExecutor(name);
    }

    private final class ChildExecutor
    implements CompatibleExecutor,
    Runnable {
        private final LinkedList<Runnable> tasks = new LinkedList();
        private boolean needToSetClassLoader = true;
        private ClassLoader tcl;
        private boolean shutdown = false;
        private String name = "default-thread";

        public ChildExecutor(String n) {
            this.name = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Runnable command) {
            if (this.needToSetClassLoader) {
                this.tcl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                if (!this.shutdown) {
                    this.tasks.add(command);
                    if (this.tasks.size() == 1 && OrderedExecutorFactory.this.runningChildren.add(this)) {
                        OrderedExecutorFactory.this.parent.execute(this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.needToSetClassLoader) {
                this.needToSetClassLoader = false;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(ChildExecutor.this.tcl);
                        return null;
                    }
                });
            }
            while (true) {
                Runnable task;
                LinkedList<Runnable> linkedList = this.tasks;
                synchronized (linkedList) {
                    task = this.tasks.poll();
                    if (task == null) {
                        OrderedExecutorFactory.this.runningChildren.remove(this);
                        this.tasks.notify();
                        return;
                    }
                }
                task.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearAllExceptCurrentTask() {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.clear();
            }
        }

        public void clearClassLoader() {
            this.execute(new Runnable(){

                public void run() {
                    ChildExecutor.this.needToSetClassLoader = true;
                }
            });
        }

        public void shutdownNow() {
            this.tasks.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownAfterProcessingCurrentlyQueuedTasks() {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                this.shutdown = true;
                while (this.tasks.size() > 0) {
                    try {
                        this.tasks.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public String getName() {
            return this.name;
        }
    }
}

