/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class JTATableIdGenerator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String COLUMN = "column";
    public static final String DEFAULT_COLUMN_NAME = "next_hi";
    public static final String TABLE = "table";
    public static final String DEFAULT_TABLE_NAME = "next_hi";
    public static final String ALLOCATION_SIZE = "allocationSize";
    public static final int DEFAULT_ALLOCATION_SIZE = 20;
    private static final Log log = LogFactory.getLog(JTATableIdGenerator.class);
    private String tableName;
    private String columnName;
    private String query;
    private String update;
    private TransactionManagerLookup transactionManagerLookup;
    private Class returnClass;
    private int allocationSize;

    public void configure(Type type, Properties params, Dialect dialect) {
        this.tableName = PropertiesHelper.getString((String)TABLE, (Properties)params, (String)"next_hi");
        this.columnName = PropertiesHelper.getString((String)COLUMN, (Properties)params, (String)"next_hi");
        this.allocationSize = PropertiesHelper.getInt((String)ALLOCATION_SIZE, (Properties)params, (int)20);
        String schemaName = params.getProperty("schema");
        String catalogName = params.getProperty("catalog");
        throw new RuntimeException("DOES ANYBODY USE THIS?  It IS CURRENTLY BROKEN");
    }

    public synchronized Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        TransactionManager tm = this.transactionManagerLookup.getTransactionManager(new Properties());
        Transaction surroundingTransaction = null;
        Connection conn = null;
        String sql = null;
        try {
            long result;
            surroundingTransaction = tm.suspend();
            if (log.isDebugEnabled()) {
                log.debug((Object)"surrounding tx suspended");
            }
            tm.begin();
            conn = session.getBatcher().openConnection();
            sql = this.query;
            PreparedStatement qps = conn.prepareStatement(this.query);
            try {
                ResultSet rs = qps.executeQuery();
                if (!rs.next()) {
                    String err = "could not read sequence value - you need to populate the table: " + this.tableName;
                    log.error((Object)err);
                    throw new IdentifierGenerationException(err);
                }
                result = rs.getLong(1);
                rs.close();
            }
            catch (SQLException sqle) {
                log.error((Object)"could not read a sequence value", (Throwable)sqle);
                throw sqle;
            }
            finally {
                qps.close();
            }
            sql = this.update;
            long sequence = result + 1L;
            PreparedStatement ups = conn.prepareStatement(this.update);
            try {
                ups.setLong(1, sequence);
                ups.setLong(2, result);
                ups.executeUpdate();
            }
            catch (SQLException sqle) {
                log.error((Object)("could not update sequence value in: " + this.tableName), (Throwable)sqle);
                throw sqle;
            }
            finally {
                ups.close();
            }
            tm.commit();
            Number typedSequence = IdentifierGeneratorFactory.createNumber((long)sequence, (Class)this.returnClass);
            if (log.isDebugEnabled()) {
                log.debug((Object)("generate() returned: " + typedSequence));
            }
            Number number = typedSequence;
            return number;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert((SQLExceptionConverter)session.getFactory().getSQLExceptionConverter(), (SQLException)sqle, (String)"could not get or update next value", sql);
        }
        catch (Exception e) {
            try {
                tm.rollback();
                throw new HibernateException((Throwable)e);
            }
            catch (SystemException e1) {
                throw new HibernateException((Throwable)e1);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
            if (surroundingTransaction != null) {
                try {
                    tm.resume(surroundingTransaction);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"surrounding tx resumed");
                    }
                }
                catch (Exception e) {
                    throw new HibernateException((Throwable)e);
                }
            }
        }
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{"create table " + this.tableName + " ( " + this.columnName + " " + dialect.getTypeName(-5) + " )", "insert into " + this.tableName + " values ( 0 )"};
    }

    public String[] sqlDropStrings(Dialect dialect) {
        StringBuffer sqlDropString = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return new String[]{sqlDropString.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }
}

