/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools.codegen;

import cirrus.hibernate.tools.codegen.ClassMapping;
import cirrus.hibernate.tools.codegen.Field;
import cirrus.hibernate.tools.codegen.Renderer;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class BasicRenderer
implements Renderer {
    String getTrueTypeName(Field field, Map class2classmap) {
        String name = field.getClassType() != null ? field.getClassType().getFullyQualifiedName() : field.getType();
        ClassMapping cmap = (ClassMapping)class2classmap.get(name);
        if (cmap != null && cmap.getProxy() != null) {
            return cmap.getProxy();
        }
        return name;
    }

    public void render(String packageName, String className, ClassMapping classMapping, Map class2classmap, PrintWriter writer) throws Exception {
        Field field;
        Iterator fields;
        Field field2;
        Iterator fields2;
        if (classMapping.getPackageName() != null) {
            writer.println("package " + classMapping.getPackageName() + ";");
        } else {
            writer.println("// default package");
        }
        writer.println();
        classMapping.getImports().add("java.io.Serializable");
        classMapping.getImports().add("org.apache.commons.lang.builder.ToStringBuilder");
        if (classMapping.mustImplementEquals()) {
            classMapping.getImports().add("org.apache.commons.lang.builder.EqualsBuilder");
            classMapping.getImports().add("org.apache.commons.lang.builder.HashCodeBuilder");
        }
        Iterator imports = classMapping.getImports().iterator();
        while (imports.hasNext()) {
            writer.println("import " + imports.next() + ";");
        }
        writer.println();
        writer.println("/** @author Hibernate CodeGenerator */");
        writer.print("public class " + classMapping.getName());
        if (classMapping.getSuperClass() != null) {
            writer.print(" extends " + classMapping.getSuperClass());
        }
        writer.print(" implements Serializable");
        if (classMapping.getProxy() != null && !classMapping.getProxy().equals(classMapping.getCanonicalName())) {
            writer.print(", ");
            writer.print(classMapping.getProxy());
        }
        writer.println(" {");
        writer.println();
        Iterator fields3 = classMapping.getFields().iterator();
        while (fields3.hasNext()) {
            Field field3 = (Field)fields3.next();
            writer.println("    /** " + (field3.isNullable() && !field3.isIdentifier() ? "nullable " : "") + (field3.isIdentifier() ? "identifier" : "persistent") + " field */");
            writer.println("    private " + this.shortenType(field3.getType(), classMapping.getImports()) + ' ' + field3.getName() + ';');
            writer.println();
        }
        List allFieldsForFullConstructor = classMapping.getAllFieldsForFullConstructor();
        writer.println("    /** full constructor */");
        String fullCons = "    public " + classMapping.getName() + "(";
        Iterator fields4 = allFieldsForFullConstructor.iterator();
        while (fields4.hasNext()) {
            Field field4 = (Field)fields4.next();
            fullCons = fullCons + this.shortenType(this.getTrueTypeName(field4, class2classmap), classMapping.getImports()) + " " + field4.getName();
            if (!fields4.hasNext()) continue;
            fullCons = fullCons + ", ";
        }
        writer.println(fullCons + ") {");
        List supersConstructorFields = classMapping.getFieldsForSupersFullConstructor();
        if (!supersConstructorFields.isEmpty()) {
            writer.print("        super(");
            fields2 = supersConstructorFields.iterator();
            while (fields2.hasNext()) {
                field2 = (Field)fields2.next();
                writer.print(field2.getName());
                if (!fields2.hasNext()) continue;
                writer.print(", ");
            }
            writer.println(");");
        }
        fields2 = classMapping.getLocalFieldsForFullConstructor().iterator();
        while (fields2.hasNext()) {
            field2 = (Field)fields2.next();
            writer.println("        this." + field2.getName() + " = " + field2.getName() + ";");
        }
        writer.println("    }");
        writer.println();
        if (allFieldsForFullConstructor.size() > 0) {
            writer.println("    /** default constructor */");
            writer.println("    public " + classMapping.getName() + "() {");
            writer.println("    }");
            writer.println();
        }
        if (allFieldsForFullConstructor.size() > 0 && classMapping.needsMinimalConstructor()) {
            Field field5;
            Iterator fields5;
            List allFieldsForMinimalConstructor = classMapping.getAllFieldsForMinimalConstructor();
            writer.println("    /** minimal constructor */");
            String minCons = "    public " + classMapping.getName() + "(";
            fields = allFieldsForMinimalConstructor.iterator();
            while (fields.hasNext()) {
                field = (Field)fields.next();
                minCons = minCons + this.shortenType(this.getTrueTypeName(field, class2classmap), classMapping.getImports()) + " " + field.getName();
                if (!fields.hasNext()) continue;
                minCons = minCons + ", ";
            }
            writer.println(minCons + ") {");
            List supersMinConstructorFields = classMapping.getFieldsForSupersMinimalConstructor();
            if (!supersMinConstructorFields.isEmpty()) {
                writer.print("      super(");
                fields5 = supersMinConstructorFields.iterator();
                while (fields5.hasNext()) {
                    field5 = (Field)fields5.next();
                    writer.print(field5.getName());
                    if (!fields5.hasNext()) continue;
                    writer.print(", ");
                }
                writer.println(");");
            }
            fields5 = classMapping.getLocalFieldsForMinimalConstructor().iterator();
            while (fields5.hasNext()) {
                field5 = (Field)fields5.next();
                writer.println("        this." + field5.getName() + " = " + field5.getName() + ";");
            }
            writer.println("    }");
            writer.println();
        }
        Iterator fields6 = classMapping.getFields().iterator();
        while (fields6.hasNext()) {
            Field field6 = (Field)fields6.next();
            String getterType = field6.getType().toLowerCase().equals("boolean") ? " is" : " get";
            writer.println("    public " + this.getTrueTypeName(field6, class2classmap) + getterType + field6.getAsSuffix() + "() {");
            writer.println("        return this." + field6.getName() + ";");
            writer.println("    }");
            writer.println("");
            writer.println("    public void set" + field6.getAsSuffix() + "(" + this.getTrueTypeName(field6, class2classmap) + " " + field6.getName() + ") {");
            writer.println("        this." + field6.getName() + " = " + field6.getName() + ";");
            writer.println("    }");
        }
        writer.println();
        writer.println("    public String toString() {");
        writer.println("        return ToStringBuilder.reflectionToString(this);");
        writer.println("    }");
        writer.println();
        if (classMapping.mustImplementEquals()) {
            writer.println("    public boolean equals(Object other) {");
            writer.println("        if ( !(other instanceof " + className + ") ) return false;");
            writer.println("        " + className + " castOther = (" + className + ") other;");
            writer.println("        return new EqualsBuilder()");
            Iterator fields7 = classMapping.getFields().iterator();
            while (fields7.hasNext()) {
                Field field7 = (Field)fields7.next();
                if (!field7.isIdentifier()) continue;
                writer.println("            .append(this." + field7.getName() + ", castOther." + field7.getName() + ")");
            }
            writer.println("            .isEquals();");
            writer.println("    }");
            writer.println();
            writer.println("    public int hashCode() {");
            writer.println("        return new HashCodeBuilder()");
            fields = classMapping.getFields().iterator();
            while (fields.hasNext()) {
                field = (Field)fields.next();
                if (!field.isIdentifier()) continue;
                writer.println("            .append(" + field.getName() + ")");
            }
            writer.println("            .toHashCode();");
            writer.println("    }");
            writer.println();
        }
        writer.println("}");
    }

    private String shortenType(String type, TreeSet imports) {
        if (imports.contains(type)) {
            return type.substring(type.lastIndexOf(46) + 1);
        }
        if (type.endsWith("[]")) {
            return this.shortenType(type.substring(0, type.length() - 2), imports) + "[]";
        }
        return type;
    }
}

