/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.UniqueConstraint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.ForceDiscriminator;
import org.hibernate.annotations.Loader;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.Value;
import org.hibernate.reflection.XAnnotatedElement;
import org.hibernate.reflection.XClass;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityBinder {
    private String name;
    private XClass annotatedClass;
    private PersistentClass persistentClass;
    private ExtendedMappings mappings;
    private static Log log = LogFactory.getLog(EntityBinder.class);
    private String discriminatorValue = "";
    private boolean isPropertyAnnotated = false;
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private boolean explicitHibernateEntityAnnotation;
    private boolean mutable;
    private OptimisticLockType optimisticLockType;
    private String persister;
    private PolymorphismType polymorphismType;
    private boolean selectBeforeUpdate;
    private int batchSize;
    private boolean lazy;
    private XClass proxyClass;
    private String where;
    private Map<String, Join> secondaryTables = new HashMap<String, Join>();
    private Map<String, Object> secondaryTableJoins = new HashMap<String, Object>();
    private String cacheConcurrentStrategy;
    private String cacheRegion;
    private Map<String, String> filters = new HashMap<String, String>();
    private InheritanceState inheritanceState;
    private boolean ignoreIdAnnotations;
    private boolean cacheLazyProperty;
    private String propertyAccessor;

    public boolean isPropertyAnnotated() {
        return this.isPropertyAnnotated;
    }

    public EntityBinder() {
    }

    public EntityBinder(Entity ejb3Ann, org.hibernate.annotations.Entity hibAnn, XClass annotatedClass, PersistentClass persistentClass, ExtendedMappings mappings) {
        this.mappings = mappings;
        this.persistentClass = persistentClass;
        this.annotatedClass = annotatedClass;
        this.bindEjb3Annotation(ejb3Ann);
        this.bindHibernateAnnotation(hibAnn);
    }

    private void bindHibernateAnnotation(org.hibernate.annotations.Entity hibAnn) {
        if (hibAnn != null) {
            this.dynamicInsert = hibAnn.dynamicInsert();
            this.dynamicUpdate = hibAnn.dynamicUpdate();
            this.mutable = hibAnn.mutable();
            this.optimisticLockType = hibAnn.optimisticLock();
            this.persister = hibAnn.persister();
            this.selectBeforeUpdate = hibAnn.selectBeforeUpdate();
            this.polymorphismType = hibAnn.polymorphism();
            this.explicitHibernateEntityAnnotation = true;
        } else {
            this.dynamicInsert = false;
            this.dynamicUpdate = false;
            this.mutable = true;
            this.optimisticLockType = OptimisticLockType.VERSION;
            this.persister = "";
            this.polymorphismType = PolymorphismType.IMPLICIT;
            this.selectBeforeUpdate = false;
        }
    }

    private void bindEjb3Annotation(Entity ejb3Ann) {
        if (ejb3Ann == null) {
            throw new AssertionFailure("@Entity should always be not null");
        }
        this.name = BinderHelper.isDefault(ejb3Ann.name()) ? StringHelper.unqualify((String)this.annotatedClass.getName()) : ejb3Ann.name();
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public void bindEntity() {
        this.persistentClass.setAbstract(Boolean.valueOf(this.annotatedClass.isAbstract()));
        this.persistentClass.setClassName(this.annotatedClass.getName());
        this.persistentClass.setEntityName(this.annotatedClass.getName());
        this.bindDiscriminatorValue();
        this.persistentClass.setLazy(this.lazy);
        if (this.proxyClass != null) {
            this.persistentClass.setProxyInterfaceName(this.proxyClass.getName());
        }
        this.persistentClass.setDynamicInsert(this.dynamicInsert);
        this.persistentClass.setDynamicUpdate(this.dynamicUpdate);
        if (this.persistentClass instanceof RootClass) {
            RootClass rootClass = (RootClass)this.persistentClass;
            rootClass.setMutable(this.mutable);
            rootClass.setExplicitPolymorphism(this.isExplicitPolymorphism(this.polymorphismType));
            if (StringHelper.isNotEmpty((String)this.where)) {
                rootClass.setWhere(this.where);
            }
            if (this.cacheConcurrentStrategy != null) {
                rootClass.setCacheConcurrencyStrategy(this.cacheConcurrentStrategy);
                rootClass.setCacheRegionName(this.cacheRegion);
                rootClass.setLazyPropertiesCacheable(this.cacheLazyProperty);
            }
            rootClass.setForceDiscriminator(this.annotatedClass.isAnnotationPresent(ForceDiscriminator.class));
        } else if (this.explicitHibernateEntityAnnotation) {
            log.warn((Object)("@org.hibernate.annotations.Entity used on a non root entity: ignored for " + this.annotatedClass.getName()));
        }
        this.persistentClass.setOptimisticLockMode(this.getVersioning(this.optimisticLockType));
        this.persistentClass.setSelectBeforeUpdate(this.selectBeforeUpdate);
        if (!BinderHelper.isDefault(this.persister)) {
            try {
                this.persistentClass.setEntityPersisterClass(ReflectHelper.classForName((String)this.persister));
            }
            catch (ClassNotFoundException cnfe) {
                throw new AnnotationException("Could not find persister class: " + this.persister);
            }
        }
        this.persistentClass.setBatchSize(this.batchSize);
        SQLInsert sqlInsert = (SQLInsert)this.annotatedClass.getAnnotation(SQLInsert.class);
        SQLUpdate sqlUpdate = (SQLUpdate)this.annotatedClass.getAnnotation(SQLUpdate.class);
        SQLDelete sqlDelete = (SQLDelete)this.annotatedClass.getAnnotation(SQLDelete.class);
        SQLDeleteAll sqlDeleteAll = (SQLDeleteAll)this.annotatedClass.getAnnotation(SQLDeleteAll.class);
        Loader loader = (Loader)this.annotatedClass.getAnnotation(Loader.class);
        if (sqlInsert != null) {
            this.persistentClass.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.parse((String)sqlInsert.check().toString().toLowerCase()));
        }
        if (sqlUpdate != null) {
            this.persistentClass.setCustomSQLUpdate(sqlUpdate.sql(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.parse((String)sqlUpdate.check().toString().toLowerCase()));
        }
        if (sqlDelete != null) {
            this.persistentClass.setCustomSQLDelete(sqlDelete.sql(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.parse((String)sqlDelete.check().toString().toLowerCase()));
        }
        if (sqlDeleteAll != null) {
            this.persistentClass.setCustomSQLDelete(sqlDeleteAll.sql(), sqlDeleteAll.callable(), ExecuteUpdateResultCheckStyle.parse((String)sqlDeleteAll.check().toString().toLowerCase()));
        }
        if (loader != null) {
            this.persistentClass.setLoaderName(loader.namedQuery());
        }
        if (!this.inheritanceState.hasParents) {
            for (Map.Entry<String, String> filter : this.filters.entrySet()) {
                String filterName = filter.getKey();
                String cond = filter.getValue();
                if (BinderHelper.isDefault(cond) && StringHelper.isEmpty((String)(cond = this.mappings.getFilterDefinition(filterName).getDefaultFilterCondition()))) {
                    throw new AnnotationException("no filter condition found for filter " + filterName + " in " + this.name);
                }
                this.persistentClass.addFilter(filterName, cond);
            }
        } else if (this.filters.size() > 0) {
            log.warn((Object)("@Filter not allowed on subclasses (ignored): " + this.persistentClass.getEntityName()));
        }
        log.debug((Object)("Import with entity name=" + this.name));
        try {
            this.mappings.addImport(this.persistentClass.getEntityName(), this.name);
            String entityName = this.persistentClass.getEntityName();
            if (!entityName.equals(this.name)) {
                this.mappings.addImport(entityName, entityName);
            }
        }
        catch (MappingException me) {
            throw new AnnotationException("Use of the same entity name twice: " + this.name, me);
        }
    }

    public void bindDiscriminatorValue() {
        if (StringHelper.isEmpty((String)this.discriminatorValue)) {
            Value discriminator = this.persistentClass.getDiscriminator();
            if (discriminator == null) {
                this.persistentClass.setDiscriminatorValue(this.name);
            } else {
                if ("character".equals(discriminator.getType().getName())) {
                    throw new AnnotationException("Using default @DiscriminatorValue for a discriminator of type CHAR is not safe");
                }
                if ("integer".equals(discriminator.getType().getName())) {
                    this.persistentClass.setDiscriminatorValue(String.valueOf(this.name.hashCode()));
                } else {
                    this.persistentClass.setDiscriminatorValue(this.name);
                }
            }
        } else {
            this.persistentClass.setDiscriminatorValue(this.discriminatorValue);
        }
    }

    int getVersioning(OptimisticLockType type) {
        switch (type) {
            case VERSION: {
                return 0;
            }
            case NONE: {
                return -1;
            }
            case DIRTY: {
                return 1;
            }
            case ALL: {
                return 2;
            }
        }
        throw new AssertionFailure("optimistic locking not supported: " + (Object)((Object)type));
    }

    private boolean isExplicitPolymorphism(PolymorphismType type) {
        switch (type) {
            case IMPLICIT: {
                return false;
            }
            case EXPLICIT: {
                return true;
            }
        }
        throw new AssertionFailure("Unknown polymorphism type: " + (Object)((Object)type));
    }

    public void setBatchSize(BatchSize sizeAnn) {
        this.batchSize = sizeAnn != null ? sizeAnn.size() : -1;
    }

    public void setProxy(Proxy proxy) {
        if (proxy != null) {
            this.lazy = proxy.lazy();
            this.proxyClass = !this.lazy ? null : (AnnotationBinder.isDefault(this.mappings.getReflectionManager().toXClass(proxy.proxyClass()), this.mappings) ? this.annotatedClass : this.mappings.getReflectionManager().toXClass(proxy.proxyClass()));
        } else {
            this.lazy = true;
            this.proxyClass = this.annotatedClass;
        }
    }

    public void setWhere(Where whereAnn) {
        if (whereAnn != null) {
            this.where = whereAnn.clause();
        }
    }

    private String getClassTableName(String tableName) {
        if (StringHelper.isEmpty((String)tableName)) {
            return this.mappings.getNamingStrategy().classToTableName(this.name);
        }
        return this.mappings.getNamingStrategy().tableName(tableName);
    }

    public void bindTable(String schema, String catalog, String tableName, List uniqueConstraints, String constraints, Table denormalizedSuperclassTable) {
        String logicalName = StringHelper.isNotEmpty((String)tableName) ? tableName : StringHelper.unqualify((String)this.name);
        Table table = TableBinder.fillTable(schema, catalog, this.getClassTableName(tableName), logicalName, this.persistentClass.isAbstract(), uniqueConstraints, constraints, denormalizedSuperclassTable, this.mappings);
        if (this.persistentClass instanceof TableOwner) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Bind entity " + this.persistentClass.getEntityName() + " on table " + table.getName()));
            }
        } else {
            throw new AssertionFailure("binding a table for a subclass");
        }
        ((TableOwner)this.persistentClass).setTable(table);
    }

    public void finalSecondaryTableBinding(PropertyHolder propertyHolder) {
        Iterator<Join> joins = this.secondaryTables.values().iterator();
        Iterator<Object> joinColumns = this.secondaryTableJoins.values().iterator();
        while (joins.hasNext()) {
            Object uncastedColumn = joinColumns.next();
            Join join = joins.next();
            this.createPrimaryColumnsToSecondaryTable(uncastedColumn, propertyHolder, join);
        }
        this.mappings.addJoins(this.persistentClass, this.secondaryTables);
    }

    private void createPrimaryColumnsToSecondaryTable(Object uncastedColumn, PropertyHolder propertyHolder, Join join) {
        Ejb3JoinColumn[] ejb3JoinColumns;
        PrimaryKeyJoinColumn[] pkColumnsAnn = null;
        JoinColumn[] joinColumnsAnn = null;
        if (uncastedColumn instanceof PrimaryKeyJoinColumn[]) {
            pkColumnsAnn = (PrimaryKeyJoinColumn[])uncastedColumn;
        }
        if (uncastedColumn instanceof JoinColumn[]) {
            joinColumnsAnn = (JoinColumn[])uncastedColumn;
        }
        if (pkColumnsAnn == null && joinColumnsAnn == null) {
            ejb3JoinColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(null, null, (Value)this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings)};
        } else {
            int nbrOfJoinColumns;
            int n = nbrOfJoinColumns = pkColumnsAnn != null ? pkColumnsAnn.length : joinColumnsAnn.length;
            if (nbrOfJoinColumns == 0) {
                ejb3JoinColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(null, null, (Value)this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings)};
            } else {
                int colIndex;
                ejb3JoinColumns = new Ejb3JoinColumn[nbrOfJoinColumns];
                if (pkColumnsAnn != null) {
                    for (colIndex = 0; colIndex < nbrOfJoinColumns; ++colIndex) {
                        ejb3JoinColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(pkColumnsAnn[colIndex], null, (Value)this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings);
                    }
                } else {
                    for (colIndex = 0; colIndex < nbrOfJoinColumns; ++colIndex) {
                        ejb3JoinColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(null, joinColumnsAnn[colIndex], (Value)this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings);
                    }
                }
            }
        }
        for (Ejb3JoinColumn joinColumn : ejb3JoinColumns) {
            joinColumn.forceNotNull();
        }
        EntityBinder.bindJoinToPersistentClass(join, ejb3JoinColumns, this.persistentClass, this.mappings);
    }

    public static void bindJoinToPersistentClass(Join join, Ejb3JoinColumn[] ejb3JoinColumns, PersistentClass persistentClass, ExtendedMappings mappings) {
        DependantValue key = new DependantValue(join.getTable(), persistentClass.getIdentifier());
        join.setKey((KeyValue)key);
        join.setSequentialSelect(false);
        join.setInverse(false);
        join.setOptional(true);
        key.setCascadeDeleteEnabled(false);
        TableBinder.bindFk(persistentClass, null, ejb3JoinColumns, (SimpleValue)key, false, mappings);
        join.createPrimaryKey();
        join.createForeignKey();
        persistentClass.addJoin(join);
    }

    public void firstLevelSecondaryTablesBinding(SecondaryTable secTable, SecondaryTables secTables) {
        if (secTables != null) {
            for (SecondaryTable tab : secTables.value()) {
                this.addJoin(tab, null, null, false);
            }
        } else if (secTable != null) {
            this.addJoin(secTable, null, null, false);
        }
    }

    public Join addJoin(JoinTable joinTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        Join join = this.addJoin(null, joinTable, holder, noDelayInPkColumnCreation);
        join.setOptional(true);
        return join;
    }

    private Join addJoin(SecondaryTable secondaryTable, JoinTable joinTable, PropertyHolder propertyHolder, boolean noDelayInPkColumnCreation) {
        UniqueConstraint[] uniqueCosntraintsAnn;
        String realTable;
        String table;
        String catalog;
        String schema;
        Join join = new Join();
        join.setPersistentClass(this.persistentClass);
        if (secondaryTable != null) {
            schema = secondaryTable.schema();
            catalog = secondaryTable.catalog();
            table = secondaryTable.name();
            realTable = this.mappings.getNamingStrategy().tableName(table);
            uniqueCosntraintsAnn = secondaryTable.uniqueConstraints();
        } else if (joinTable != null) {
            schema = joinTable.schema();
            catalog = joinTable.catalog();
            table = joinTable.name();
            realTable = this.mappings.getNamingStrategy().tableName(table);
            uniqueCosntraintsAnn = joinTable.uniqueConstraints();
        } else {
            throw new AssertionFailure("Both JoinTable and SecondaryTable are null");
        }
        ArrayList<String[]> uniqueConstraints = new ArrayList<String[]>(uniqueCosntraintsAnn == null ? 0 : uniqueCosntraintsAnn.length);
        if (uniqueCosntraintsAnn != null && uniqueCosntraintsAnn.length != 0) {
            for (UniqueConstraint uc : uniqueCosntraintsAnn) {
                uniqueConstraints.add(uc.columnNames());
            }
        }
        Table tableMapping = TableBinder.fillTable(schema, catalog, realTable, table, false, uniqueConstraints, null, null, this.mappings);
        join.setTable(tableMapping);
        PrimaryKeyJoinColumn[] joinColumns = null;
        if (secondaryTable != null) {
            joinColumns = secondaryTable.pkJoinColumns();
        } else if (joinTable != null) {
            joinColumns = joinTable.joinColumns();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Adding secondary table to entity " + this.persistentClass.getEntityName() + " -> " + join.getTable().getName()));
        }
        if (noDelayInPkColumnCreation) {
            this.createPrimaryColumnsToSecondaryTable(joinColumns, propertyHolder, join);
        } else {
            this.secondaryTables.put(table, join);
            this.secondaryTableJoins.put(table, joinColumns);
        }
        return join;
    }

    public Map<String, Join> getSecondaryTables() {
        return this.secondaryTables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCache(Cache cacheAnn) {
        if (cacheAnn != null) {
            this.cacheRegion = BinderHelper.isDefault(cacheAnn.region()) ? null : cacheAnn.region();
            this.cacheConcurrentStrategy = EntityBinder.getCacheConcurrencyStrategy(cacheAnn.usage());
            if ("all".equalsIgnoreCase(cacheAnn.include())) {
                this.cacheLazyProperty = true;
                return;
            } else {
                if (!"non-lazy".equalsIgnoreCase(cacheAnn.include())) throw new AnnotationException("Unknown lazy property annotations: " + cacheAnn.include());
                this.cacheLazyProperty = false;
            }
            return;
        } else {
            this.cacheConcurrentStrategy = null;
            this.cacheRegion = null;
            this.cacheLazyProperty = true;
        }
    }

    public static String getCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        switch (strategy) {
            case NONE: {
                return null;
            }
            case READ_ONLY: {
                return "read-only";
            }
            case READ_WRITE: {
                return "read-write";
            }
            case NONSTRICT_READ_WRITE: {
                return "nonstrict-read-write";
            }
            case TRANSACTIONAL: {
                return "transactional";
            }
        }
        throw new AssertionFailure("CacheConcurrencyStrategy unknown: " + (Object)((Object)strategy));
    }

    public void addFilter(String name, String condition) {
        this.filters.put(name, condition);
    }

    public void setInheritanceState(InheritanceState inheritanceState) {
        this.inheritanceState = inheritanceState;
    }

    public boolean isIgnoreIdAnnotations() {
        return this.ignoreIdAnnotations;
    }

    public void setIgnoreIdAnnotations(boolean ignoreIdAnnotations) {
        this.ignoreIdAnnotations = ignoreIdAnnotations;
    }

    public void addIndexes(org.hibernate.annotations.Table table) {
        if (table == null) {
            return;
        }
        String tableName = table.appliesTo();
        Iterator tables = this.persistentClass.getTableClosureIterator();
        Table hibTable = null;
        while (tables.hasNext() && !(hibTable = (Table)tables.next()).getName().equals(tableName)) {
        }
        if (hibTable == null) {
            throw new AnnotationException("@org.hibernate.annotations.Table references an unknown table: " + tableName);
        }
        TableBinder.addIndexes(hibTable, table.indexes(), this.mappings);
    }

    public void addIndexes(Tables tables) {
        if (tables == null) {
            return;
        }
        for (org.hibernate.annotations.Table table : tables.values()) {
            this.addIndexes(table);
        }
    }

    public void setPropertyAnnotated(boolean propertyAnnotated) {
        this.isPropertyAnnotated = propertyAnnotated;
    }

    public String getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public void setPropertyAccessor(String propertyAccessor) {
        this.propertyAccessor = propertyAccessor;
    }

    public boolean isPropertyAnnotated(XAnnotatedElement element) {
        AccessType access = (AccessType)element.getAnnotation(AccessType.class);
        if (access == null) {
            return this.isPropertyAnnotated;
        }
        String propertyAccessor = access.value();
        if ("property".equals(propertyAccessor)) {
            return Boolean.TRUE;
        }
        if ("field".equals(propertyAccessor)) {
            return Boolean.FALSE;
        }
        return this.isPropertyAnnotated;
    }

    public String getPropertyAccessor(XAnnotatedElement element) {
        AccessType access = (AccessType)element.getAnnotation(AccessType.class);
        if (access == null) {
            return this.propertyAccessor;
        }
        return access.value();
    }
}

