/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.application;

import com.icesoft.faces.application.ProductInfo;
import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.webapp.http.servlet.ServletExternalContext;
import com.icesoft.faces.webapp.parser.ImplementationUtil;
import com.icesoft.faces.webapp.parser.JspPageToDocument;
import com.icesoft.faces.webapp.parser.Parser;
import com.icesoft.util.SeamUtilities;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class D2DViewHandler
extends ViewHandler {
    protected static Log log = LogFactory.getLog((Class)D2DViewHandler.class);
    private static final String ACTION_URL_SUFFIX = "com.icesoft.faces.actionURLSuffix";
    private static final String RELOAD_INTERVAL = "com.icesoft.faces.reloadInterval";
    private static final String DO_JSF_STATE_MANAGEMENT = "com.icesoft.faces.doJSFStateManagement";
    public static final String INCLUDE_OPEN_AJAX_HUB = "com.icesoft.faces.openAjaxHub";
    private static final String LAST_LOADED_KEY = "_lastLoaded";
    private static final String LAST_CHECKED_KEY = "_lastChecked";
    public static final String CHAR_ENCODING = "UTF-8";
    public static final String HTML_CONTENT_TYPE = "text/html;charset=UTF-8";
    public static final String DEFAULT_VIEW_ID = "default";
    private String actionURLSuffix;
    protected boolean jsfStateManagement;
    protected long reloadInterval;
    protected long reloadIntervalDefault = 2L;
    private boolean parametersInitialized = false;
    protected Parser parser;
    private ViewHandler delegate;

    public D2DViewHandler() {
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("serializedTagToComponentMapFull.ser");
            this.parser = new Parser(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Throwable te) {
            log.info((Object)"ICEfaces JSP parser disabled. This is a Facelets-only configuration.");
        }
    }

    public D2DViewHandler(ViewHandler delegate) {
        this();
        this.delegate = delegate;
    }

    public void initView(FacesContext facesContext) {
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        this.initializeParameters(context);
        if (SeamUtilities.isSpringEnvironment() && (context = BridgeFacesContext.unwrap(context)) instanceof BridgeFacesContext) {
            ((BridgeFacesContext)context).setCurrentInstance();
        }
        if (this.delegateView(context)) {
            this.delegate.renderView(context, viewToRender);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("renderView(FC,UIVR)  BEFORE  renderResponse  viewToRender.getViewId(): " + viewToRender.getViewId()));
        }
        this.renderResponse(context);
        if (this.jsfStateManagement) {
            StateManager stateMgr = context.getApplication().getStateManager();
            stateMgr.saveSerializedView(context);
        }
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        this.initializeParameters(context);
        if (this.delegateView(context)) {
            return this.delegate.createView(context, viewId);
        }
        if (SeamUtilities.isSeamEnvironment()) {
            ((BridgeExternalContext)context.getExternalContext()).removeSeamLifecycleShortcut();
        }
        UIViewRoot root = new UIViewRoot(){

            public void setLocale(Locale locale) {
                boolean ignore;
                int setLocaleIndex = -1;
                int lifeCycleRestoreViewIndex = -1;
                StackTraceElement[] ste = new RuntimeException().getStackTrace();
                for (int i = 0; i < 10 && i < ste.length; ++i) {
                    String className = ste[i].getClassName().toLowerCase();
                    String methodName = ste[i].getMethodName().toLowerCase();
                    if (setLocaleIndex == -1 && methodName.indexOf("setlocale") >= 0) {
                        setLocaleIndex = i;
                    }
                    if (lifeCycleRestoreViewIndex != -1 || className.indexOf("lifecycle") < 0 || className.indexOf("restoreview") < 0 && methodName.indexOf("restoreview") < 0) continue;
                    lifeCycleRestoreViewIndex = i;
                    break;
                }
                boolean bl = ignore = setLocaleIndex >= 0 && lifeCycleRestoreViewIndex >= 0 && setLocaleIndex + 1 == lifeCycleRestoreViewIndex;
                if (!ignore) {
                    super.setLocale(locale);
                }
            }
        };
        root.setRenderKitId("HTML_BASIC");
        root.setViewId(null == viewId ? DEFAULT_VIEW_ID : viewId);
        String renderedViewId = this.getRenderedViewId(context, root.getViewId());
        root.setViewId(renderedViewId);
        return root;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        this.initializeParameters(context);
        if (this.delegateView(context)) {
            return this.delegate.restoreView(context, viewId);
        }
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext instanceof ServletExternalContext) {
            ServletExternalContext servletExternalContext = (ServletExternalContext)externalContext;
            servletExternalContext.setRequestServletPath(viewId);
            if (null != externalContext.getRequestPathInfo()) {
                servletExternalContext.setRequestPathInfo(viewId);
            }
            if (SeamUtilities.isSeamEnvironment()) {
                if (servletExternalContext.removeSeamLifecycleShortcut()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Seam Keyword shortcut found, new ViewRoot");
                    }
                    return null;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)"No Seam Keyword shortcut found");
                }
            }
        }
        UIViewRoot currentRoot = context.getViewRoot();
        if (SeamUtilities.isSpringEnvironment()) {
            return currentRoot;
        }
        if (null != currentRoot && this.getRenderedViewId(context, viewId).equals(this.getRenderedViewId(context, currentRoot.getViewId()))) {
            return currentRoot;
        }
        return null;
    }

    public static String getServletRequestPath(FacesContext context) {
        if (Beans.isDesignTime()) {
            return context.getViewRoot().getViewId();
        }
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext instanceof BridgeExternalContext) {
            String uri = ((BridgeExternalContext)externalContext).getRequestURI();
            if (null == uri) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Failing over to default request path");
                }
                uri = DEFAULT_VIEW_ID;
            }
            return uri;
        }
        return externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
    }

    public static String getServletRequestPath(ExternalContext externalContext, String viewId) {
        if (externalContext == null) {
            throw new IllegalStateException("ExternalContext is null");
        }
        return externalContext.getRequestContextPath() + viewId;
    }

    public String getActionURL(FacesContext context, String viewId) {
        boolean ifaceSuffix;
        boolean bl = ifaceSuffix = viewId != null && viewId.endsWith(".iface");
        if (this.delegateView(context) && !ifaceSuffix) {
            return this.delegate.getActionURL(context, viewId);
        }
        if (viewId.indexOf("://") >= 0) {
            return viewId;
        }
        if (viewId.charAt(0) != '/') {
            throw new IllegalArgumentException("viewId " + viewId + "does not begin with '/'");
        }
        if (null != this.actionURLSuffix) {
            viewId = viewId.substring(0, viewId.lastIndexOf(".")) + this.actionURLSuffix;
        }
        return context.getExternalContext().getRequestContextPath() + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        ExternalContext externalContext = context.getExternalContext();
        String resourcePath = path.trim().replaceAll(" ", "%20");
        String contextPath = externalContext.getRequestContextPath();
        if (resourcePath.startsWith("/")) {
            return contextPath + resourcePath;
        }
        String servletPath = externalContext.getRequestServletPath();
        String base = contextPath + servletPath;
        try {
            URI baseURI = new URI(base);
            URI resourceURI = new URI(resourcePath);
            URI resolvedURI = baseURI.resolve(resourceURI);
            return resolvedURI.toString();
        }
        catch (URISyntaxException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("could not resolve URI's based on\n  context : " + contextPath + "\n  path    : " + servletPath + "\n  resource: " + resourcePath), (Throwable)e);
            }
            return resourcePath;
        }
    }

    protected long getTimeAttribute(UIComponent root, String key) {
        Long timeLong = (Long)root.getAttributes().get(key);
        long time = null == timeLong ? 0L : timeLong;
        return time;
    }

    protected void renderResponse(FacesContext facesContext) throws IOException {
        BridgeFacesContext context = (BridgeFacesContext)facesContext;
        UIViewRoot root = context.getViewRoot();
        String viewId = root.getViewId();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Rendering " + root + " with " + root.getChildCount() + " children"));
        }
        ResponseWriter responseWriter = context.createAndSetResponseWriter();
        boolean reloadView = false;
        URLConnection viewConnection = null;
        URL viewURL = null;
        if (root.getChildCount() == 0 || this.reloadInterval > -1L) {
            if (viewId.startsWith("/faces")) {
                viewId = viewId.substring(6);
            }
            if (viewId.endsWith(".jpg") || viewId.endsWith(".gif") || viewId.endsWith(".png")) {
                context.getExternalContext().dispatch(viewId);
                return;
            }
            try {
                viewURL = context.getExternalContext().getResource(viewId);
                if (null == viewURL) {
                    if (viewId.endsWith(".faces")) {
                        viewId = D2DViewHandler.truncate(".faces", viewId);
                    } else if (viewId.endsWith(".jsf")) {
                        viewId = D2DViewHandler.truncate(".jsf", viewId);
                    } else if (viewId.endsWith(".iface")) {
                        viewId = D2DViewHandler.truncate(".iface", viewId);
                    } else if (viewId.endsWith(".jsp")) {
                        viewId = D2DViewHandler.truncate(".jsp", viewId);
                    }
                    viewId = viewId + ".jspx";
                    viewURL = context.getExternalContext().getResource(viewId);
                }
                if (null == viewURL) {
                    if (viewId.endsWith(".jspx")) {
                        viewId = D2DViewHandler.truncate(".jspx", viewId) + ".jsp";
                    }
                    viewURL = context.getExternalContext().getResource(viewId);
                }
                root.setViewId(viewId);
                long currentTime = System.currentTimeMillis();
                long lastLoaded = this.getTimeAttribute((UIComponent)root, LAST_LOADED_KEY);
                long lastChecked = this.getTimeAttribute((UIComponent)root, LAST_CHECKED_KEY);
                long lastModified = 0L;
                if (currentTime > lastChecked + this.reloadInterval) {
                    viewConnection = viewURL.openConnection();
                    lastModified = viewConnection.getLastModified();
                    root.getAttributes().put(LAST_CHECKED_KEY, new Long(currentTime));
                    if (lastModified > lastLoaded) {
                        reloadView = true;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("View is modified, reloading " + String.valueOf(viewURL)));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new FacesException("Can't find stream for " + viewId, (Throwable)e);
            }
        }
        if (reloadView) {
            Reader viewInput = null;
            try {
                viewInput = new InputStreamReader(viewConnection.getInputStream(), CHAR_ENCODING);
                if (viewId.endsWith(".jsp")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("JspPageToDocument transforming JSP page " + String.valueOf(viewURL)));
                    }
                    viewInput = JspPageToDocument.transform(viewInput);
                } else if (viewId.endsWith(".jspx")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("JspPageToDocument preprocessing JSP doc " + String.valueOf(viewURL)));
                    }
                    viewInput = JspPageToDocument.preprocessJspDocument(viewInput);
                }
            }
            catch (Throwable e) {
                throw new FacesException("Can't read stream for " + viewId, e);
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing " + String.valueOf(viewURL)));
                }
                this.parser.parse(viewInput, context);
                root.getAttributes().put(LAST_LOADED_KEY, new Long(System.currentTimeMillis()));
            }
            catch (Throwable e) {
                throw new FacesException("Can't parse stream for " + viewId + " " + e.getMessage(), e);
            }
            if (ImplementationUtil.isJSF12()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Rendering outside ViewTag for JSF 1.2");
                }
                responseWriter.startDocument();
                this.renderResponse(context, (UIComponent)root);
                responseWriter.endDocument();
            }
        } else {
            responseWriter.startDocument();
            this.renderResponse(context, (UIComponent)root);
            responseWriter.endDocument();
            this.tracePrintComponentTree(context);
        }
    }

    protected void renderResponse(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        boolean isUIViewRoot = component instanceof UIViewRoot;
        if (!isUIViewRoot) {
            component.encodeBegin(context);
        }
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                this.renderResponse(context, (UIComponent)kids.next());
            }
        }
        if (!isUIViewRoot) {
            component.encodeEnd(context);
        }
        if (component instanceof UIData) {
            UIComponent stateHolder = component;
            stateHolder.restoreState(context, stateHolder.saveState(context));
        }
    }

    protected void tracePrintComponentTree(FacesContext context) {
        this.tracePrintComponentTree(context, (UIComponent)context.getViewRoot());
    }

    protected void tracePrintComponentTree(FacesContext context, UIComponent component) {
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer(4096);
            sb.append("tracePrintComponentTree() vvvvvv\n");
            this.tracePrintComponentTree(context, component, 0, sb, null);
            log.trace((Object)sb.toString());
            log.trace((Object)"tracePrintComponentTree() ^^^^^^");
        }
    }

    private void tracePrintComponentTree(FacesContext context, UIComponent component, int levels, StringBuffer sb, String facetName) {
        if (component == null) {
            sb.append("null\n");
            return;
        }
        String PREFIX_WHITESPACE = "  ";
        StringBuffer prefix = new StringBuffer(64);
        for (int i = 0; i < levels; ++i) {
            prefix.append("  ");
        }
        prefix.append("<");
        String compStr = component.toString();
        StringBuffer open = new StringBuffer(512);
        open.append(prefix);
        open.append(compStr);
        Map facetsMap = component.getFacets();
        boolean hasKids = component.getChildCount() > 0;
        boolean hasFacets = facetsMap != null && facetsMap.size() > 0;
        boolean hasUnderlings = hasKids | hasFacets;
        if (!hasUnderlings) {
            open.append("/");
        }
        open.append(">");
        if (facetName != null) {
            open.append(" facetName: ");
            open.append(facetName);
        }
        open.append(" id: ");
        open.append(component.getId());
        if (component.getParent() != null) {
            open.append(" clientId: ");
            open.append(component.getClientId(context));
        }
        if (hasKids) {
            open.append(" kids: ");
            open.append(Integer.toString(component.getChildCount()));
        }
        if (hasFacets) {
            open.append(" facets: ");
            open.append(Integer.toString(facetsMap.size()));
        }
        if (component.isTransient()) {
            open.append(" TRANSIENT ");
        }
        sb.append(open.toString());
        sb.append('\n');
        if (hasUnderlings) {
            if (hasFacets) {
                Object[] facetKeys = facetsMap.keySet().toArray();
                Arrays.sort(facetKeys);
                for (int i = 0; i < facetKeys.length; ++i) {
                    this.tracePrintComponentTree(context, (UIComponent)facetsMap.get(facetKeys[i]), levels + 1, sb, facetKeys[i].toString());
                }
            }
            if (hasKids) {
                Iterator kids = component.getChildren().iterator();
                while (kids.hasNext()) {
                    this.tracePrintComponentTree(context, (UIComponent)kids.next(), levels + 1, sb, null);
                }
            }
            StringBuffer close = new StringBuffer(512);
            close.append(prefix);
            close.append("/");
            close.append(compStr);
            close.append(">");
            sb.append(close);
            sb.append('\n');
        }
    }

    public void writeState(FacesContext context) throws IOException {
        if (this.delegateView(context)) {
            this.delegate.writeState(context);
        }
    }

    public Locale calculateLocale(FacesContext context) {
        Application application = context.getApplication();
        Iterator acceptedLocales = context.getExternalContext().getRequestLocales();
        while (acceptedLocales.hasNext()) {
            Locale supportedLocale;
            Locale acceptedLocale = (Locale)acceptedLocales.next();
            Iterator supportedLocales = application.getSupportedLocales();
            while (supportedLocales.hasNext()) {
                supportedLocale = (Locale)supportedLocales.next();
                if (!acceptedLocale.equals(supportedLocale)) continue;
                return supportedLocale;
            }
            supportedLocales = application.getSupportedLocales();
            while (supportedLocales.hasNext()) {
                supportedLocale = (Locale)supportedLocales.next();
                if (!acceptedLocale.getLanguage().equals(supportedLocale.getLanguage()) || supportedLocale.getCountry().length() != 0) continue;
                return supportedLocale;
            }
        }
        Locale defaultLocale = application.getDefaultLocale();
        return defaultLocale == null ? Locale.getDefault() : defaultLocale;
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.delegate.calculateRenderKitId(context);
    }

    public static boolean isValueReference(String value) {
        return value.indexOf("#{") != -1 && value.indexOf("#{") < value.indexOf(125);
    }

    public static UIComponent findComponent(String clientId, UIComponent base) {
        String delimeter = String.valueOf(':');
        int count = D2DViewHandler.getNumberOfLeadingNamingContainerSeparators(clientId);
        if (count == 1) {
            while (base.getParent() != null) {
                base = base.getParent();
            }
            clientId = clientId.substring(delimeter.length());
        } else if (count == 0) {
            while (base.getParent() != null && !(base instanceof NamingContainer)) {
                base = base.getParent();
            }
        } else if (count > 1) {
            int numNamingContainersUp = count - 1;
            while (!(base.getParent() == null || base instanceof NamingContainer && --numNamingContainersUp == 0)) {
                base = base.getParent();
            }
            clientId = clientId.substring(delimeter.length() * count);
        }
        String id = null;
        UIComponent result = null;
        while (clientId.length() > 0) {
            int separator = clientId.indexOf(58);
            if (base instanceof UIData) {
                if (separator >= 0) {
                    clientId = clientId.substring(separator + 1);
                }
                separator = clientId.indexOf(58);
            }
            if (separator >= 0) {
                id = clientId.substring(0, separator);
                clientId = clientId.substring(separator + 1);
            } else {
                id = clientId;
                clientId = "";
            }
            result = D2DViewHandler.findComponent(base, id);
            if (result == null || clientId.length() == 0) break;
            if (!(result instanceof NamingContainer)) continue;
            result = D2DViewHandler.findComponent(clientId, result);
            break;
        }
        return result;
    }

    private static int getNumberOfLeadingNamingContainerSeparators(String clientId) {
        int count = 0;
        String delimeter = String.valueOf(':');
        for (int index = 0; clientId.indexOf(delimeter, index) == index; index += delimeter.length()) {
            ++count;
        }
        return count;
    }

    private static String truncate(String remove, String input) {
        return input.substring(0, input.length() - remove.length());
    }

    private boolean delegateView(FacesContext context) {
        return !(context instanceof BridgeFacesContext);
    }

    private void initializeParameters(FacesContext context) {
        if (this.parametersInitialized) {
            return;
        }
        ExternalContext ec = context.getExternalContext();
        String reloadIntervalParameter = ec.getInitParameter(RELOAD_INTERVAL);
        String jsfStateManagementParameter = ec.getInitParameter(DO_JSF_STATE_MANAGEMENT);
        this.actionURLSuffix = ec.getInitParameter(ACTION_URL_SUFFIX);
        try {
            this.reloadInterval = Long.parseLong(reloadIntervalParameter) * 1000L;
        }
        catch (NumberFormatException e) {
            this.reloadInterval = this.reloadIntervalDefault * 1000L;
        }
        this.jsfStateManagement = Boolean.valueOf(jsfStateManagementParameter);
        if (!this.jsfStateManagement) {
            log.debug((Object)"JSF State Management not provided");
        }
        this.parametersInitialized = true;
    }

    protected String getRenderedViewId(FacesContext context, String actionId) {
        ExternalContext extCtx = context.getExternalContext();
        String viewId = actionId;
        if (extCtx.getRequestPathInfo() == null) {
            int lastPeriod;
            String viewSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
            if (viewSuffix == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The javax.faces.DEFAULT_SUFFIX context parameter is not set in web.xml. Please define the filename extension used for your source JSF pages. Example:\n<context-param>\n <param-name>javax.faces.DEFAULT_SUFFIX</param-name>\n <param-value>" + this.getDefaultSuffix() + "</param-value>\n" + "</context-param>"));
                }
                viewSuffix = ".jsp";
            }
            viewId = (lastPeriod = actionId.lastIndexOf(46)) < 0 ? actionId + viewSuffix : actionId.substring(0, lastPeriod) + viewSuffix;
        }
        return viewId;
    }

    protected String getDefaultSuffix() {
        return ".jsp";
    }

    private static UIComponent findComponent(UIComponent uiComponent, String componentId) {
        UIComponent component = null;
        UIComponent child = null;
        if (componentId.equals(uiComponent.getId())) {
            return uiComponent;
        }
        Iterator children = uiComponent.getFacetsAndChildren();
        while (children.hasNext() && component == null) {
            child = (UIComponent)children.next();
            if (!(child instanceof NamingContainer)) {
                component = D2DViewHandler.findComponent(child, componentId);
                if (component == null) continue;
                break;
            }
            if (!componentId.endsWith(child.getId())) continue;
            component = child;
            break;
        }
        return component;
    }

    static {
        if (log.isInfoEnabled()) {
            log.info((Object)new ProductInfo().toString());
        }
    }
}

