/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.xml.sax.Attributes;

public class AttributesHandler {
    private static final Logger log = Logger.getLogger((Class)AttributesHandler.class);
    public static final AttributesHandler INSTANCE = new AttributesHandler();

    public void attributes(Object o, QName elementName, TypeBinding type, Attributes attrs, NamespaceContext nsCtx) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            QName qName = new QName(attrs.getURI(i), attrs.getLocalName(i));
            AttributeBinding binding = type.getAttribute(qName);
            if (binding != null) {
                AttributeHandler handler = binding.getHandler();
                Object value = handler.unmarshal(elementName, qName, binding, nsCtx, attrs.getValue(i));
                handler.attribute(elementName, qName, binding, o, value);
                continue;
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(qName.getNamespaceURI())) continue;
            SchemaBinding schemaBinding = type.getSchemaBinding();
            if (schemaBinding != null && schemaBinding.isStrictSchema()) {
                throw new JBossXBRuntimeException("Attribute is not bound: element owner " + elementName + ", attribute " + qName);
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Attribute is not bound: element owner " + elementName + ", attribute " + qName));
        }
    }
}

