/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.model;

import com.sun.xml.bind.api.TypeReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.com.sun.xml.ws.model.CheckedException;
import org.jboss.com.sun.xml.ws.model.Parameter;
import org.jboss.com.sun.xml.ws.model.WrapperParameter;
import org.jboss.com.sun.xml.ws.model.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod {
    private List<CheckedException> exceptions = new ArrayList<CheckedException>();
    private Method method;
    private final List<Parameter> requestParams = new ArrayList<Parameter>();
    private final List<Parameter> responseParams = new ArrayList<Parameter>();
    private final List<Parameter> unmReqParams = Collections.unmodifiableList(this.requestParams);
    private final List<Parameter> unmResParams = Collections.unmodifiableList(this.responseParams);
    private Object binding;
    private int mep;
    private String operationName;

    public JavaMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getMEP() {
        return this.mep;
    }

    public void setMEP(int mep) {
        this.mep = mep;
    }

    public Object getBinding() {
        if (this.binding == null) {
            return new SOAPBinding();
        }
        return this.binding;
    }

    public void setBinding(Object binding) {
        this.binding = binding;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public List<Parameter> getRequestParameters() {
        return this.unmReqParams;
    }

    public List<Parameter> getResponseParameters() {
        return this.unmResParams;
    }

    public void addParameter(Parameter p) {
        if (p.isIN() || p.isINOUT()) {
            if (this.requestParams.contains(p)) {
                // empty if block
            }
            this.requestParams.add(p);
        }
        if (p.isOUT() || p.isINOUT()) {
            if (this.requestParams.contains(p)) {
                // empty if block
            }
            this.responseParams.add(p);
        }
    }

    public void addRequestParameter(Parameter p) {
        if (p.isIN() || p.isINOUT()) {
            this.requestParams.add(p);
        }
    }

    public void addResponseParameter(Parameter p) {
        if (p.isOUT() || p.isINOUT()) {
            this.responseParams.add(p);
        }
    }

    public int getInputParametersCount() {
        int count = 0;
        for (Parameter param : this.requestParams) {
            if (param.isWrapperStyle()) {
                count += ((WrapperParameter)param).getWrapperChildren().size();
                continue;
            }
            ++count;
        }
        for (Parameter param : this.responseParams) {
            if (param.isWrapperStyle()) {
                for (Parameter wc : ((WrapperParameter)param).getWrapperChildren()) {
                    if (wc.isResponse() || !wc.isOUT()) continue;
                    ++count;
                }
                continue;
            }
            if (param.isResponse() || !param.isOUT()) continue;
            ++count;
        }
        return count;
    }

    public void addException(CheckedException ce) {
        if (!this.exceptions.contains(ce)) {
            this.exceptions.add(ce);
        }
    }

    public CheckedException getCheckedException(Class exceptionClass) {
        for (CheckedException ce : this.exceptions) {
            if (!ce.getExcpetionClass().equals(exceptionClass)) continue;
            return ce;
        }
        return null;
    }

    public List<CheckedException> getCheckedExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public CheckedException getCheckedException(TypeReference detailType) {
        for (CheckedException ce : this.exceptions) {
            TypeReference actual = ce.getDetailType();
            if (!actual.tagName.equals(detailType.tagName) || !actual.type.getClass().getName().equals(detailType.type.getClass().getName())) continue;
            return ce;
        }
        return null;
    }

    public boolean isAsync() {
        return this.mep == 4 || this.mep == 3;
    }
}

