/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.instr;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.CoverageOptionsFactory;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.instr.InstrProcessor;
import com.vladium.emma.instr.InstrVisitor;
import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.compiler.ClassWriter;
import com.vladium.jcd.parser.ClassDefParser;
import com.vladium.logging.Logger;
import com.vladium.util.ByteArrayOStream;
import com.vladium.util.Descriptors;
import com.vladium.util.Files;
import com.vladium.util.IPathEnumerator;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import com.vladium.util.exception.Exceptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

final class InstrProcessorST
extends InstrProcessor
implements IAppErrorCodes {
    private final Job[] m_jobs = new Job[128];
    private final InstrVisitor.InstrResult m_instrResult = new InstrVisitor.InstrResult();
    private InstrVisitor m_visitor;
    private IMetaData m_mdata;
    private byte[] m_readbuf;
    private int m_readpos;
    private ByteArrayOStream m_baos;
    private int m_jobPos;
    private long m_currentArchiveTS;
    private File m_origArchiveFile;
    private File m_tempArchiveFile;
    private JarOutputStream m_archiveOut;
    private long m_timeStamp;
    private static final int BUF_SIZE = 32768;
    private static final int JOB_QUEUE_SIZE = 128;
    private static final boolean CLEANUP_TEMP_ARCHIVE_ON_ERRORS = true;
    private static final boolean DO_RAF_EXTENSION = true;
    private static final boolean DO_DEPENDS_CHECKING = true;
    private static final Class[] EXPECTED_FAILURES = new Class[]{class$com$vladium$emma$EMMARuntimeException == null ? (class$com$vladium$emma$EMMARuntimeException = InstrProcessorST.class$("com.vladium.emma.EMMARuntimeException")) : class$com$vladium$emma$EMMARuntimeException, class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = InstrProcessorST.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = InstrProcessorST.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException};
    static /* synthetic */ Class class$com$vladium$emma$EMMARuntimeException;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;
    static /* synthetic */ Class class$java$lang$IllegalStateException;

    public final void handleArchiveStart(File parentDir, File archive, Manifest manifest) {
        Logger log = this.m_log;
        if (log.atTRACE2()) {
            log.trace2("handleArchiveStart", "[" + parentDir + "] [" + archive + "]");
        }
        File fullArchiveFile = Files.newFile(parentDir, archive);
        this.m_currentArchiveTS = fullArchiveFile.lastModified();
        if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY || this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
            Manifest outManifest = manifest != null ? new Manifest(manifest) : new Manifest();
            Attributes mainAttrs = outManifest.getMainAttributes();
            if (manifest == null) {
                mainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            }
            mainAttrs.put(new Attributes.Name("Created-By"), "EMMA v2.0.5312");
            mainAttrs.put(Attributes.Name.IMPLEMENTATION_TITLE, "instrumented version of [" + archive.getAbsolutePath() + "]");
            mainAttrs.put(Attributes.Name.SPECIFICATION_TITLE, "instrumented on " + new Date(this.m_timeStamp) + " [" + Property.getSystemFingerprint() + "]");
            if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY) {
                try {
                    FileOutputStream out = new FileOutputStream(this.getFullOutFile(parentDir, archive, false));
                    this.m_archiveOut = outManifest != null ? new JarOutputStream((OutputStream)out, outManifest) : new JarOutputStream(out);
                }
                catch (IOException ioe) {
                    throw new EMMARuntimeException(ioe);
                }
            }
            if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
                this.m_origArchiveFile = Files.newFile(parentDir, archive);
                String archiveName = Files.getFileName(archive) + "emma";
                String archiveExt = ".et";
                try {
                    this.m_tempArchiveFile = Files.createTempFile(parentDir, archiveName, ".et");
                    if (log.atTRACE2()) {
                        log.trace2("handleArchiveStart", "created temp archive [" + this.m_tempArchiveFile.getAbsolutePath() + "]");
                    }
                    FileOutputStream out = new FileOutputStream(this.m_tempArchiveFile);
                    this.m_archiveOut = outManifest != null ? new JarOutputStream((OutputStream)out, outManifest) : new JarOutputStream(out);
                }
                catch (IOException ioe) {
                    throw new EMMARuntimeException(ioe);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void handleArchiveEntry(JarInputStream in, ZipEntry entry) {
        boolean copyEntry;
        block29: {
            boolean notcopymode;
            String name;
            block30: {
                block31: {
                    InputStream clsin;
                    block28: {
                        block27: {
                            block26: {
                                Logger log = this.m_log;
                                if (log.atTRACE2()) {
                                    log.trace2("handleArchiveEntry", "[" + entry.getName() + "]");
                                }
                                name = entry.getName();
                                String lcName = name.toLowerCase();
                                notcopymode = this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY || this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE;
                                copyEntry = false;
                                if (!lcName.endsWith(".class")) break block30;
                                String className = name.substring(0, name.length() - 6).replace('/', '.');
                                if (this.m_coverageFilter != null && !this.m_coverageFilter.included(className)) break block31;
                                clsin = null;
                                try {
                                    try {
                                        File outFile = null;
                                        File fullOutFile = null;
                                        if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_COPY) {
                                            outFile = new File(className.replace('.', File.separatorChar).concat(".class"));
                                            fullOutFile = this.getFullOutFile(null, outFile, true);
                                            if (this.m_mdata.hasDescriptor(Descriptors.javaNameToVMName(className))) {
                                                Object var17_15 = null;
                                                if (clsin == null) return;
                                                break block26;
                                            }
                                            long outTimeStamp = fullOutFile.lastModified();
                                            if (outTimeStamp > 0L) {
                                                long inTimeStamp = entry.getTime();
                                                if (inTimeStamp < 0L) {
                                                    inTimeStamp = this.m_currentArchiveTS;
                                                }
                                                if (inTimeStamp <= outTimeStamp) {
                                                    if (log.atVERBOSE()) {
                                                        log.verbose("destination file [" + outFile + "] skipped: more recent than the source");
                                                    }
                                                    break block27;
                                                }
                                            }
                                        }
                                        this.readZipEntry(in, entry);
                                        ClassDef clsDef = ClassDefParser.parseClass(this.m_readbuf, this.m_readpos);
                                        this.m_visitor.process(clsDef, this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE, true, true, this.m_instrResult);
                                        if (this.m_instrResult.m_instrumented) {
                                            ++this.m_classInstrs;
                                            this.m_mdata.add(this.m_instrResult.m_descriptor, false);
                                            this.m_baos.reset();
                                            ClassWriter.writeClassTable(clsDef, this.m_baos);
                                            if (notcopymode) {
                                                entry.setTime(this.m_timeStamp);
                                                this.addJob(new EntryWriteJob(this.m_archiveOut, this.m_baos.copyByteArray(), entry, false));
                                                break block28;
                                            } else {
                                                this.addJob(new FileWriteJob(fullOutFile, this.m_baos.copyByteArray(), true));
                                            }
                                            break block28;
                                        }
                                        if (notcopymode) {
                                            byte[] data = new byte[this.m_readpos];
                                            System.arraycopy(this.m_readbuf, 0, data, 0, data.length);
                                            ++this.m_classCopies;
                                            entry.setTime(this.m_timeStamp);
                                            this.addJob(new EntryWriteJob(this.m_archiveOut, data, entry, true));
                                        }
                                        break block28;
                                    }
                                    catch (FileNotFoundException fnfe) {
                                        Object var17_18 = null;
                                        if (clsin == null) break block29;
                                        try {
                                            clsin.close();
                                            break block29;
                                        }
                                        catch (Exception e) {
                                            throw new EMMARuntimeException(e);
                                        }
                                    }
                                    catch (IOException ioe) {
                                        throw new EMMARuntimeException(ioe);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var17_19 = null;
                                    if (clsin == null) throw throwable;
                                    try {}
                                    catch (Exception e) {
                                        throw new EMMARuntimeException(e);
                                    }
                                    clsin.close();
                                    throw throwable;
                                }
                            }
                            try {}
                            catch (Exception e) {
                                throw new EMMARuntimeException(e);
                            }
                            clsin.close();
                            return;
                        }
                        Object var17_16 = null;
                        if (clsin == null) return;
                        try {}
                        catch (Exception e) {
                            throw new EMMARuntimeException(e);
                        }
                        clsin.close();
                        return;
                    }
                    Object var17_17 = null;
                    if (clsin == null) break block29;
                    try {}
                    catch (Exception e) {
                        throw new EMMARuntimeException(e);
                    }
                    clsin.close();
                    break block29;
                }
                copyEntry = notcopymode;
                break block29;
            }
            copyEntry = notcopymode;
            if (copyEntry && name.equalsIgnoreCase("META-INF/")) {
                copyEntry = false;
            }
            if (copyEntry && name.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                copyEntry = false;
            }
        }
        if (!copyEntry) return;
        try {
            this.readZipEntry(in, entry);
            byte[] data = new byte[this.m_readpos];
            System.arraycopy(this.m_readbuf, 0, data, 0, data.length);
            ++this.m_classCopies;
            entry.setTime(this.m_timeStamp);
            this.addJob(new EntryWriteJob(this.m_archiveOut, data, entry, true));
            return;
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException(ioe);
        }
    }

    public final void handleArchiveEnd(File parentDir, File archive) {
        Logger log = this.m_log;
        if (log.atTRACE2()) {
            log.trace2("handleArchiveEnd", "[" + parentDir + "] [" + archive + "]");
        }
        this.m_currentArchiveTS = Long.MAX_VALUE;
        if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY || this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
            try {
                this.drainJobQueue();
                this.m_archiveOut.flush();
                this.m_archiveOut.close();
                this.m_archiveOut = null;
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException(ioe);
            }
            if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
                if (!Files.renameFile(this.m_tempArchiveFile, this.m_origArchiveFile, true)) {
                    throw new EMMARuntimeException("could not rename temporary file [" + this.m_tempArchiveFile + "] to [" + this.m_origArchiveFile + "]: make sure the original file is not locked and can be deleted");
                }
                if (log.atTRACE2()) {
                    log.trace2("handleArchiveEnd", "renamed temp archive [" + this.m_tempArchiveFile.getAbsolutePath() + "] to [" + this.m_origArchiveFile + "]");
                }
                this.m_tempArchiveFile = null;
                this.m_origArchiveFile = null;
            }
        }
    }

    public final void handleDirStart(File pathDir, File dir) {
        Logger log = this.m_log;
        if (log.atTRACE2()) {
            log.trace2("handleDirStart", "[" + pathDir + "] [" + dir + "]");
        }
        if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY) {
            File saveDir = new File(this.getFullOutDir(pathDir, true), dir.getPath());
            this.createDir(saveDir, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void handleFile(File pathDir, File file) {
        boolean copyFile;
        boolean mkdir;
        block23: {
            boolean fullcopymode;
            block24: {
                block25: {
                    InputStream clsin;
                    block22: {
                        block21: {
                            block20: {
                                Logger log = this.m_log;
                                if (log.atTRACE2()) {
                                    log.trace2("handleFile", "[" + pathDir + "] [" + file + "]");
                                }
                                String name = file.getPath();
                                String lcName = name.toLowerCase();
                                fullcopymode = this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY;
                                mkdir = this.m_outMode == InstrProcessor.OutMode.OUT_MODE_COPY;
                                copyFile = false;
                                if (!lcName.endsWith(".class")) break block24;
                                String className = name.substring(0, name.length() - 6).replace(File.separatorChar, '.');
                                if (this.m_coverageFilter != null && !this.m_coverageFilter.included(className)) break block25;
                                clsin = null;
                                try {
                                    try {
                                        File inFile = Files.newFile(pathDir, file.getPath());
                                        File fullOutFile = this.getFullOutFile(pathDir, file, true);
                                        if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_COPY) {
                                            long inTimeStamp;
                                            if (this.m_mdata.hasDescriptor(Descriptors.javaNameToVMName(className))) {
                                                Object var18_16 = null;
                                                if (clsin == null) return;
                                                break block20;
                                            }
                                            long outTimeStamp = fullOutFile.lastModified();
                                            if (outTimeStamp > 0L && (inTimeStamp = inFile.lastModified()) <= outTimeStamp) {
                                                if (log.atVERBOSE()) {
                                                    log.verbose("destination file [" + fullOutFile + "] skipped: more recent that the source file");
                                                }
                                                break block21;
                                            }
                                        }
                                        this.readFile(inFile);
                                        ClassDef clsDef = ClassDefParser.parseClass(this.m_readbuf, this.m_readpos);
                                        this.m_visitor.process(clsDef, this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE, true, true, this.m_instrResult);
                                        if (this.m_instrResult.m_instrumented) {
                                            ++this.m_classInstrs;
                                            this.m_mdata.add(this.m_instrResult.m_descriptor, false);
                                            this.m_baos.reset();
                                            ClassWriter.writeClassTable(clsDef, this.m_baos);
                                            clsDef = null;
                                            byte[] outdata = this.m_baos.copyByteArray();
                                            this.addJob(new FileWriteJob(fullOutFile, outdata, mkdir));
                                            break block22;
                                        }
                                        if (fullcopymode) {
                                            clsDef = null;
                                            byte[] outdata = new byte[this.m_readpos];
                                            System.arraycopy(this.m_readbuf, 0, outdata, 0, this.m_readpos);
                                            ++this.m_classCopies;
                                            this.addJob(new FileWriteJob(fullOutFile, outdata, mkdir));
                                        }
                                        break block22;
                                    }
                                    catch (FileNotFoundException fnfe) {
                                        Object var18_19 = null;
                                        if (clsin == null) break block23;
                                        try {
                                            clsin.close();
                                            break block23;
                                        }
                                        catch (Exception e) {
                                            throw new EMMARuntimeException(e);
                                        }
                                    }
                                    catch (IOException ioe) {
                                        throw new EMMARuntimeException(ioe);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var18_20 = null;
                                    if (clsin == null) throw throwable;
                                    try {}
                                    catch (Exception e) {
                                        throw new EMMARuntimeException(e);
                                    }
                                    clsin.close();
                                    throw throwable;
                                }
                            }
                            try {}
                            catch (Exception e) {
                                throw new EMMARuntimeException(e);
                            }
                            clsin.close();
                            return;
                        }
                        Object var18_17 = null;
                        if (clsin == null) return;
                        try {}
                        catch (Exception e) {
                            throw new EMMARuntimeException(e);
                        }
                        clsin.close();
                        return;
                    }
                    Object var18_18 = null;
                    if (clsin == null) break block23;
                    try {}
                    catch (Exception e) {
                        throw new EMMARuntimeException(e);
                    }
                    clsin.close();
                    break block23;
                }
                copyFile = fullcopymode;
                break block23;
            }
            copyFile = fullcopymode;
        }
        if (!copyFile) return;
        try {
            File inFile = Files.newFile(pathDir, file.getPath());
            this.readFile(inFile);
            byte[] data = new byte[this.m_readpos];
            System.arraycopy(this.m_readbuf, 0, data, 0, data.length);
            ++this.m_classCopies;
            File outFile = this.getFullOutFile(pathDir, file, true);
            this.addJob(new FileWriteJob(outFile, data, mkdir));
            return;
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException(ioe);
        }
    }

    public final void handleDirEnd(File pathDir, File dir) {
        Logger log = this.m_log;
        if (log.atTRACE2()) {
            log.trace2("handleDirEnd", "[" + pathDir + "] [" + dir + "]");
        }
        if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
            try {
                this.drainJobQueue();
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException(ioe);
            }
        }
    }

    protected void reset() {
        this.m_visitor = null;
        this.m_mdata = null;
        this.m_readbuf = null;
        this.m_baos = null;
        for (int j = 0; j < this.m_jobs.length; ++j) {
            this.m_jobs[j] = null;
        }
        if (this.m_archiveOut != null) {
            try {
                this.m_archiveOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_tempArchiveFile != null) {
            this.m_tempArchiveFile.delete();
        }
        this.m_archiveOut = null;
        this.m_origArchiveFile = null;
        this.m_tempArchiveFile = null;
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _run(IProperties toolProperties) {
        Logger log = this.m_log;
        boolean verbose = log.atVERBOSE();
        if (verbose) {
            log.verbose("[EMMA v2.0, build 5312 (2005/06/12 19:32:43)]");
            log.verbose("instrumentation path:");
            log.verbose("{");
            for (int p = 0; p < this.m_instrPath.length; ++p) {
                File f = this.m_instrPath[p];
                String nonexistent = f.exists() ? "" : "{nonexistent} ";
                log.verbose("  " + nonexistent + f.getAbsolutePath());
            }
            log.verbose("}");
            log.verbose("instrumentation output mode: " + this.m_outMode);
        } else {
            log.info("processing instrumentation path ...");
        }
        RuntimeException failure = null;
        try {
            long end;
            long start;
            this.m_timeStamp = start = System.currentTimeMillis();
            IPathEnumerator enumerator = IPathEnumerator.Factory.create(this.m_instrPath, this.m_canonical, this);
            if (this.m_outMode != InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
                this.createDir(this.m_outDir, true);
            }
            if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY) {
                File classesDir = Files.newFile(this.m_outDir, "classes");
                this.createDir(classesDir, false);
                File libDir = Files.newFile(this.m_outDir, "lib");
                this.createDir(libDir, false);
            }
            File mdataOutFile = this.m_mdataOutFile;
            Boolean mdataOutMerge = this.m_mdataOutMerge;
            if (mdataOutFile == null) {
                mdataOutFile = new File(toolProperties.getProperty("metadata.out.file", "coverage.em"));
            }
            if (mdataOutMerge == null) {
                String _dataOutMerge = toolProperties.getProperty("metadata.out.merge", EMMAProperties.DEFAULT_META_DATA_OUT_MERGE.toString());
                Boolean bl = mdataOutMerge = Property.toBoolean(_dataOutMerge) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (verbose) {
                log.verbose("metadata output file: " + mdataOutFile.getAbsolutePath());
                log.verbose("metadata output merge mode: " + mdataOutMerge);
            }
            this.m_readbuf = new byte[32768];
            this.m_readpos = 0;
            this.m_baos = new ByteArrayOStream(32768);
            this.m_jobPos = 0;
            this.m_currentArchiveTS = Long.MAX_VALUE;
            CoverageOptions options = CoverageOptionsFactory.create(toolProperties);
            this.m_visitor = new InstrVisitor(options);
            this.m_mdata = DataFactory.newMetaData(options);
            try {
                enumerator.enumerate();
                this.drainJobQueue();
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("INSTR_IO_FAILURE", ioe);
            }
            if (log.atINFO()) {
                end = System.currentTimeMillis();
                log.info("instrumentation path processed in " + (end - start) + " ms");
                log.info("[" + this.m_classInstrs + " class(es) instrumented, " + this.m_classCopies + " resource(s) copied]");
            }
            try {
                if (verbose && this.m_mdata != null) {
                    log.verbose("metadata contains " + this.m_mdata.size() + " entries");
                }
                if (this.m_mdata.isEmpty()) {
                    log.info("no output created: metadata is empty");
                } else {
                    start = System.currentTimeMillis();
                    DataFactory.persist(this.m_mdata, mdataOutFile, (boolean)mdataOutMerge);
                    end = System.currentTimeMillis();
                    if (log.atINFO()) {
                        log.info("metadata " + (mdataOutMerge != false ? "merged into" : "written to") + " [" + mdataOutFile.getAbsolutePath() + "] {in " + (end - start) + " ms}");
                    }
                }
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("OUT_IO_FAILURE", new Object[]{mdataOutFile.getAbsolutePath()}, ioe);
            }
        }
        catch (SecurityException se) {
            failure = new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, se);
        }
        catch (RuntimeException re) {
            failure = re;
        }
        finally {
            this.reset();
        }
        if (failure != null) {
            if (Exceptions.unexpectedFailure(failure, EXPECTED_FAILURES)) {
                throw new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{failure.toString(), "http://sourceforge.net/projects/emma"}, failure);
            }
            throw failure;
        }
    }

    InstrProcessorST() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeFile(byte[] data, File outFile, boolean mkdirs) throws IOException {
        RandomAccessFile raf = null;
        try {
            File parent;
            if (mkdirs && (parent = outFile.getParentFile()) != null) {
                parent.mkdirs();
            }
            raf = new RandomAccessFile(outFile, "rw");
            raf.setLength(data.length);
            raf.write(data);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeZipEntry(byte[] data, ZipOutputStream out, ZipEntry entry, boolean isCopy) throws IOException {
        if (isCopy) {
            out.putNextEntry(entry);
            try {
                out.write(data);
            }
            finally {
                out.closeEntry();
            }
        }
        ZipEntry entryCopy = new ZipEntry(entry.getName());
        entryCopy.setTime(entry.getTime());
        entryCopy.setMethod(0);
        entryCopy.setSize(data.length);
        entryCopy.setCompressedSize(data.length);
        CRC32 crc = new CRC32();
        crc.update(data);
        entryCopy.setCrc(crc.getValue());
        out.putNextEntry(entryCopy);
        try {
            out.write(data);
        }
        finally {
            out.closeEntry();
        }
    }

    private void addJob(Job job) throws FileNotFoundException, IOException {
        if (this.m_jobPos == 128) {
            this.drainJobQueue();
        }
        this.m_jobs[this.m_jobPos++] = job;
    }

    private void drainJobQueue() throws IOException {
        for (int j = 0; j < this.m_jobPos; ++j) {
            Job job = this.m_jobs[j];
            if (job == null) continue;
            this.m_jobs[j] = null;
            job.run();
        }
        this.m_jobPos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readFile(File file) throws IOException {
        int length = (int)file.length();
        this.ensureReadCapacity(length);
        FileInputStream in = null;
        try {
            int totalread;
            int read;
            in = new FileInputStream(file);
            for (totalread = 0; totalread < length && (read = ((InputStream)in).read(this.m_readbuf, totalread, length - totalread)) >= 0; totalread += read) {
            }
            this.m_readpos = totalread;
            Object var7_6 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)in).close();
            return;
        }
        catch (Exception ignore) {}
    }

    private void readZipEntry(ZipInputStream in, ZipEntry entry) throws IOException {
        int length = (int)entry.getSize();
        if (length >= 0) {
            int totalread;
            int read;
            this.ensureReadCapacity(length);
            for (totalread = 0; totalread < length && (read = in.read(this.m_readbuf, totalread, length - totalread)) >= 0; totalread += read) {
            }
            this.m_readpos = totalread;
        } else {
            int read;
            this.ensureReadCapacity(32768);
            this.m_baos.reset();
            while ((read = in.read(this.m_readbuf)) >= 0) {
                this.m_baos.write(this.m_readbuf, 0, read);
            }
            this.m_readbuf = this.m_baos.copyByteArray();
            this.m_readpos = this.m_readbuf.length;
        }
    }

    private void ensureReadCapacity(int capacity) {
        if (this.m_readbuf.length < capacity) {
            int readbuflen = this.m_readbuf.length;
            this.m_readbuf = null;
            this.m_readbuf = new byte[Math.max(readbuflen << 1, capacity)];
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class EntryWriteJob
    extends Job {
        final ZipOutputStream m_out;
        byte[] m_data;
        final ZipEntry m_entry;
        final boolean m_isCopy;

        protected void run() throws IOException {
            InstrProcessorST.writeZipEntry(this.m_data, this.m_out, this.m_entry, this.m_isCopy);
            this.m_data = null;
        }

        EntryWriteJob(ZipOutputStream out, byte[] data, ZipEntry entry, boolean isCopy) {
            this.m_out = out;
            this.m_data = data;
            this.m_entry = entry;
            this.m_isCopy = isCopy;
        }
    }

    private static final class FileWriteJob
    extends Job {
        final File m_outFile;
        final boolean m_mkdirs;
        byte[] m_data;

        protected void run() throws IOException {
            InstrProcessorST.writeFile(this.m_data, this.m_outFile, this.m_mkdirs);
            this.m_data = null;
        }

        FileWriteJob(File outFile, byte[] data, boolean mkdirs) {
            this.m_outFile = outFile;
            this.m_data = data;
            this.m_mkdirs = mkdirs;
        }
    }

    private static abstract class Job {
        private Job() {
        }

        protected abstract void run() throws IOException;
    }
}

