/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StyleElement;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class Text
extends StyleElement {
    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String fnAtt = this.getAttribute("href");
        if (fnAtt == null) {
            this.reportAbsence("href");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    public void process(Context context) throws TransformerException {
        Outputter out = context.getOutputter();
        String hrefAtt = this.getAttribute("href");
        Expression hrefExpr = this.makeAttributeValueTemplate(hrefAtt);
        String href = hrefExpr.evaluateAsString(context);
        URL fileURL = null;
        try {
            try {
                fileURL = new URL(href);
            }
            catch (MalformedURLException e1) {
                try {
                    fileURL = new URL("file:" + href);
                }
                catch (MalformedURLException e2) {
                    System.out.println("Cannot open " + href);
                    return;
                }
            }
            InputStreamReader isr = new InputStreamReader(fileURL.openStream());
            BufferedReader is = new BufferedReader(isr);
            char[] chars = new char[4096];
            int len = 0;
            while ((len = is.read(chars)) > 0) {
                out.writeContent(chars, 0, len);
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println("Cannot read " + href);
        }
    }
}

