/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.local;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.resource.adapter.jdbc.local.LocalManagedConnection;
import org.jboss.util.NestedRuntimeException;

public class LocalManagedConnectionFactory
extends BaseWrapperManagedConnectionFactory {
    static final long serialVersionUID = 4698955390505160469L;
    private String driverClass;
    private transient Driver driver;
    private String connectionURL;
    protected String connectionProperties;

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public synchronized void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        this.driver = null;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
        this.connectionProps.clear();
        if (connectionProperties != null) {
            connectionProperties = connectionProperties.replaceAll("\\\\", "\\\\\\\\");
            ByteArrayInputStream is = new ByteArrayInputStream(connectionProperties.getBytes());
            try {
                this.connectionProps.load(is);
            }
            catch (IOException ioe) {
                throw new NestedRuntimeException("Could not load connection properties", (Throwable)ioe);
            }
        }
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties props = this.getConnectionProperties(subject, cri);
        Properties copy = (Properties)props.clone();
        if (this.log.isDebugEnabled()) {
            Properties logCopy = copy;
            if (copy.getProperty("password") != null) {
                logCopy = (Properties)props.clone();
                logCopy.setProperty("password", "--hidden--");
            }
            this.log.debug((Object)("Using properties: " + logCopy));
        }
        try {
            String url = this.getConnectionURL();
            Driver d = this.getDriver(url);
            Connection con = d.connect(url, copy);
            if (con == null) {
                throw new JBossResourceException("Wrong driver class for this connection URL");
            }
            return new LocalManagedConnection(this, con, props, this.transactionIsolation, this.preparedStatementCacheSize);
        }
        catch (Exception e) {
            throw new JBossResourceException("Could not create connection", (Throwable)e);
        }
    }

    public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.getConnectionProperties(subject, cri);
        Iterator i = mcs.iterator();
        while (i.hasNext()) {
            LocalManagedConnection mc;
            Object o = i.next();
            if (!(o instanceof LocalManagedConnection) || !(mc = (LocalManagedConnection)((Object)o)).getProps().equals(newProps) || !mc.checkValid()) continue;
            return mc;
        }
        return null;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.connectionURL == null ? 0 : this.connectionURL.hashCode());
        result = result * 37 + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = result * 37 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 37 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 37 + this.transactionIsolation;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        LocalManagedConnectionFactory otherMcf = (LocalManagedConnectionFactory)((Object)other);
        return this.connectionURL.equals(otherMcf.connectionURL) && this.driverClass.equals(otherMcf.driverClass) && (this.userName == null ? otherMcf.userName == null : this.userName.equals(otherMcf.userName)) && (this.password == null ? otherMcf.password == null : this.password.equals(otherMcf.password)) && this.transactionIsolation == otherMcf.transactionIsolation;
    }

    protected synchronized Driver getDriver(String url) throws ResourceException {
        if (this.driver != null) {
            return this.driver;
        }
        this.log.debug((Object)("Checking driver for URL: " + url));
        if (this.driverClass == null) {
            throw new JBossResourceException("No Driver class specified!");
        }
        if (this.isDriverLoadedForURL(url)) {
            return this.driver;
        }
        try {
            Class<?> clazz = Class.forName(this.driverClass, true, Thread.currentThread().getContextClassLoader());
            if (this.isDriverLoadedForURL(url)) {
                return this.driver;
            }
            this.driver = (Driver)clazz.newInstance();
            DriverManager.registerDriver(this.driver);
            if (this.isDriverLoadedForURL(url)) {
                return this.driver;
            }
        }
        catch (Exception e) {
            throw new JBossResourceException("Failed to register driver for: " + this.driverClass, (Throwable)e);
        }
        throw new JBossResourceException("Apparently wrong driver class specified for URL: class: " + this.driverClass + ", url: " + url);
    }

    private boolean isDriverLoadedForURL(String url) {
        try {
            this.driver = DriverManager.getDriver(url);
            this.log.debug((Object)("Driver already registered for url: " + url));
            return true;
        }
        catch (Exception e) {
            this.log.debug((Object)("Driver not yet registered for url: " + url));
            return false;
        }
    }

    protected String internalGetConnectionURL() {
        return this.connectionURL;
    }
}

