/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.NonstrictReadWriteCache;
import org.hibernate.cache.ReadOnlyCache;
import org.hibernate.cache.ReadWriteCache;
import org.hibernate.cache.TransactionalCache;
import org.hibernate.cfg.Settings;

public final class CacheFactory {
    private static final Log log = LogFactory.getLog(CacheFactory.class);
    public static final String READ_ONLY = "read-only";
    public static final String READ_WRITE = "read-write";
    public static final String NONSTRICT_READ_WRITE = "nonstrict-read-write";
    public static final String TRANSACTIONAL = "transactional";

    private CacheFactory() {
    }

    public static CacheConcurrencyStrategy createCache(String concurrencyStrategy, String regionName, boolean mutable, Settings settings, Properties properties) throws HibernateException {
        Cache impl;
        CacheConcurrencyStrategy ccs;
        if (concurrencyStrategy == null || !settings.isSecondLevelCacheEnabled()) {
            return null;
        }
        String prefix = settings.getCacheRegionPrefix();
        if (prefix != null) {
            regionName = prefix + '.' + regionName;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("instantiating cache region: " + regionName + " usage strategy: " + concurrencyStrategy));
        }
        if (concurrencyStrategy.equals(READ_ONLY)) {
            if (mutable) {
                log.warn((Object)("read-only cache configured for mutable class: " + regionName));
            }
            ccs = new ReadOnlyCache();
        } else if (concurrencyStrategy.equals(READ_WRITE)) {
            ccs = new ReadWriteCache();
        } else if (concurrencyStrategy.equals(NONSTRICT_READ_WRITE)) {
            ccs = new NonstrictReadWriteCache();
        } else if (concurrencyStrategy.equals(TRANSACTIONAL)) {
            ccs = new TransactionalCache();
        } else {
            throw new MappingException("cache usage attribute should be read-write, read-only, nonstrict-read-write or transactional");
        }
        try {
            impl = settings.getCacheProvider().buildCache(regionName, properties);
        }
        catch (CacheException e) {
            throw new HibernateException("Could not instantiate cache implementation", e);
        }
        ccs.setCache(impl);
        return ccs;
    }
}

