/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.logging.Logger;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractDependencyItem
extends JBossObject
implements DependencyItem {
    private static final Logger log = Logger.getLogger((Class)AbstractDependencyItem.class);
    private Object iDependOn;
    private Object name;
    private ControllerState whenRequired = ControllerState.DESCRIBED;
    private ControllerState dependentState;
    private boolean resolved = false;

    public AbstractDependencyItem() {
    }

    public AbstractDependencyItem(Object object, Object object2, ControllerState controllerState, ControllerState controllerState2) {
        this.name = object;
        this.iDependOn = object2;
        this.whenRequired = controllerState;
        this.dependentState = controllerState2;
    }

    public Object getName() {
        return this.name;
    }

    public Object getIDependOn() {
        return this.iDependOn;
    }

    public ControllerState getWhenRequired() {
        return this.whenRequired;
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean resolve(Controller controller) {
        boolean bl = this.resolved;
        ControllerContext controllerContext = null;
        if (this.dependentState == null) {
            controllerContext = controller.getInstalledContext(this.iDependOn);
        } else {
            controllerContext = controller.getContext(this.iDependOn, this.dependentState);
            if (controllerContext == null && this.dependentState == ControllerState.INSTALLED) {
                controllerContext = controller.getInstalledContext(this.iDependOn);
            }
        }
        if (controllerContext == null) {
            this.resolved = false;
            ControllerContext controllerContext2 = controller.getContext(this.iDependOn, null);
            if (controllerContext2 != null && ControllerMode.ON_DEMAND.equals((Object)controllerContext2.getMode())) {
                try {
                    controller.enableOnDemand(controllerContext2);
                }
                catch (Throwable throwable) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Unexpected error", throwable);
                    }
                }
            }
        } else {
            this.addDependsOnMe(controller, controllerContext);
            this.resolved = true;
        }
        if (bl != this.resolved) {
            this.flushJBossObjectCache();
            if (log.isTraceEnabled()) {
                if (this.resolved) {
                    log.trace((Object)("Resolved " + this));
                } else {
                    log.trace((Object)("Unresolved " + this));
                }
            }
        }
        return this.resolved;
    }

    public void unresolved(Controller controller) {
        if (this.resolved) {
            this.resolved = false;
            this.flushJBossObjectCache();
            log.trace((Object)("Forced unresolved " + this));
        }
    }

    public void toString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append("name=").append(this.name);
        jBossStringBuilder.append(" dependsOn=").append(this.iDependOn);
        if (this.whenRequired != null) {
            jBossStringBuilder.append(" whenRequired=").append(this.whenRequired.getStateString());
        }
        if (this.dependentState != null) {
            jBossStringBuilder.append(" dependentState=").append(this.dependentState.getStateString());
        }
        jBossStringBuilder.append(" resolved=").append(this.resolved);
    }

    public void toShortString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append(this.name).append(" dependsOn ").append(this.iDependOn);
    }

    protected void addDependsOnMe(Controller controller, ControllerContext controllerContext) {
        DependencyInfo dependencyInfo = controllerContext.getDependencyInfo();
        if (dependencyInfo != null) {
            dependencyInfo.addDependsOnMe(this);
        }
    }

    protected void setIDependOn(Object object) {
        this.iDependOn = object;
        this.flushJBossObjectCache();
    }

    protected void setResolved(boolean bl) {
        this.resolved = bl;
        this.flushJBossObjectCache();
    }
}

