/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.font.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.UnresolvedFontFamily;
import org.apache.batik.gvt.renderer.BasicTextPainter;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.BidiAttributedCharacterIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.GlyphLayout;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class StrokingTextPainter
extends BasicTextPainter {
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    public static final AttributedCharacterIterator.Attribute GVT_FONT_FAMILIES = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES;
    public static final AttributedCharacterIterator.Attribute BIDI_LEVEL = GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL;
    public static final AttributedCharacterIterator.Attribute XPOS = GVTAttributedCharacterIterator.TextAttribute.X;
    public static final AttributedCharacterIterator.Attribute YPOS = GVTAttributedCharacterIterator.TextAttribute.Y;
    public static final AttributedCharacterIterator.Attribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    private static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    private static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    private static final Integer WRITING_MODE_RTL = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL;
    public static final AttributedCharacterIterator.Attribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    public static final Integer ADJUST_SPACING = GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING;
    public static final Integer ADJUST_ALL = GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL;
    public static final GVTAttributedCharacterIterator.TextAttribute ALT_GLYPH_HANDLER = GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER;
    static Set extendedAtts = new HashSet();
    protected static TextPainter singleton;

    public static TextPainter getInstance() {
        return singleton;
    }

    public void paint(TextNode node, Graphics2D g2d) {
        AttributedCharacterIterator aci = node.getAttributedCharacterIterator();
        List textRuns = this.getTextRuns(node, aci);
        this.paintDecorations(textRuns, g2d, 1);
        this.paintDecorations(textRuns, g2d, 4);
        this.paintTextRuns(textRuns, g2d);
        this.paintDecorations(textRuns, g2d, 2);
    }

    private void printAttrs(AttributedCharacterIterator aci) {
        aci.first();
        int start = aci.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (aci.current() != '\uffff') {
            int end = aci.getRunLimit();
            System.out.print("" + (end - start) + ", ");
            aci.setIndex(end);
            start = end;
        }
        System.out.println("");
    }

    public List getTextRuns(TextNode node, AttributedCharacterIterator aci) {
        TextChunk chunk;
        ArrayList textRuns = node.getTextRuns();
        if (textRuns != null) {
            return textRuns;
        }
        AttributedCharacterIterator[] chunkACIs = this.getTextChunkACIs(aci);
        int[][] chunkCharMaps = new int[chunkACIs.length][];
        int chunkStart = aci.getBeginIndex();
        int i = 0;
        while (i < chunkACIs.length) {
            BidiAttributedCharacterIterator iter = new BidiAttributedCharacterIterator(chunkACIs[i], this.fontRenderContext, chunkStart);
            chunkACIs[i] = iter;
            chunkCharMaps[i] = iter.getCharMap();
            chunkACIs[i] = this.createModifiedACIForFontMatching(node, chunkACIs[i]);
            chunkStart += chunkACIs[i].getEndIndex() - chunkACIs[i].getBeginIndex();
            ++i;
        }
        textRuns = new ArrayList();
        TextChunk prevChunk = null;
        int currentChunk = 0;
        Point2D location = node.getLocation();
        do {
            chunkACIs[currentChunk].first();
            chunk = this.getTextChunk(node, chunkACIs[currentChunk], chunkCharMaps[currentChunk], textRuns, prevChunk);
            chunkACIs[currentChunk].first();
            if (chunk != null) {
                location = this.adjustChunkOffsets(location, textRuns, chunk);
            }
            prevChunk = chunk;
        } while (chunk != null && ++currentChunk < chunkACIs.length);
        aci.first();
        List rgns = (List)aci.getAttribute(FLOW_REGIONS);
        if (rgns != null) {
            Iterator i2 = textRuns.iterator();
            ArrayList chunkLayouts = new ArrayList();
            TextRun tr = (TextRun)i2.next();
            ArrayList<TextSpanLayout> layouts = new ArrayList<TextSpanLayout>();
            chunkLayouts.add(layouts);
            layouts.add(tr.getLayout());
            while (i2.hasNext()) {
                tr = (TextRun)i2.next();
                if (tr.isFirstRunInChunk()) {
                    layouts = new ArrayList();
                    chunkLayouts.add(layouts);
                }
                layouts.add(tr.getLayout());
            }
            GlyphLayout.textWrapTextChunk(chunkACIs, chunkLayouts, rgns);
        }
        node.setTextRuns(textRuns);
        return textRuns;
    }

    private AttributedCharacterIterator[] getTextChunkACIs(AttributedCharacterIterator aci) {
        ArrayList<AttributedCharacterSpanIterator> aciList = new ArrayList<AttributedCharacterSpanIterator>();
        int chunkStartIndex = aci.getBeginIndex();
        aci.first();
        Object writingMode = aci.getAttribute(WRITING_MODE);
        boolean vertical = writingMode == WRITING_MODE_TTB;
        while (aci.setIndex(chunkStartIndex) != '\uffff') {
            TextPath prevTextPath = null;
            int start = chunkStartIndex;
            int end = 0;
            while (aci.setIndex(start) != '\uffff') {
                Float runX;
                Float runY;
                TextNode.Anchor anchor;
                TextPath textPath = (TextPath)aci.getAttribute(TEXTPATH);
                if (start != chunkStartIndex) {
                    Float runY2;
                    Float runX2;
                    if (!vertical ? (runX2 = (Float)aci.getAttribute(XPOS)) != null && !runX2.isNaN() : (runY2 = (Float)aci.getAttribute(YPOS)) != null && !runY2.isNaN()) break;
                    if (prevTextPath == null && textPath != null) break;
                }
                prevTextPath = textPath;
                if (aci.getAttribute(FLOW_PARAGRAPH) != null) {
                    end = aci.getRunLimit(FLOW_PARAGRAPH);
                    aci.setIndex(end);
                    break;
                }
                end = aci.getRunLimit(TEXT_COMPOUND_DELIMITER);
                if (start == chunkStartIndex && (anchor = (TextNode.Anchor)aci.getAttribute(ANCHOR_TYPE)) != TextNode.Anchor.START && !(vertical ? (runY = (Float)aci.getAttribute(YPOS)) == null || runY.isNaN() : (runX = (Float)aci.getAttribute(XPOS)) == null || runX.isNaN())) {
                    int i = start + 1;
                    while (i < end) {
                        Float runX3;
                        Float runY3;
                        aci.setIndex(i);
                        if (vertical ? (runY3 = (Float)aci.getAttribute(YPOS)) == null || runY3.isNaN() : (runX3 = (Float)aci.getAttribute(XPOS)) == null || runX3.isNaN()) break;
                        aciList.add(new AttributedCharacterSpanIterator(aci, i - 1, i));
                        chunkStartIndex = i++;
                    }
                }
                start = end;
            }
            int chunkEndIndex = aci.getIndex();
            aciList.add(new AttributedCharacterSpanIterator(aci, chunkStartIndex, chunkEndIndex));
            chunkStartIndex = chunkEndIndex;
        }
        AttributedCharacterIterator[] aciArray = new AttributedCharacterIterator[aciList.size()];
        Iterator iter = aciList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            aciArray[i] = (AttributedCharacterIterator)iter.next();
            ++i;
        }
        return aciArray;
    }

    private AttributedCharacterIterator createModifiedACIForFontMatching(TextNode node, AttributedCharacterIterator aci) {
        aci.first();
        AttributedString as = null;
        int asOff = 0;
        int begin = aci.getBeginIndex();
        boolean moreChunks = true;
        int end = aci.getRunStart(TEXT_COMPOUND_DELIMITER);
        while (moreChunks) {
            int start = end;
            end = aci.getRunLimit(TEXT_COMPOUND_DELIMITER);
            int aciLength = end - start;
            Vector fontFamilies = (Vector)aci.getAttributes().get(GVT_FONT_FAMILIES);
            if (fontFamilies == null) {
                asOff += aciLength;
                moreChunks = aci.setIndex(end) != '\uffff';
                continue;
            }
            ArrayList<GVTFontFamily> resolvedFontFamilies = new ArrayList<GVTFontFamily>(fontFamilies.size());
            int i = 0;
            while (i < fontFamilies.size()) {
                GVTFontFamily fontFamily = (GVTFontFamily)fontFamilies.get(i);
                if (fontFamily instanceof UnresolvedFontFamily) {
                    fontFamily = FontFamilyResolver.resolve((UnresolvedFontFamily)fontFamily);
                }
                if (fontFamily != null) {
                    resolvedFontFamilies.add(fontFamily);
                }
                ++i;
            }
            if (resolvedFontFamilies.size() == 0) {
                resolvedFontFamilies.add(FontFamilyResolver.defaultFont);
            }
            float fontSize = 12.0f;
            Float fsFloat = (Float)aci.getAttributes().get(TextAttribute.SIZE);
            if (fsFloat != null) {
                fontSize = fsFloat.floatValue();
            }
            boolean[] fontAssigned = new boolean[aciLength];
            if (as == null) {
                as = new AttributedString(aci);
            }
            GVTFont defaultFont = null;
            int numSet = 0;
            int firstUnset = start;
            int i2 = 0;
            while (i2 < resolvedFontFamilies.size()) {
                int currentIndex = firstUnset;
                boolean firstUnsetSet = false;
                aci.setIndex(currentIndex);
                GVTFontFamily ff = (GVTFontFamily)resolvedFontFamilies.get(i2);
                GVTFont font = ff.deriveFont(fontSize, aci);
                if (defaultFont == null) {
                    defaultFont = font;
                }
                while (currentIndex < end) {
                    int displayUpToIndex = font.canDisplayUpTo(aci, currentIndex, end);
                    Object altGlyphElement = aci.getAttributes().get(ALT_GLYPH_HANDLER);
                    if (altGlyphElement != null) {
                        displayUpToIndex = -1;
                    }
                    if (displayUpToIndex == -1) {
                        displayUpToIndex = end;
                    }
                    if (displayUpToIndex <= currentIndex) {
                        if (!firstUnsetSet) {
                            firstUnset = currentIndex;
                            firstUnsetSet = true;
                        }
                        ++currentIndex;
                        continue;
                    }
                    int runStart = -1;
                    int j = currentIndex;
                    while (j < displayUpToIndex) {
                        if (fontAssigned[j - start]) {
                            if (runStart != -1) {
                                as.addAttribute(GVT_FONT, font, runStart - begin, j - begin);
                                runStart = -1;
                            }
                        } else if (runStart == -1) {
                            runStart = j;
                        }
                        fontAssigned[j - start] = true;
                        ++numSet;
                        ++j;
                    }
                    if (runStart != -1) {
                        as.addAttribute(GVT_FONT, font, runStart - begin, displayUpToIndex - begin);
                    }
                    currentIndex = displayUpToIndex + 1;
                }
                if (numSet == aciLength) break;
                ++i2;
            }
            int runStart = -1;
            GVTFontFamily prevFF = null;
            GVTFont prevF = defaultFont;
            int i3 = 0;
            while (i3 < aciLength) {
                if (fontAssigned[i3]) {
                    if (runStart != -1) {
                        as.addAttribute(GVT_FONT, prevF, runStart + asOff, i3 + asOff);
                        runStart = -1;
                        prevF = null;
                        prevFF = null;
                    }
                } else {
                    char c = aci.setIndex(start + i3);
                    GVTFontFamily fontFamily = FontFamilyResolver.getFamilyThatCanDisplay(c);
                    if (runStart == -1) {
                        runStart = i3;
                        prevFF = fontFamily;
                        prevF = prevFF == null ? defaultFont : fontFamily.deriveFont(fontSize, aci);
                    } else if (prevFF != fontFamily) {
                        as.addAttribute(GVT_FONT, prevF, runStart + asOff, i3 + asOff);
                        runStart = i3;
                        prevFF = fontFamily;
                        prevF = prevFF == null ? defaultFont : fontFamily.deriveFont(fontSize, aci);
                    }
                }
                ++i3;
            }
            if (runStart != -1) {
                as.addAttribute(GVT_FONT, prevF, runStart + asOff, aciLength + asOff);
            }
            asOff += aciLength;
            if (aci.setIndex(end) == '\uffff') {
                moreChunks = false;
            }
            start = end;
        }
        if (as != null) {
            return as.getIterator();
        }
        return aci;
    }

    private TextChunk getTextChunk(TextNode node, AttributedCharacterIterator aci, int[] charMap, List textRuns, TextChunk prevChunk) {
        int beginChunk = 0;
        if (prevChunk != null) {
            beginChunk = prevChunk.end;
        }
        int endChunk = beginChunk;
        int begin = aci.getIndex();
        if (aci.current() == '\uffff') {
            return null;
        }
        Point2D.Float offset = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float advance = new Point2D.Float(0.0f, 0.0f);
        boolean isChunkStart = true;
        TextSpanLayout layout = null;
        while (true) {
            int start = aci.getRunStart(extendedAtts);
            int end = aci.getRunLimit(extendedAtts);
            AttributedCharacterSpanIterator runaci = new AttributedCharacterSpanIterator(aci, start, end);
            int[] subCharMap = new int[end - start];
            int i = 0;
            while (i < subCharMap.length) {
                subCharMap[i] = charMap[i + start - begin];
                ++i;
            }
            layout = this.getTextLayoutFactory().createTextLayout(runaci, subCharMap, offset, this.fontRenderContext);
            textRuns.add(new TextRun(layout, runaci, isChunkStart));
            Point2D layoutAdvance = layout.getAdvance2D();
            advance.x += (float)layoutAdvance.getX();
            advance.y += (float)layoutAdvance.getY();
            ++endChunk;
            if (aci.setIndex(end) == '\uffff') break;
            isChunkStart = false;
        }
        return new TextChunk(beginChunk, endChunk, advance);
    }

    private Point2D adjustChunkOffsets(Point2D location, List textRuns, TextChunk chunk) {
        Point2D.Float visualAdvance;
        TextRun r = (TextRun)textRuns.get(chunk.begin);
        int anchorType = r.getAnchorType();
        Float length = r.getLength();
        Integer lengthAdj = r.getLengthAdjust();
        boolean doAdjust = true;
        if (length == null || length.isNaN()) {
            doAdjust = false;
        }
        int numChars = 0;
        int n = chunk.begin;
        while (n < chunk.end) {
            r = (TextRun)textRuns.get(n);
            AttributedCharacterIterator aci = r.getACI();
            numChars += aci.getEndIndex() - aci.getBeginIndex();
            ++n;
        }
        if (lengthAdj == GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING && numChars == 1) {
            doAdjust = false;
        }
        float xScale = 1.0f;
        float yScale = 1.0f;
        r = (TextRun)textRuns.get(chunk.end - 1);
        TextSpanLayout layout = r.getLayout();
        GVTGlyphMetrics lastMetrics = layout.getGlyphMetrics(layout.getGlyphCount() - 1);
        Rectangle2D lastBounds = lastMetrics.getBounds2D();
        float lastW = (float)(lastBounds.getWidth() + lastBounds.getX());
        float lastH = (float)(lastBounds.getHeight() + lastBounds.getY());
        if (!doAdjust) {
            visualAdvance = new Point2D.Float((float)(chunk.advance.getX() + (double)lastW - (double)lastMetrics.getHorizontalAdvance()), (float)(chunk.advance.getY() + (double)lastH - (double)lastMetrics.getVerticalAdvance()));
        } else {
            double adv;
            Point2D advance = chunk.advance;
            float delta = 0.0f;
            if (layout.isVertical()) {
                if (lengthAdj == ADJUST_SPACING) {
                    yScale = (float)((double)(length.floatValue() - lastH) / (advance.getY() - (double)lastMetrics.getVerticalAdvance()));
                } else {
                    adv = advance.getY() - (double)lastMetrics.getVerticalAdvance() + (double)lastH;
                    yScale = (float)((double)length.floatValue() / adv);
                }
                visualAdvance = new Point2D.Float(0.0f, length.floatValue());
            } else {
                if (lengthAdj == ADJUST_SPACING) {
                    xScale = (float)((double)(length.floatValue() - lastW) / (advance.getX() - (double)lastMetrics.getHorizontalAdvance()));
                } else {
                    adv = advance.getX() + (double)lastW - (double)lastMetrics.getHorizontalAdvance();
                    xScale = (float)((double)length.floatValue() / adv);
                }
                visualAdvance = new Point2D.Float(length.floatValue(), 0.0f);
            }
            Point2D.Float adv2 = new Point2D.Float(0.0f, 0.0f);
            int n2 = chunk.begin;
            while (n2 < chunk.end) {
                r = (TextRun)textRuns.get(n2);
                layout = r.getLayout();
                layout.setScale(xScale, yScale, lengthAdj == ADJUST_SPACING);
                Point2D lAdv = layout.getAdvance2D();
                adv2.x += (float)lAdv.getX();
                adv2.y += (float)lAdv.getY();
                ++n2;
            }
            chunk.advance = adv2;
        }
        float dx = 0.0f;
        float dy = 0.0f;
        switch (anchorType) {
            case 1: {
                dx = (float)(-((Point2D)visualAdvance).getX() / 2.0);
                dy = (float)(-((Point2D)visualAdvance).getY() / 2.0);
                break;
            }
            case 2: {
                dx = (float)(-((Point2D)visualAdvance).getX());
                dy = (float)(-((Point2D)visualAdvance).getY());
                break;
            }
        }
        r = (TextRun)textRuns.get(chunk.begin);
        layout = r.getLayout();
        AttributedCharacterIterator runaci = r.getACI();
        runaci.first();
        boolean vertical = layout.isVertical();
        Float runX = (Float)runaci.getAttribute(XPOS);
        Float runY = (Float)runaci.getAttribute(YPOS);
        TextPath textPath = (TextPath)runaci.getAttribute(TEXTPATH);
        float absX = (float)location.getX();
        float absY = (float)location.getY();
        float tpShiftX = 0.0f;
        float tpShiftY = 0.0f;
        if (runX != null && !runX.isNaN()) {
            tpShiftX = absX = runX.floatValue();
        }
        if (runY != null && !runY.isNaN()) {
            tpShiftY = absY = runY.floatValue();
        }
        if (vertical) {
            absY += dy;
            tpShiftY += dy;
            tpShiftX = 0.0f;
        } else {
            absX += dx;
            tpShiftX += dx;
            tpShiftY = 0.0f;
        }
        int n3 = chunk.begin;
        while (n3 < chunk.end) {
            Point2D ladv;
            r = (TextRun)textRuns.get(n3);
            layout = r.getLayout();
            runaci = r.getACI();
            runaci.first();
            textPath = (TextPath)runaci.getAttribute(TEXTPATH);
            if (textPath == null) {
                layout.setOffset(new Point2D.Float(absX, absY));
                ladv = layout.getAdvance2D();
                absX = (float)((double)absX + ladv.getX());
                absY = (float)((double)absY + ladv.getY());
            } else {
                layout.setOffset(new Point2D.Float(tpShiftX, tpShiftY));
                ladv = layout.getAdvance2D();
                tpShiftX += (float)ladv.getX();
                tpShiftY += (float)ladv.getY();
                ladv = layout.getTextPathAdvance();
                absX = (float)ladv.getX();
                absY = (float)ladv.getY();
            }
            ++n3;
        }
        return new Point2D.Float(absX, absY);
    }

    private void paintDecorations(List textRuns, Graphics2D g2d, int decorationType) {
        Paint prevPaint = null;
        Paint prevStrokePaint = null;
        Stroke prevStroke = null;
        Rectangle2D decorationRect = null;
        int i = 0;
        while (i < textRuns.size()) {
            TextRun textRun = (TextRun)textRuns.get(i);
            AttributedCharacterIterator runaci = textRun.getACI();
            runaci.first();
            Composite opacity = (Composite)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY);
            if (opacity != null) {
                g2d.setComposite(opacity);
            }
            Paint paint = null;
            Stroke stroke = null;
            Paint strokePaint = null;
            switch (decorationType) {
                case 1: {
                    paint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke = (Stroke)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    strokePaint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke = (Stroke)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    strokePaint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke = (Stroke)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    strokePaint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint != prevPaint || stroke != prevStroke || strokePaint != prevStrokePaint) && decorationRect != null) {
                if (prevPaint != null) {
                    g2d.setPaint(prevPaint);
                    g2d.fill(decorationRect);
                }
                if (prevStroke != null && prevStrokePaint != null) {
                    g2d.setPaint(prevStrokePaint);
                    g2d.setStroke(prevStroke);
                    g2d.draw(decorationRect);
                }
                decorationRect = null;
            }
            if (!(paint == null && strokePaint == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape decorationShape = textRun.getLayout().getDecorationOutline(decorationType);
                if (decorationRect == null) {
                    decorationRect = decorationShape.getBounds2D();
                } else {
                    Rectangle2D bounds = decorationShape.getBounds2D();
                    decorationRect.setRect(decorationRect.getMinX(), decorationRect.getMinY(), bounds.getMaxX() - decorationRect.getMinX(), decorationRect.getHeight());
                }
            }
            prevPaint = paint;
            prevStroke = stroke;
            prevStrokePaint = strokePaint;
            ++i;
        }
        if (decorationRect != null) {
            if (prevPaint != null) {
                g2d.setPaint(prevPaint);
                g2d.fill(decorationRect);
            }
            if (prevStroke != null && prevStrokePaint != null) {
                g2d.setPaint(prevStrokePaint);
                g2d.setStroke(prevStroke);
                g2d.draw(decorationRect);
            }
        }
    }

    private void paintTextRuns(List textRuns, Graphics2D g2d) {
        int i = 0;
        while (i < textRuns.size()) {
            TextRun textRun = (TextRun)textRuns.get(i);
            AttributedCharacterIterator runaci = textRun.getACI();
            runaci.first();
            Composite opacity = (Composite)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY);
            if (opacity != null) {
                g2d.setComposite(opacity);
            }
            textRun.getLayout().draw(g2d);
            ++i;
        }
    }

    public Shape getOutline(TextNode node) {
        GeneralPath outline = null;
        AttributedCharacterIterator aci = node.getAttributedCharacterIterator();
        List textRuns = this.getTextRuns(node, aci);
        int i = 0;
        while (i < textRuns.size()) {
            TextRun textRun = (TextRun)textRuns.get(i);
            TextSpanLayout textRunLayout = textRun.getLayout();
            GeneralPath textRunOutline = new GeneralPath(textRunLayout.getOutline());
            if (outline == null) {
                outline = textRunOutline;
            } else {
                outline.setWindingRule(1);
                outline.append(textRunOutline, false);
            }
            ++i;
        }
        Shape underline = this.getDecorationOutline(textRuns, 1);
        Shape strikeThrough = this.getDecorationOutline(textRuns, 2);
        Shape overline = this.getDecorationOutline(textRuns, 4);
        if (underline != null) {
            if (outline == null) {
                outline = new GeneralPath(underline);
            } else {
                outline.setWindingRule(1);
                outline.append(underline, false);
            }
        }
        if (strikeThrough != null) {
            if (outline == null) {
                outline = new GeneralPath(strikeThrough);
            } else {
                outline.setWindingRule(1);
                outline.append(strikeThrough, false);
            }
        }
        if (overline != null) {
            if (outline == null) {
                outline = new GeneralPath(overline);
            } else {
                outline.setWindingRule(1);
                outline.append(overline, false);
            }
        }
        return outline;
    }

    public Rectangle2D getBounds2D(TextNode node) {
        Shape overline;
        Shape strikeThrough;
        AttributedCharacterIterator aci = node.getAttributedCharacterIterator();
        List textRuns = this.getTextRuns(node, aci);
        Rectangle2D bounds = null;
        int i = 0;
        while (i < textRuns.size()) {
            Object textRunStrokeOutline = null;
            TextRun textRun = (TextRun)textRuns.get(i);
            AttributedCharacterIterator textRunACI = textRun.getACI();
            textRunACI.first();
            TextSpanLayout textRunLayout = textRun.getLayout();
            bounds = bounds == null ? textRunLayout.getBounds2D() : bounds.createUnion(textRunLayout.getBounds2D());
            ++i;
        }
        Shape underline = this.getDecorationStrokeOutline(textRuns, 1);
        if (underline != null) {
            bounds = bounds == null ? underline.getBounds2D() : bounds.createUnion(underline.getBounds2D());
        }
        if ((strikeThrough = this.getDecorationStrokeOutline(textRuns, 2)) != null) {
            bounds = bounds == null ? strikeThrough.getBounds2D() : bounds.createUnion(strikeThrough.getBounds2D());
        }
        if ((overline = this.getDecorationStrokeOutline(textRuns, 4)) != null) {
            bounds = bounds == null ? overline.getBounds2D() : bounds.createUnion(overline.getBounds2D());
        }
        return bounds;
    }

    private Shape getDecorationOutline(List textRuns, int decorationType) {
        Path2D outline = null;
        Paint prevPaint = null;
        Paint prevStrokePaint = null;
        Stroke prevStroke = null;
        Rectangle2D decorationRect = null;
        int i = 0;
        while (i < textRuns.size()) {
            TextRun textRun = (TextRun)textRuns.get(i);
            AttributedCharacterIterator runaci = textRun.getACI();
            runaci.first();
            Paint paint = null;
            Stroke stroke = null;
            Paint strokePaint = null;
            switch (decorationType) {
                case 1: {
                    paint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke = (Stroke)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    strokePaint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke = (Stroke)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    strokePaint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke = (Stroke)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    strokePaint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return null;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint != prevPaint || stroke != prevStroke || strokePaint != prevStrokePaint) && decorationRect != null) {
                if (outline == null) {
                    outline = new GeneralPath(decorationRect);
                } else {
                    outline.append(decorationRect, false);
                }
                decorationRect = null;
            }
            if (!(paint == null && strokePaint == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape decorationShape = textRun.getLayout().getDecorationOutline(decorationType);
                if (decorationRect == null) {
                    decorationRect = decorationShape.getBounds2D();
                } else {
                    Rectangle2D bounds = decorationShape.getBounds2D();
                    decorationRect.setRect(decorationRect.getMinX(), decorationRect.getMinY(), bounds.getMaxX() - decorationRect.getMinX(), decorationRect.getHeight());
                }
            }
            prevPaint = paint;
            prevStroke = stroke;
            prevStrokePaint = strokePaint;
            ++i;
        }
        if (decorationRect != null) {
            if (outline == null) {
                outline = new GeneralPath(decorationRect);
            } else {
                outline.append(decorationRect, false);
            }
        }
        return outline;
    }

    private Shape getDecorationStrokeOutline(List textRuns, int decorationType) {
        Path2D outline = null;
        Paint prevPaint = null;
        Paint prevStrokePaint = null;
        Stroke prevStroke = null;
        Rectangle2D decorationRect = null;
        int i = 0;
        while (i < textRuns.size()) {
            TextRun textRun = (TextRun)textRuns.get(i);
            AttributedCharacterIterator runaci = textRun.getACI();
            runaci.first();
            Paint paint = null;
            Stroke stroke = null;
            Paint strokePaint = null;
            switch (decorationType) {
                case 1: {
                    paint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke = (Stroke)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    strokePaint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke = (Stroke)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    strokePaint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke = (Stroke)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    strokePaint = (Paint)runaci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return null;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint != prevPaint || stroke != prevStroke || strokePaint != prevStrokePaint) && decorationRect != null && prevStroke != null && prevStrokePaint != null) {
                if (outline == null) {
                    outline = new GeneralPath(prevStroke.createStrokedShape(decorationRect));
                } else {
                    outline.append(prevStroke.createStrokedShape(decorationRect), false);
                }
                decorationRect = null;
            }
            if (!(paint == null && strokePaint == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape decorationShape = textRun.getLayout().getDecorationOutline(decorationType);
                if (decorationRect == null) {
                    decorationRect = decorationShape.getBounds2D();
                } else {
                    Rectangle2D bounds = decorationShape.getBounds2D();
                    decorationRect.setRect(decorationRect.getMinX(), decorationRect.getMinY(), bounds.getMaxX() - decorationRect.getMinX(), decorationRect.getHeight());
                }
            }
            prevPaint = paint;
            prevStroke = stroke;
            prevStrokePaint = strokePaint;
            ++i;
        }
        if (decorationRect != null && prevStroke != null && prevStrokePaint != null) {
            if (outline == null) {
                outline = new GeneralPath(prevStroke.createStrokedShape(decorationRect));
            } else {
                outline.append(prevStroke.createStrokedShape(decorationRect), false);
            }
        }
        return outline;
    }

    public Mark getMark(TextNode node, int index, boolean leadingEdge) {
        AttributedCharacterIterator aci = node.getAttributedCharacterIterator();
        if (index < aci.getBeginIndex() || index > aci.getEndIndex()) {
            return null;
        }
        TextHit textHit = new TextHit(index, leadingEdge);
        return new BasicTextPainter.BasicMark(node, textHit);
    }

    protected Mark hitTest(double x, double y, TextNode node) {
        AttributedCharacterIterator aci = node.getAttributedCharacterIterator();
        List textRuns = this.getTextRuns(node, aci);
        int i = 0;
        while (i < textRuns.size()) {
            TextRun textRun = (TextRun)textRuns.get(i);
            TextSpanLayout layout = textRun.getLayout();
            TextHit textHit = layout.hitTestChar((float)x, (float)y);
            if (textHit != null && layout.getBounds2D().contains(x, y)) {
                return new BasicTextPainter.BasicMark(node, textHit);
            }
            ++i;
        }
        return null;
    }

    public Mark selectFirst(TextNode node) {
        AttributedCharacterIterator aci = node.getAttributedCharacterIterator();
        TextHit textHit = new TextHit(aci.getBeginIndex(), false);
        return new BasicTextPainter.BasicMark(node, textHit);
    }

    public Mark selectLast(TextNode node) {
        AttributedCharacterIterator aci = node.getAttributedCharacterIterator();
        TextHit textHit = new TextHit(aci.getEndIndex(), false);
        return new BasicTextPainter.BasicMark(node, textHit);
    }

    public int[] getSelected(Mark startMark, Mark finishMark) {
        BasicTextPainter.BasicMark finish;
        BasicTextPainter.BasicMark start;
        if (startMark == null || finishMark == null) {
            return null;
        }
        try {
            start = (BasicTextPainter.BasicMark)startMark;
            finish = (BasicTextPainter.BasicMark)finishMark;
        }
        catch (ClassCastException cce) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = start.getTextNode();
        if (textNode != finish.getTextNode()) {
            throw new Error("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator aci = textNode.getAttributedCharacterIterator();
        int[] result = new int[]{start.getHit().getCharIndex(), finish.getHit().getCharIndex()};
        List textRuns = this.getTextRuns(textNode, aci);
        Iterator trI = textRuns.iterator();
        int startGlyphIndex = -1;
        int endGlyphIndex = -1;
        TextSpanLayout startLayout = null;
        TextSpanLayout endLayout = null;
        while (trI.hasNext()) {
            TextRun tr = (TextRun)trI.next();
            TextSpanLayout tsl = tr.getLayout();
            if (startGlyphIndex == -1 && (startGlyphIndex = tsl.getGlyphIndex(result[0])) != -1) {
                startLayout = tsl;
            }
            if (endGlyphIndex == -1 && (endGlyphIndex = tsl.getGlyphIndex(result[1])) != -1) {
                endLayout = tsl;
            }
            if (startGlyphIndex != -1 && endGlyphIndex != -1) break;
        }
        if (startLayout == null || endLayout == null) {
            return null;
        }
        int startCharCount = startLayout.getCharacterCount(startGlyphIndex, startGlyphIndex);
        int endCharCount = endLayout.getCharacterCount(endGlyphIndex, endGlyphIndex);
        if (startCharCount > 1) {
            if (result[0] > result[1] && startLayout.isLeftToRight()) {
                result[0] = result[0] + (startCharCount - 1);
            } else if (result[1] > result[0] && !startLayout.isLeftToRight()) {
                result[0] = result[0] - (startCharCount - 1);
            }
        }
        if (endCharCount > 1) {
            if (result[1] > result[0] && endLayout.isLeftToRight()) {
                result[1] = result[1] + (endCharCount - 1);
            } else if (result[0] > result[1] && !endLayout.isLeftToRight()) {
                result[1] = result[1] - (endCharCount - 1);
            }
        }
        return result;
    }

    public Shape getHighlightShape(Mark beginMark, Mark endMark) {
        int endIndex;
        BasicTextPainter.BasicMark end;
        BasicTextPainter.BasicMark begin;
        if (beginMark == null || endMark == null) {
            return null;
        }
        try {
            begin = (BasicTextPainter.BasicMark)beginMark;
            end = (BasicTextPainter.BasicMark)endMark;
        }
        catch (ClassCastException cce) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = begin.getTextNode();
        if (textNode != end.getTextNode()) {
            throw new Error("Markers are from different TextNodes!");
        }
        if (textNode == null) {
            return null;
        }
        int beginIndex = begin.getHit().getCharIndex();
        if (beginIndex > (endIndex = end.getHit().getCharIndex())) {
            BasicTextPainter.BasicMark tmpMark = begin;
            begin = end;
            end = tmpMark;
            int tmpIndex = beginIndex;
            beginIndex = endIndex;
            endIndex = tmpIndex;
        }
        List textRuns = this.getTextRuns(textNode, textNode.getAttributedCharacterIterator());
        GeneralPath highlightedShape = new GeneralPath();
        int i = 0;
        while (i < textRuns.size()) {
            TextRun textRun = (TextRun)textRuns.get(i);
            TextSpanLayout layout = textRun.getLayout();
            Shape layoutHighlightedShape = layout.getHighlightShape(beginIndex, endIndex);
            if (layoutHighlightedShape != null && !layoutHighlightedShape.getBounds().isEmpty()) {
                highlightedShape.append(layoutHighlightedShape, false);
            }
            ++i;
        }
        return highlightedShape;
    }

    static {
        extendedAtts.add(FLOW_PARAGRAPH);
        extendedAtts.add(TEXT_COMPOUND_DELIMITER);
        extendedAtts.add(GVT_FONT);
        extendedAtts.add(BIDI_LEVEL);
        singleton = new StrokingTextPainter();
    }

    public class TextRun {
        private AttributedCharacterIterator aci;
        private TextSpanLayout layout;
        private int anchorType;
        private boolean firstRunInChunk;
        private Float length;
        private Integer lengthAdjust;

        public TextRun(TextSpanLayout layout, AttributedCharacterIterator aci, boolean firstRunInChunk) {
            this.layout = layout;
            this.aci = aci;
            this.aci.first();
            this.firstRunInChunk = firstRunInChunk;
            this.anchorType = 0;
            TextNode.Anchor anchor = (TextNode.Anchor)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
            if (anchor != null) {
                this.anchorType = anchor.getType();
            }
            if (aci.getAttribute(WRITING_MODE) == WRITING_MODE_RTL) {
                if (this.anchorType == 0) {
                    this.anchorType = 2;
                } else if (this.anchorType == 2) {
                    this.anchorType = 0;
                }
            }
            this.length = (Float)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH);
            this.lengthAdjust = (Integer)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST);
        }

        public AttributedCharacterIterator getACI() {
            return this.aci;
        }

        public TextSpanLayout getLayout() {
            return this.layout;
        }

        public int getAnchorType() {
            return this.anchorType;
        }

        public Float getLength() {
            return this.length;
        }

        public Integer getLengthAdjust() {
            return this.lengthAdjust;
        }

        public boolean isFirstRunInChunk() {
            return this.firstRunInChunk;
        }
    }

    class TextChunk {
        public int begin;
        public int end;
        public Point2D advance;

        public TextChunk(int begin, int end, Point2D advance) {
            this.begin = begin;
            this.end = end;
            this.advance = new Point2D.Float((float)advance.getX(), (float)advance.getY());
        }
    }
}

