/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.OptimisticCacheSource;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.DataVersion;

public class OptimisticTreeCache
implements OptimisticCache {
    private static final Log log = LogFactory.getLog((Class)OptimisticTreeCache.class);
    private static final String ITEM = "item";
    private TreeCache cache;
    private final String regionName;
    private final String userRegionName;
    private OptimisticCacheSource source;

    public OptimisticTreeCache(TreeCache cache, String regionName) throws CacheException {
        this.cache = cache;
        this.userRegionName = regionName;
        this.regionName = regionName.replace('.', '/');
    }

    public void setSource(OptimisticCacheSource source) {
        this.source = source;
    }

    public void writeInsert(Object key, Object value, Object currentVersion) {
        this.writeUpdate(key, value, currentVersion, null);
    }

    public void writeUpdate(Object key, Object value, Object currentVersion, Object previousVersion) {
        try {
            Option option = null;
            if (this.source != null && this.source.isVersioned()) {
                option = new Option();
                option.setDataVersion((DataVersion)new DataVersionAdapter(currentVersion, previousVersion, this.source.getVersionComparator()));
            }
            this.cache.put(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM, value, option);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void writeLoad(Object key, Object value, Object currentVersion) {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            this.cache.remove(new Fqn(new Object[]{this.regionName, key}), (Object)"ITEM", option);
            if (this.source != null && this.source.isVersioned()) {
                option.setDataVersion((DataVersion)new DataVersionAdapter(currentVersion, null, this.source.getVersionComparator()));
            }
            this.cache.put(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM, value, option);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public Object get(Object key) throws CacheException {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            return this.cache.get(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM, option);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public Object read(Object key) throws CacheException {
        try {
            return this.cache.get(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void update(Object key, Object value) throws CacheException {
        try {
            this.cache.put(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM, value);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            this.cache.put(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM, value, option);
        }
        catch (TimeoutException te) {
            log.debug((Object)"ignoring write lock acquisition failure");
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            this.cache.remove(new Fqn(new Object[]{this.regionName, key}));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.remove(new Fqn((Object)this.regionName));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void destroy() throws CacheException {
        try {
            Option option = new Option();
            option.setCacheModeLocal(true);
            this.cache.remove(new Fqn((Object)this.regionName), option);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.userRegionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            Set children = this.cache.getChildrenNames(new Fqn((Object)this.regionName));
            return children == null ? 0L : (long)children.size();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            Set childrenNames = this.cache.getChildrenNames(new Fqn((Object)this.regionName));
            if (childrenNames != null) {
                Iterator iter = childrenNames.iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    result.put(key, this.cache.get(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public String toString() {
        return "OptimisticTreeCache(" + this.userRegionName + ')';
    }

    public static class DataVersionAdapter
    implements DataVersion {
        private final Object currentVersion;
        private final Object previousVersion;
        private final Comparator versionComparator;

        public DataVersionAdapter(Object currentVersion, Object previousVersion, Comparator versionComparator) {
            this.currentVersion = currentVersion;
            this.previousVersion = previousVersion;
            this.versionComparator = versionComparator;
        }

        public boolean newerThan(DataVersion dataVersion) {
            Object other;
            if (this.previousVersion == null) {
                log.warn((Object)"Unexpected optimistic lock check on inserted data");
            }
            return this.versionComparator.compare(this.previousVersion, other = ((DataVersionAdapter)dataVersion).currentVersion) > 1;
        }
    }
}

