/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.ejbthree1109.unit;

import java.util.Properties;
import java.util.UUID;

import javax.naming.Context;
import javax.naming.InitialContext;

import junit.framework.Test;

import org.jboss.ejb3.test.ejbthree1109.WaiterRemote;
import org.jboss.ejb3.test.ejbthree1109.WaiterRemoteHome;
import org.jboss.test.JBossClusteredTestCase;

/**
 * ClusteredHomeBeanUnitTestCase.
 * 
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 */
public class ClusteredHomeBeanUnitTestCase extends JBossClusteredTestCase
{
   public ClusteredHomeBeanUnitTestCase(String name)
   {
      super(name);
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(ClusteredHomeBeanUnitTestCase.class, "ejbthree1109.jar");
   }
   
   @Override
   protected void setUp() throws Exception
   {
      getLog().info(getName());
   }

   @Override
   protected void tearDown() throws Exception
   {
   }

   public void testSlsbHomeAndBeanLoadBalancing() throws Exception
   {
      Context ctx = getFirstInitialContext();
      
      WaiterRemoteHome home = (WaiterRemoteHome)ctx.lookup("WaiterSlsbEjb21Bean/home");
      log.info("Ejb21 home lookup returned " + home);
      for (int i = 0; i < 5; i++)
      {
         /* Home load balancing is checked via LoadBalanceAssertInterceptor */
         WaiterRemote waiter = home.create();
         log.info("Create call on Ejb21 home returned " + waiter);
         UUID previous = null;
         for (int j = 0; j < 5; j++)
         {
            UUID current = waiter.whoServes("me-" + i + "-" + j);

            if (previous != null)
            {
               log.info("Compare UUIDs, previous " + previous + " with current " + current);
               assertNotSame(previous, current);
            }
            
            previous = current;
         }
      }
   }
   
   public void testSfsbHomeAndBeanLoadBalancing() throws Exception
   {
      Context ctx = getFirstInitialContext();
      
      WaiterRemoteHome home = (WaiterRemoteHome)ctx.lookup("WaiterSfsbEjb21Bean/home");
      log.info("Ejb21 home lookup returned " + home);
      for (int i = 0; i < 5; i++)
      {
         /* Home load balancing is checked via LoadBalanceAssertInterceptor */
         WaiterRemote waiter = home.create("new-" + i);
         log.info("Create call on Ejb21 home returned " + waiter);
         UUID previous = null;
         for (int j = 0; j < 5; j++)
         {
            UUID current = waiter.whoServes("me-" + i + "-" + j);

            if (previous != null)
            {
               log.info("Compare UUIDs, previous " + previous + " with current " + current);
               assertSame(previous, current);
            }            
         }
      }
   }
   
   private Context getFirstInitialContext() throws Exception
   {
      String[] urls = getNamingURLs();
      Properties env = new Properties();
      env.setProperty(Context.INITIAL_CONTEXT_FACTORY, "org.jnp.interfaces.NamingContextFactory");
      env.setProperty(Context.PROVIDER_URL, urls[0]);
      return new InitialContext(env);
   }
}
