/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.joinpoint.plugins.config;

import java.util.Arrays;
import org.jboss.joinpoint.spi.ConstructorJoinpoint;
import org.jboss.joinpoint.spi.FieldGetJoinpoint;
import org.jboss.joinpoint.spi.FieldSetJoinpoint;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

public class Config {
    protected static final Logger log = Logger.getLogger((Class)Config.class);
    private static final String[] NO_PARAMS_TYPES = new String[0];
    private static final Object[] NO_PARAMS = new Object[0];

    public static Object instantiate(JoinpointFactory joinpointFactory, String[] stringArray, Object[] objectArray) throws Throwable {
        ConstructorJoinpoint constructorJoinpoint = Config.getConstructorJoinpoint(joinpointFactory, stringArray, objectArray);
        return constructorJoinpoint.dispatch();
    }

    public static void configure(Object object, JoinpointFactory joinpointFactory, String string, Object object2) throws Throwable {
        FieldSetJoinpoint fieldSetJoinpoint = Config.getFieldSetJoinpoint(object, joinpointFactory, string, object2);
        fieldSetJoinpoint.dispatch();
    }

    public static void unconfigure(Object object, JoinpointFactory joinpointFactory, String string) throws Throwable {
        FieldSetJoinpoint fieldSetJoinpoint = Config.getFieldSetJoinpoint(object, joinpointFactory, string, null);
        fieldSetJoinpoint.dispatch();
    }

    public static Object invoke(Object object, JoinpointFactory joinpointFactory, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        MethodJoinpoint methodJoinpoint = Config.getMethodJoinpoint(object, joinpointFactory, string, stringArray, objectArray);
        return methodJoinpoint.dispatch();
    }

    public static ConstructorJoinpoint getConstructorJoinpoint(JoinpointFactory joinpointFactory) throws Throwable {
        return Config.getConstructorJoinpoint(joinpointFactory, null, null);
    }

    public static ConstructorJoinpoint getConstructorJoinpoint(JoinpointFactory joinpointFactory, String[] stringArray, Object[] objectArray) throws Throwable {
        boolean bl;
        if (stringArray == null) {
            stringArray = NO_PARAMS_TYPES;
        }
        if (objectArray == null) {
            objectArray = NO_PARAMS;
        }
        if (bl = log.isTraceEnabled()) {
            log.trace((Object)("Get constructor Joinpoint jpf=" + joinpointFactory + " paramTypes=" + Arrays.asList(stringArray) + " params=" + Arrays.asList(objectArray)));
        }
        ConstructorInfo constructorInfo = Config.findConstructorInfo(joinpointFactory.getClassInfo(), stringArray);
        ConstructorJoinpoint constructorJoinpoint = joinpointFactory.getConstructorJoinpoint(constructorInfo);
        constructorJoinpoint.setArguments(objectArray);
        return constructorJoinpoint;
    }

    public static FieldGetJoinpoint getFieldGetJoinpoint(Object object, JoinpointFactory joinpointFactory, String string) throws Throwable {
        boolean bl = log.isTraceEnabled();
        if (bl) {
            log.trace((Object)("Get field get Joinpoint jpf=" + joinpointFactory + " target=" + object + " name=" + string));
        }
        FieldInfo fieldInfo = Config.findFieldInfo(joinpointFactory.getClassInfo(), string);
        FieldGetJoinpoint fieldGetJoinpoint = joinpointFactory.getFieldGetJoinpoint(fieldInfo);
        fieldGetJoinpoint.setTarget(object);
        return fieldGetJoinpoint;
    }

    public static FieldSetJoinpoint getFieldSetJoinpoint(Object object, JoinpointFactory joinpointFactory, String string, Object object2) throws Throwable {
        boolean bl = log.isTraceEnabled();
        if (bl) {
            log.trace((Object)("Get field set Joinpoint jpf=" + joinpointFactory + " target=" + object + " name=" + string + " value=" + object2));
        }
        FieldInfo fieldInfo = Config.findFieldInfo(joinpointFactory.getClassInfo(), string);
        FieldSetJoinpoint fieldSetJoinpoint = joinpointFactory.getFieldSetJoinpoint(fieldInfo);
        fieldSetJoinpoint.setTarget(object);
        fieldSetJoinpoint.setValue(object2);
        return fieldSetJoinpoint;
    }

    public static MethodJoinpoint getMethodJoinpoint(Object object, JoinpointFactory joinpointFactory, String string, String[] stringArray, Object[] objectArray) throws Throwable {
        boolean bl = log.isTraceEnabled();
        if (bl) {
            if (stringArray != null) {
                log.trace((Object)("Get method Joinpoint jpf=" + joinpointFactory + " target=" + object + " name=" + string + " paramTypes=" + Arrays.asList(stringArray)));
            } else {
                log.trace((Object)("Get method Joinpoint jpf=" + joinpointFactory + " target=" + object + " name=" + string + " paramTypes=()"));
            }
        }
        MethodInfo methodInfo = Config.findMethodInfo(joinpointFactory.getClassInfo(), string, stringArray);
        MethodJoinpoint methodJoinpoint = joinpointFactory.getMethodJoinpoint(methodInfo);
        methodJoinpoint.setTarget(object);
        methodJoinpoint.setArguments(objectArray);
        return methodJoinpoint;
    }

    public static ConstructorInfo findConstructorInfo(ClassInfo classInfo, String[] stringArray) throws JoinpointException {
        ConstructorInfo[] constructorInfoArray = classInfo.getDeclaredConstructors();
        if (constructorInfoArray != null) {
            for (int i = 0; i < constructorInfoArray.length; ++i) {
                if (!Config.equals(stringArray, constructorInfoArray[i].getParameterTypes())) continue;
                return constructorInfoArray[i];
            }
            throw new JoinpointException("Constructor not found " + classInfo.getName() + Arrays.asList(stringArray) + " in " + Arrays.asList(constructorInfoArray));
        }
        throw new JoinpointException("Constructor not found " + classInfo.getName() + Arrays.asList(stringArray) + " no constructors");
    }

    public static FieldInfo findFieldInfo(ClassInfo classInfo, String string) throws JoinpointException {
        for (ClassInfo classInfo2 = classInfo; classInfo2 != null; classInfo2 = classInfo2.getSuperclass()) {
            FieldInfo fieldInfo = Config.locateFieldInfo(classInfo2, string);
            if (fieldInfo == null) continue;
            return fieldInfo;
        }
        throw new JoinpointException("Field not found '" + string + "' for class " + classInfo.getName());
    }

    private static FieldInfo locateFieldInfo(ClassInfo classInfo, String string) {
        FieldInfo[] fieldInfoArray = classInfo.getDeclaredFields();
        if (fieldInfoArray != null) {
            for (int i = 0; i < fieldInfoArray.length; ++i) {
                if (!string.equals(fieldInfoArray[i].getName())) continue;
                return fieldInfoArray[i];
            }
        }
        return null;
    }

    public static MethodInfo findMethodInfo(ClassInfo classInfo, String string, String[] stringArray) throws JoinpointException {
        if (stringArray == null) {
            stringArray = NO_PARAMS_TYPES;
        }
        for (ClassInfo classInfo2 = classInfo; classInfo2 != null; classInfo2 = classInfo2.getSuperclass()) {
            MethodInfo methodInfo = Config.locateMethodInfo(classInfo2, string, stringArray);
            if (methodInfo == null) continue;
            return methodInfo;
        }
        throw new JoinpointException("Method not found " + string + Arrays.asList(stringArray) + " for class " + classInfo.getName());
    }

    private static MethodInfo locateMethodInfo(ClassInfo classInfo, String string, String[] stringArray) {
        MethodInfo[] methodInfoArray = classInfo.getDeclaredMethods();
        if (methodInfoArray != null) {
            for (int i = 0; i < methodInfoArray.length; ++i) {
                if (!string.equals(methodInfoArray[i].getName()) || !Config.equals(stringArray, methodInfoArray[i].getParameterTypes())) continue;
                return methodInfoArray[i];
            }
        }
        return null;
    }

    public static boolean equals(String[] stringArray, TypeInfo[] typeInfoArray) {
        if (stringArray == null || typeInfoArray == null) {
            return false;
        }
        if (stringArray.length != typeInfoArray.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals(typeInfoArray[i].getName())) continue;
            return false;
        }
        return true;
    }
}

