/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.search;

import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.util.ReflectHelper;

public class SearchConfiguration {
    private static Log log = LogFactory.getLog(SearchConfiguration.class);

    public static void enableHibernateSearch(EventListeners eventListeners, Properties properties) {
        boolean enableSearchListeners = !"false".equalsIgnoreCase(properties.getProperty("hibernate.search.autoregister_listeners"));
        boolean enableCollectionSearchListeners = false;
        Class searchEventListenerClass = null;
        Class nonCollectionSearchEventListener = null;
        try {
            nonCollectionSearchEventListener = searchEventListenerClass = ReflectHelper.classForName((String)"org.hibernate.search.event.FullTextIndexEventListener", SearchConfiguration.class);
            try {
                ReflectHelper.classForName((String)"org.hibernate.event.AbstractCollectionEvent", SearchConfiguration.class);
                searchEventListenerClass = ReflectHelper.classForName((String)"org.hibernate.search.event.FullTextIndexCollectionEventListener", SearchConfiguration.class);
                enableCollectionSearchListeners = true;
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)"Hibernate Search collection listeners not present (upgrate to Hibernate Core 3.2.6 and above and Hibernate Search 3.0.1 and above)");
            }
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Search not present in classpath, ignoring event listener registration");
        }
        if (enableSearchListeners && searchEventListenerClass != null) {
            PostInsertEventListener eventListener2;
            int i$;
            int len$;
            PostInsertEventListener[] arr$;
            Object searchEventListener;
            try {
                searchEventListener = searchEventListenerClass.newInstance();
            }
            catch (Exception e) {
                throw new AnnotationException("Unable to load Search event listener", e);
            }
            boolean present = false;
            PostInsertEventListener[] listeners = eventListeners.getPostInsertEventListeners();
            if (listeners != null) {
                arr$ = listeners;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    eventListener2 = arr$[i$];
                    present = present || searchEventListenerClass == eventListener2.getClass() || enableCollectionSearchListeners && nonCollectionSearchEventListener == eventListener2.getClass();
                }
                if (!present) {
                    int length = listeners.length + 1;
                    PostInsertEventListener[] newListeners = new PostInsertEventListener[length];
                    System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                    newListeners[length - 1] = (PostInsertEventListener)searchEventListener;
                    eventListeners.setPostInsertEventListeners(newListeners);
                }
            } else {
                eventListeners.setPostInsertEventListeners(new PostInsertEventListener[]{(PostInsertEventListener)searchEventListener});
            }
            present = false;
            listeners = eventListeners.getPostUpdateEventListeners();
            if (listeners != null) {
                arr$ = listeners;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    eventListener2 = arr$[i$];
                    present = present || searchEventListenerClass == eventListener2.getClass() || enableCollectionSearchListeners && nonCollectionSearchEventListener == eventListener2.getClass();
                }
                if (!present) {
                    int length = listeners.length + 1;
                    PostUpdateEventListener[] newListeners = new PostUpdateEventListener[length];
                    System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                    newListeners[length - 1] = (PostUpdateEventListener)searchEventListener;
                    eventListeners.setPostUpdateEventListeners(newListeners);
                }
            } else {
                eventListeners.setPostUpdateEventListeners(new PostUpdateEventListener[]{(PostUpdateEventListener)searchEventListener});
            }
            present = false;
            listeners = eventListeners.getPostDeleteEventListeners();
            if (listeners != null) {
                for (PostInsertEventListener eventListener2 : listeners) {
                    present = present || searchEventListenerClass == eventListener2.getClass() || enableCollectionSearchListeners && nonCollectionSearchEventListener == eventListener2.getClass();
                }
                if (!present) {
                    int length = listeners.length + 1;
                    PostDeleteEventListener[] newListeners = new PostDeleteEventListener[length];
                    System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                    newListeners[length - 1] = (PostDeleteEventListener)searchEventListener;
                    eventListeners.setPostDeleteEventListeners(newListeners);
                }
            } else {
                eventListeners.setPostDeleteEventListeners(new PostDeleteEventListener[]{(PostDeleteEventListener)searchEventListener});
            }
            if (enableCollectionSearchListeners) {
                try {
                    Class collectionSearchConfigurationClass = ReflectHelper.classForName((String)"org.hibernate.cfg.search.CollectionSearchConfiguration", SearchConfiguration.class);
                    Method method = collectionSearchConfigurationClass.getDeclaredMethod("enableHibernateSearch", EventListeners.class, Object.class, Class.class);
                    method.invoke(null, eventListeners, searchEventListener, searchEventListenerClass);
                }
                catch (Exception e) {
                    throw new AnnotationException("Unable to load Search event listener", e);
                }
            }
        }
    }
}

