/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.FileUtils;

public class Length
extends Task
implements Condition {
    private static final String ALL = "all";
    private static final String EACH = "each";
    private static final String STRING = "string";
    private static final String LENGTH_REQUIRED = "Use of the Length condition requires that the length attribute be set.";
    private String property;
    private String string;
    private Boolean trim;
    private String mode = "all";
    private When when = When.access$000();
    private Long length;
    private Vector filesets;

    public synchronized void setProperty(String property) {
        this.property = property;
    }

    public synchronized void setFile(File file) {
        FileSet fs = new FileSet();
        fs.setFile(file);
        this.add(fs);
    }

    public synchronized void add(FileSet fs) {
        if (fs == null) {
            return;
        }
        this.filesets = this.filesets == null ? new Vector() : this.filesets;
        this.filesets.add(fs);
    }

    public synchronized void setLength(long ell) {
        this.length = new Long(ell);
    }

    public synchronized void setWhen(When w) {
        this.when = w;
    }

    public synchronized void setMode(FileMode m) {
        this.mode = m.getValue();
    }

    public synchronized void setString(String string) {
        this.string = string;
        this.mode = STRING;
    }

    public synchronized void setTrim(boolean trim) {
        this.trim = trim ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean getTrim() {
        return this.trim != null && this.trim != false;
    }

    public void execute() {
        this.validate();
        PrintStream ps = new PrintStream(this.property != null ? new PropertyOutputStream() : new LogOutputStream(this, 2));
        if (STRING.equals(this.mode)) {
            ps.print(Length.getLength(this.string, this.getTrim()));
            ps.close();
        } else if (EACH.equals(this.mode)) {
            this.handleResources(new EachHandler(ps));
        } else if (ALL.equals(this.mode)) {
            this.handleResources(new AllHandler(ps));
        }
    }

    public boolean eval() {
        this.validate();
        if (this.length == null) {
            throw new BuildException(LENGTH_REQUIRED);
        }
        Long ell = null;
        if (STRING.equals(this.mode)) {
            ell = new Long(Length.getLength(this.string, this.getTrim()));
        } else {
            ConditionHandler h = new ConditionHandler();
            this.handleResources(h);
            ell = new Long(h.getLength());
        }
        int w = this.when.getIndex();
        int comp = ell.compareTo(this.length);
        return w == 0 && comp == 0 || w == 1 && comp > 0 || w == 2 && comp < 0;
    }

    private void validate() {
        if (this.string != null) {
            if (this.filesets != null && this.filesets.size() > 0) {
                throw new BuildException("the string length function is incompatible with the file length function");
            }
            if (!STRING.equals(this.mode)) {
                throw new BuildException("the mode attribute is for use with the file/resource length function");
            }
        } else if (this.filesets != null) {
            if (!EACH.equals(this.mode) && !ALL.equals(this.mode)) {
                throw new BuildException("invalid mode setting for file length function: \"" + this.mode + "\"");
            }
            if (this.trim != null) {
                throw new BuildException("the trim attribute is for use with the string length function only");
            }
        } else {
            throw new BuildException("you must set either the string attribute or specify one or more files using the file attribute or nested filesets");
        }
    }

    private void handleResources(Handler h) {
        Iterator i = this.filesets.iterator();
        while (i.hasNext()) {
            FileSet fs = (FileSet)i.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] f = ds.getIncludedFiles();
            for (int j = 0; j < f.length; ++j) {
                Resource r = ds.getResource(f[j]);
                if (!r.isExists()) {
                    this.log(r.getName() + " does not exist", 0);
                    continue;
                }
                if (r.isDirectory()) {
                    this.log(r.getName() + " is a directory; length unspecified", 0);
                    continue;
                }
                File basedir = ds.getBasedir();
                String s = FileUtils.getFileUtils().resolveFile(basedir, r.getName()).getAbsolutePath();
                h.handle(new Resource(s, true, r.getLastModified(), false, r.getSize()));
            }
        }
        h.complete();
    }

    private static long getLength(String s, boolean t) {
        return (t ? s.trim() : s).length();
    }

    private class ConditionHandler
    extends AllHandler {
        ConditionHandler() {
            super(null);
        }

        void complete() {
        }

        long getLength() {
            return this.accum;
        }
    }

    private class AllHandler
    extends Handler {
        long accum = 0L;

        AllHandler(PrintStream ps) {
            super(ps);
        }

        protected synchronized void handle(Resource r) {
            long size = r.getSize();
            if (size == -1L) {
                Length.this.log("Size unknown for " + r.getName(), 1);
            } else {
                this.accum += size;
            }
        }

        void complete() {
            this.ps.print(this.accum);
            super.complete();
        }
    }

    private class EachHandler
    extends Handler {
        EachHandler(PrintStream ps) {
            super(ps);
        }

        protected void handle(Resource r) {
            this.ps.print(r.getName());
            this.ps.print(" : ");
            long size = r.getSize();
            if (size == -1L) {
                this.ps.println("unknown");
            } else {
                this.ps.println(size);
            }
        }
    }

    private abstract class Handler {
        PrintStream ps;

        Handler(PrintStream ps) {
            this.ps = ps;
        }

        protected abstract void handle(Resource var1);

        void complete() {
            this.ps.close();
        }
    }

    private class PropertyOutputStream
    extends ByteArrayOutputStream {
        private PropertyOutputStream() {
        }

        public void close() {
            Length.this.getProject().setNewProperty(Length.this.property, new String(this.toByteArray()).trim());
        }
    }

    public static class When
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"equal", "greater", "less"};
        private static final When EQUAL = new When("equal");

        public When() {
        }

        public When(String value) {
            this.setValue(value);
        }

        public String[] getValues() {
            return VALUES;
        }

        static /* synthetic */ When access$000() {
            return EQUAL;
        }
    }

    public static class FileMode
    extends EnumeratedAttribute {
        static final String[] MODES = new String[]{"each", "all"};

        public String[] getValues() {
            return MODES;
        }
    }
}

