/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.processor.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.com.sun.tools.ws.processor.model.ModelException;
import org.jboss.com.sun.tools.ws.processor.model.ModelObject;
import org.jboss.com.sun.tools.ws.processor.model.ModelVisitor;
import org.jboss.com.sun.tools.ws.processor.model.Port;
import org.jboss.com.sun.tools.ws.processor.model.java.JavaInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service
extends ModelObject {
    private QName name;
    private List<Port> ports = new ArrayList<Port>();
    private Map<QName, Port> portsByName = new HashMap<QName, Port>();
    private JavaInterface javaInterface;

    public Service() {
    }

    public Service(QName name, JavaInterface javaInterface) {
        this.name = name;
        this.javaInterface = javaInterface;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public void addPort(Port port) {
        if (this.portsByName.containsKey(port.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this.ports.add(port);
        this.portsByName.put(port.getName(), port);
    }

    public Port getPortByName(QName n) {
        if (this.portsByName.size() != this.ports.size()) {
            this.initializePortsByName();
        }
        return this.portsByName.get(n);
    }

    public List<Port> getPorts() {
        return this.ports;
    }

    public void setPorts(List<Port> m) {
        this.ports = m;
    }

    private void initializePortsByName() {
        this.portsByName = new HashMap<QName, Port>();
        if (this.ports != null) {
            for (Port port : this.ports) {
                if (port.getName() != null && this.portsByName.containsKey(port.getName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this.portsByName.put(port.getName(), port);
            }
        }
    }

    public JavaInterface getJavaIntf() {
        return this.getJavaInterface();
    }

    public JavaInterface getJavaInterface() {
        return this.javaInterface;
    }

    public void setJavaInterface(JavaInterface i) {
        this.javaInterface = i;
    }

    @Override
    public void accept(ModelVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

