/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.api.apiConnection;
import com.pointbase.cache.cacheManager;
import com.pointbase.collxn.collxnIntToObjHashtable;
import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.dbga.dbgaProperties;
import com.pointbase.jdbc.jdbcCallableStatement;
import com.pointbase.jdbc.jdbcDatabaseMetaData;
import com.pointbase.jdbc.jdbcInfoConnection;
import com.pointbase.jdbc.jdbcInfoDriver;
import com.pointbase.jdbc.jdbcNativeSQL;
import com.pointbase.jdbc.jdbcObject;
import com.pointbase.jdbc.jdbcPreparedStatement;
import com.pointbase.jdbc.jdbcStatement;
import com.pointbase.session.sessionManager;
import com.pointbase.transxn.transxnBase;
import com.pointbase.transxn.transxnXaResource;
import com.pointbase.transxn.transxnXid;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import java.util.StringTokenizer;

public class jdbcConnection
extends jdbcObject
implements Connection,
jdbcInfoConnection,
transxnXaResource {
    protected Driver m_driver;
    protected String m_url;
    protected String m_user;
    protected String m_pwd;
    protected String m_database;
    protected String m_catalog;
    protected int m_isolation;
    private static int m_StmtSeqNum = 0;
    private apiConnection m_apiConnection;
    private jdbcDatabaseMetaData m_MetaData = null;
    private collxnIntToObjHashtable m_ObjTable = null;
    private int m_CurrentXATransactionId = 0;

    public jdbcConnection(String string, String string2, String string3, Driver driver) throws SQLException {
        this.m_url = string;
        this.m_user = string2;
        this.m_pwd = string3;
        this.m_driver = driver;
        this.m_database = "SAMPLE";
        int n = 0;
        if (string2 == null) {
            string2 = "PBPUBLIC";
        }
        if (string3 == null) {
            string3 = "PBPUBLIC";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string4 = string4 + ":" + stringTokenizer.nextToken();
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",;", false);
            this.m_database = stringTokenizer2.nextToken().toUpperCase();
            while (stringTokenizer2.hasMoreTokens()) {
                String string5 = stringTokenizer2.nextToken();
                if (string5.equalsIgnoreCase("NEW")) {
                    n = 1;
                    continue;
                }
                StringTokenizer stringTokenizer3 = new StringTokenizer(string5, "=", false);
                if (stringTokenizer3.countTokens() != 2) continue;
                String string6 = stringTokenizer3.nextToken();
                String string7 = stringTokenizer3.nextToken();
                if (string6.equalsIgnoreCase("Create")) {
                    if (string7.equalsIgnoreCase("TRUE")) {
                        n = 1;
                        continue;
                    }
                    if (!string7.equalsIgnoreCase("FORCE")) continue;
                    n = 2;
                    continue;
                }
                dbgaProperties.setProperty(string6, string7, false);
            }
        } else {
            this.m_database = "SAMPLE";
        }
        try {
            this.m_apiConnection = new apiConnection();
            if (driver == null) {
                this.m_apiConnection.setMaxConnections();
            }
            this.m_apiConnection.connect(this.m_database, this.m_user, this.m_pwd, n, (Connection)this);
            this.m_isolation = dbgaProperties.getPropertiesTransactionIsolationLevel();
            if (this.m_user != "INTERNAL_SYSTEM_ADMINISTRATOR") {
                this.m_apiConnection.checkIfEvaluationPeriodExpired(this.m_database, this.m_user, this.m_isolation);
            }
            if (dbgaProperties.getPropertiesDebugLog()) {
                this.printLogInfo(" New Connection. Transaction Isolation Level " + Integer.toString(this.m_isolation));
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public jdbcConnection(String string, String string2, String string3, Driver driver, collxnIntToObjHashtable collxnIntToObjHashtable2) throws SQLException {
        this(string, string2, string3, driver);
        this.m_ObjTable = collxnIntToObjHashtable2;
    }

    public Statement createStatement() throws SQLException {
        this.verifyConnection();
        jdbcStatement jdbcStatement2 = new jdbcStatement(this, this.getNextStmtSeqNum());
        return jdbcStatement2;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.verifyConnection();
        jdbcPreparedStatement jdbcPreparedStatement2 = new jdbcPreparedStatement(this, this.getNextStmtSeqNum(), string);
        return jdbcPreparedStatement2;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.verifyConnection();
        jdbcPreparedStatement jdbcPreparedStatement2 = new jdbcPreparedStatement(this, this.getNextStmtSeqNum(), string, n);
        return jdbcPreparedStatement2;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.verifyConnection();
        String string2 = jdbcCallableStatement.parse(string);
        jdbcCallableStatement jdbcCallableStatement2 = new jdbcCallableStatement(this, this.getNextStmtSeqNum(), string2);
        return jdbcCallableStatement2;
    }

    public String nativeSQL(String string) throws SQLException {
        this.verifyConnection();
        return jdbcNativeSQL.substituteBlock(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.verifyConnection();
        try {
            if (dbgaProperties.getPropertiesDebugLog()) {
                this.printLogInfo(" Set AutoCommit to " + new Boolean(bl).toString());
            }
            this.m_apiConnection.setAutoCommit(bl);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void commit() throws SQLException {
        this.verifyConnection();
        try {
            if (dbgaProperties.getPropertiesDebugLog()) {
                this.printLogInfo(" Commit ");
            }
            this.m_apiConnection.commit();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void rollback() throws SQLException {
        this.verifyConnection();
        try {
            if (dbgaProperties.getPropertiesDebugLog()) {
                this.printLogInfo(" Rollback ");
            }
            this.m_apiConnection.rollback();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void close() throws SQLException {
        if (!cacheManager.getCacheManager().isShutdownCalled()) {
            try {
                if (this.m_apiConnection != null) {
                    if (dbgaProperties.getPropertiesDebugLog()) {
                        this.printLogInfo(" Close Connection.");
                    }
                    this.m_apiConnection.disconnect();
                    this.m_apiConnection = null;
                    if (this.m_MetaData != null) {
                        this.m_MetaData.close();
                    }
                }
            }
            catch (dbexcpException dbexcpException2) {
                throw dbexcpException2.getSQLException();
            }
        }
    }

    public void closeXA() throws SQLException {
        try {
            if (this.m_apiConnection != null) {
                if (dbgaProperties.getPropertiesDebugLog()) {
                    this.printLogInfo(" CloseXA.");
                }
                this.m_apiConnection.closeXA();
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public String getRMName() throws SQLException {
        this.verifyConnection();
        try {
            try {
                return InetAddress.getLocalHost().getHostAddress() + cacheManager.getCacheManager().getCacheContext().getDatabase().getFile().getAbsolutePath();
            }
            catch (UnknownHostException unknownHostException) {
                throw new dbexcpException(2015);
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isClosed() throws SQLException {
        return this.m_apiConnection == null;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.verifyConnection();
        if (this.m_MetaData == null) {
            jdbcConnection jdbcConnection2 = this;
            synchronized (jdbcConnection2) {
                if (this.m_MetaData == null) {
                    this.m_MetaData = new jdbcDatabaseMetaData(this);
                }
            }
        }
        return this.m_MetaData;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        try {
            this.verifyConnection();
            this.m_apiConnection.setReadOnly(bl);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.verifyConnection();
            return this.m_apiConnection.isReadOnly();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.verifyConnection();
        this.m_catalog = string;
    }

    public String getCatalog() throws SQLException {
        this.verifyConnection();
        return this.m_catalog;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        try {
            switch (n) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new dbexcpException(25405, Integer.toString(n));
                }
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        this.verifyConnection();
        try {
            if (dbgaProperties.getPropertiesDebugLog()) {
                this.printLogInfo(" Set Transaction Isolation Level to  " + Integer.toString(n));
            }
            this.m_apiConnection.setIsolationLevel(this.m_apiConnection.externalIsolationLevelToInternal(n));
        }
        catch (dbexcpException dbexcpException3) {
            throw dbexcpException3.getSQLException();
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.verifyConnection();
        try {
            return this.m_apiConnection.internalIsolationLevelToExternal(this.m_apiConnection.getIsolationLevel());
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.verifyConnection();
        try {
            return this.m_apiConnection.getWarnings();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void clearWarnings() throws SQLException {
        this.verifyConnection();
        this.m_apiConnection.clearWarnings();
    }

    public boolean getAutoCommit() throws SQLException {
        this.verifyConnection();
        try {
            return this.m_apiConnection.getAutoCommit();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.verifyConnection();
        jdbcStatement jdbcStatement2 = new jdbcStatement(this, this.getNextStmtSeqNum(), n, n2);
        return jdbcStatement2;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.verifyConnection();
        jdbcPreparedStatement jdbcPreparedStatement2 = new jdbcPreparedStatement(this, this.getNextStmtSeqNum(), string, n, n2);
        return jdbcPreparedStatement2;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.verifyConnection();
        String string2 = jdbcCallableStatement.parse(string);
        jdbcCallableStatement jdbcCallableStatement2 = new jdbcCallableStatement(this, this.getNextStmtSeqNum(), string2, n, n2);
        return jdbcCallableStatement2;
    }

    public Map getTypeMap() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setTransactionName(String string) throws SQLException {
        this.verifyConnection();
        try {
            this.m_apiConnection.setTransactionName(string);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public transxnBase getCurrentTransaction() throws SQLException {
        this.verifyConnection();
        return this.m_apiConnection.getSession().getCurrentTransaction();
    }

    public synchronized int getNextStmtSeqNum() {
        return ++m_StmtSeqNum;
    }

    public int getCurrentTransactionId() throws SQLException {
        this.verifyConnection();
        return this.m_apiConnection.getCurrentTransactionId();
    }

    public void resetEvalPeriod() throws SQLException {
        this.verifyConnection();
        try {
            this.m_apiConnection.resetEvalPeriod(this.m_database);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void switchLogFile() throws SQLException {
        try {
            if (this.m_apiConnection != null) {
                this.m_apiConnection.switchLogFile();
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public jdbcInfoDriver getDriverInfo() {
        return (jdbcInfoDriver)((Object)this.m_driver);
    }

    public String getURL() {
        return this.m_url;
    }

    public String getUser() {
        return this.m_user;
    }

    public apiConnection getApiConnection() {
        return this.m_apiConnection;
    }

    public void setXAConnection() throws SQLException {
        this.verifyConnection();
        this.m_apiConnection.setXAConnection();
    }

    public boolean isXAConnection() throws SQLException {
        this.verifyConnection();
        return this.m_apiConnection.isXAConnection();
    }

    public int start(int n, byte[] byArray, byte[] byArray2, int n2) throws SQLException {
        try {
            int n3;
            this.verifyConnection();
            if (dbgaProperties.getPropertiesDebugLog()) {
                this.printLogInfo(" start(): Global Id = " + byArray.toString() + " Branch qualifier = " + byArray2.toString() + " Flags = " + n2);
            }
            this.m_CurrentXATransactionId = n3 = this.m_apiConnection.start(n, byArray, byArray2, n2);
            return this.m_CurrentXATransactionId;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void end(int n, byte[] byArray, byte[] byArray2, int n2) throws SQLException {
        try {
            this.verifyConnection();
            if (dbgaProperties.getPropertiesDebugLog()) {
                this.printLogInfo(" end(): Global Id = " + byArray.toString() + " Branch qualifier = " + byArray2.toString() + " Flags = " + n2);
            }
            this.m_apiConnection.end(n, byArray, byArray2, n2);
            this.m_CurrentXATransactionId = 0;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int prepare(int n, byte[] byArray, byte[] byArray2) throws SQLException {
        try {
            this.verifyConnection();
            if (dbgaProperties.getPropertiesDebugLog()) {
                this.printLogInfo(" prepare(): Global Id = " + byArray.toString() + " Branch qualifier = " + byArray2.toString());
            }
            int n2 = this.m_apiConnection.prepare(n, byArray, byArray2);
            return n2;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void commit(int n, byte[] byArray, byte[] byArray2, boolean bl) throws SQLException {
        try {
            this.verifyConnection();
            if (dbgaProperties.getPropertiesDebugLog()) {
                this.printLogInfo(" commit(): Global Id = " + byArray.toString() + " Branch qualifier = " + byArray2.toString() + " p_OnePhase = " + bl);
            }
            this.m_apiConnection.commit(n, byArray, byArray2, bl);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void rollback(int n, byte[] byArray, byte[] byArray2) throws SQLException {
        try {
            this.verifyConnection();
            if (dbgaProperties.getPropertiesDebugLog()) {
                this.printLogInfo(" rollback(): Global Id = " + byArray.toString() + " Branch qualifier = " + byArray2.toString());
            }
            this.m_apiConnection.rollback(n, byArray, byArray2);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public byte[] recover(int n) throws SQLException {
        try {
            this.verifyConnection();
            return transxnXid.xidArrayToBytes(this.recoverOptimize(n));
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Object[] recoverOptimize(int n) throws SQLException {
        try {
            this.verifyConnection();
            return this.m_apiConnection.recover(n);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getCurrentXATransactionId() {
        return this.m_CurrentXATransactionId;
    }

    public int getHoldability() throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("getHoldability");
        return -1;
    }

    public void setHoldability(int n) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("getHoldability");
    }

    void removeObj(Object object) {
        if (this.m_ObjTable != null) {
            this.m_ObjTable.remove(object.hashCode());
        }
    }

    public void verifyConnection() throws SQLException {
        try {
            if (this.m_apiConnection == null) {
                throw new dbexcpException(2003);
            }
            if (cacheManager.getCacheManager().isShutdownCalled()) {
                throw new dbexcpException(2003);
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    private void printLogInfo(String string) {
        sessionManager.getSessionManager().printDebugInfo(string);
    }
}

