/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jboss.dependency.plugins.AbstractDependencyInfo;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractControllerContext
extends JBossObject
implements ControllerContext {
    private Object name;
    private Object target;
    private Controller controller;
    private ControllerState state = ControllerState.ERROR;
    private ControllerState requiredState = ControllerState.NOT_INSTALLED;
    private ControllerMode mode = ControllerMode.AUTOMATIC;
    private ControllerContextActions actions;
    private DependencyInfo dependencies;
    private Throwable error;

    public AbstractControllerContext(Object name, ControllerContextActions actions) {
        this(name, actions, null, null);
    }

    public AbstractControllerContext(Object name, ControllerContextActions actions, DependencyInfo dependencies) {
        this(name, actions, dependencies, null);
    }

    public AbstractControllerContext(Object name, ControllerContextActions actions, DependencyInfo dependencies, Object target) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Null actions");
        }
        this.name = name;
        this.actions = actions;
        this.dependencies = dependencies == null ? new AbstractDependencyInfo() : dependencies;
        this.target = target;
    }

    public AbstractControllerContext(Object name, Object target) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
        this.target = target;
    }

    public Object getName() {
        return this.name;
    }

    public void setName(Object name) {
        this.name = name;
    }

    public ControllerState getState() {
        return this.state;
    }

    public ControllerState getRequiredState() {
        return this.requiredState;
    }

    public void setRequiredState(ControllerState state) {
        this.requiredState = state;
    }

    public ControllerMode getMode() {
        return this.mode;
    }

    public void setMode(ControllerMode mode) {
        this.mode = mode;
        this.flushJBossObjectCache();
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.flushJBossObjectCache();
    }

    public DependencyInfo getDependencyInfo() {
        return this.dependencies;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
        this.flushJBossObjectCache();
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
        this.state = ControllerState.ERROR;
        this.flushJBossObjectCache();
    }

    public void install(ControllerState fromState, ControllerState toState) throws Throwable {
        this.error = null;
        this.actions.install(this, fromState, toState);
        this.state = toState;
        this.flushJBossObjectCache();
    }

    public void uninstall(ControllerState fromState, ControllerState toState) {
        this.error = null;
        this.state = toState;
        this.flushJBossObjectCache();
        this.actions.uninstall(this, fromState, toState);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" target=").append(this.target);
        if (this.error != null || !this.state.equals(ControllerState.ERROR)) {
            buffer.append(" state=").append(this.state.getStateString());
        }
        if (!ControllerMode.AUTOMATIC.equals(this.mode)) {
            buffer.append(" mode=").append(this.mode.getModeString());
            buffer.append(" requiredState=").append(this.requiredState.getStateString());
        }
        if (this.dependencies != null) {
            buffer.append(" depends=").append(this.dependencies);
        }
        if (this.error != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            this.error.printStackTrace(writer);
            writer.flush();
            buffer.append(" error=").append(stringWriter.getBuffer());
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        if (this.error != null || !this.state.equals(ControllerState.ERROR)) {
            buffer.append(" state=").append(this.state.getStateString());
        }
        if (!ControllerMode.AUTOMATIC.equals(this.mode)) {
            buffer.append(" mode=").append(this.mode.getModeString());
            buffer.append(" requiredState=").append(this.requiredState.getStateString());
        }
        if (this.error != null) {
            buffer.append(" error=").append(this.error.getClass().getName()).append(": ").append(this.error.getMessage());
        }
    }
}

