/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPPart;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxrpc.handler.HandlerWrapper;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.core.soap.SOAPElementWriter;
import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
import org.jboss.ws.metadata.umdm.HandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HandlerChainBaseImpl
implements HandlerChain {
    private static Logger log = Logger.getLogger(HandlerChainBaseImpl.class);
    public static final int STATE_DOES_NOT_EXIST = 0;
    public static final int STATE_CREATED = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_DESTROYED = 3;
    protected List<HandlerEntry> handlers = new ArrayList<HandlerEntry>();
    protected Set<String> roles = new HashSet<String>();
    protected int falseIndex = -1;
    protected int state;

    public HandlerChainBaseImpl(List<HandlerInfo> infos, Set<String> roles) {
        log.debug((Object)("Create a handler chain for roles: " + roles));
        this.addHandlersToChain(infos, roles);
    }

    public List<HandlerInfo> getHandlerInfos() {
        ArrayList<HandlerInfo> list = new ArrayList<HandlerInfo>();
        for (int i = 0; i < this.handlers.size(); ++i) {
            HandlerEntry entry = this.handlers.get(i);
            list.add(entry.info);
        }
        return list;
    }

    public void pullHeaders(Set<QName> headers) {
        for (HandlerEntry entry : this.handlers) {
            QName[] handlerHeaders = entry.handler.getHeaders();
            if (handlerHeaders == null) continue;
            Collections.addAll(headers, handlerHeaders);
        }
    }

    public Set<QName> getHeaders() {
        HashSet<QName> set = new HashSet<QName>();
        this.pullHeaders(set);
        return set;
    }

    private void addHandlersToChain(List<HandlerInfo> infos, Set<String> roleSet) {
        try {
            if (infos != null) {
                for (HandlerInfo info : infos) {
                    HandlerWrapper handler = new HandlerWrapper((Handler)info.getHandlerClass().newInstance());
                    HandlerMetaData.HandlerType type = (HandlerMetaData.HandlerType)((Object)info.getHandlerConfig().get(HandlerMetaData.HandlerType.class.getName()));
                    this.handlers.add(new HandlerEntry(handler, info, type));
                }
            }
            if (roleSet != null) {
                this.roles.addAll(roleSet);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new JAXRPCException("Cannot initialize handler chain", (Throwable)ex);
        }
        this.state = 1;
    }

    public int getState() {
        return this.state;
    }

    public void init(Map config) {
        log.debug((Object)("init: [config=" + config + "]"));
        for (int i = 0; i < this.handlers.size(); ++i) {
            HandlerEntry entry = this.handlers.get(i);
            entry.handler.init(entry.info);
        }
        this.state = 2;
    }

    public void destroy() {
        log.debug((Object)"destroy");
        for (int i = 0; i < this.handlers.size(); ++i) {
            HandlerEntry entry = this.handlers.get(i);
            entry.handler.destroy();
        }
        this.handlers.clear();
        this.state = 3;
    }

    public String[] getRoles() {
        HashSet<String> auxlist = new HashSet<String>(this.roles);
        auxlist.add("http://schemas.xmlsoap.org/soap/actor/next");
        String[] roleArr = new String[auxlist.size()];
        auxlist.toArray(roleArr);
        return roleArr;
    }

    public void setRoles(String[] soapActorNames) {
        List<String> newRoles = Arrays.asList(soapActorNames);
        log.debug((Object)("setRoles: " + newRoles));
        this.roles.clear();
        this.roles.addAll(newRoles);
    }

    public boolean handleRequest(MessageContext msgContext) {
        return this.handleRequestInternal(msgContext, HandlerMetaData.HandlerType.ALL);
    }

    public boolean handleRequest(MessageContext msgContext, HandlerMetaData.HandlerType type) {
        return this.handleRequestInternal(msgContext, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleRequestInternal(MessageContext msgContext, HandlerMetaData.HandlerType type) {
        int handlerIndex;
        boolean doNext = true;
        if (this.handlers.size() <= 0) return doNext;
        log.debug((Object)"Enter: handleRequest");
        SOAPMessageContextJAXRPC jaxrpcContext = (SOAPMessageContextJAXRPC)msgContext;
        jaxrpcContext.setProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
        this.replaceDirtyHandlers();
        Handler currHandler = null;
        try {
            try {
                String lastMessageTrace = null;
                for (handlerIndex = 0; doNext && handlerIndex < this.handlers.size(); ++handlerIndex) {
                    SOAPPart soapPart;
                    HandlerEntry handlerEntry = this.handlers.get(handlerIndex);
                    if (type != HandlerMetaData.HandlerType.ALL && type != handlerEntry.getType()) continue;
                    currHandler = handlerEntry.getHandler();
                    if (log.isTraceEnabled()) {
                        soapPart = jaxrpcContext.getSOAPMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart("BEFORE handleRequest - " + currHandler, soapPart, lastMessageTrace);
                    }
                    doNext = currHandler.handleRequest(msgContext);
                    if (!log.isTraceEnabled()) continue;
                    soapPart = jaxrpcContext.getSOAPMessage().getSOAPPart();
                    lastMessageTrace = this.traceSOAPPart("AFTER handleRequest - " + currHandler, soapPart, lastMessageTrace);
                }
                Object var11_11 = null;
                if (!doNext) {
                    this.falseIndex = handlerIndex - 1;
                }
            }
            catch (RuntimeException e) {
                log.error((Object)"RuntimeException in request handler", (Throwable)e);
                doNext = false;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!doNext) {
                this.falseIndex = handlerIndex - 1;
            }
            jaxrpcContext.removeProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
            log.debug((Object)("Exit: handleRequest with status: " + doNext));
            throw throwable;
        }
        jaxrpcContext.removeProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
        log.debug((Object)("Exit: handleRequest with status: " + doNext));
        return doNext;
    }

    public boolean handleResponse(MessageContext msgContext) {
        return this.handleResponseInternal(msgContext, HandlerMetaData.HandlerType.ALL);
    }

    public boolean handleResponse(MessageContext msgContext, HandlerMetaData.HandlerType type) {
        return this.handleResponseInternal(msgContext, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleResponseInternal(MessageContext msgContext, HandlerMetaData.HandlerType type) {
        boolean doNext = true;
        if (this.handlers.size() <= 0) return doNext;
        log.debug((Object)"Enter: handleResponse");
        SOAPMessageContextJAXRPC jaxrpcContext = (SOAPMessageContextJAXRPC)msgContext;
        jaxrpcContext.setProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
        int handlerIndex = this.handlers.size() - 1;
        if (this.falseIndex != -1) {
            handlerIndex = this.falseIndex;
        }
        Handler currHandler = null;
        try {
            try {
                String lastMessageTrace = null;
                while (doNext && handlerIndex >= 0) {
                    HandlerEntry handlerEntry = this.handlers.get(handlerIndex);
                    if (type == HandlerMetaData.HandlerType.ALL || type == handlerEntry.getType()) {
                        SOAPPart soapPart;
                        currHandler = handlerEntry.getHandler();
                        if (log.isTraceEnabled()) {
                            soapPart = jaxrpcContext.getSOAPMessage().getSOAPPart();
                            lastMessageTrace = this.traceSOAPPart("BEFORE handleResponse - " + currHandler, soapPart, lastMessageTrace);
                        }
                        doNext = currHandler.handleResponse(msgContext);
                        if (log.isTraceEnabled()) {
                            soapPart = jaxrpcContext.getSOAPMessage().getSOAPPart();
                            lastMessageTrace = this.traceSOAPPart("AFTER handleResponse - " + currHandler, soapPart, lastMessageTrace);
                        }
                    }
                    --handlerIndex;
                }
                Object var11_11 = null;
                if (!doNext) {
                    this.falseIndex = handlerIndex - 1;
                }
            }
            catch (RuntimeException rte) {
                log.error((Object)"RuntimeException in response handler", (Throwable)rte);
                doNext = false;
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!doNext) {
                this.falseIndex = handlerIndex - 1;
            }
            jaxrpcContext.removeProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
            log.debug((Object)("Exit: handleResponse with status: " + doNext));
            throw throwable;
        }
        jaxrpcContext.removeProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
        log.debug((Object)("Exit: handleResponse with status: " + doNext));
        return doNext;
    }

    public boolean handleFault(MessageContext msgContext) {
        return this.handleFaultInternal(msgContext, HandlerMetaData.HandlerType.ALL);
    }

    public boolean handleFault(MessageContext msgContext, HandlerMetaData.HandlerType type) {
        return this.handleFaultInternal(msgContext, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleFaultInternal(MessageContext msgContext, HandlerMetaData.HandlerType type) {
        boolean doNext = true;
        if (this.handlers.size() > 0) {
            log.debug((Object)"Enter: handleFault");
            SOAPMessageContextJAXRPC jaxrpcContext = (SOAPMessageContextJAXRPC)msgContext;
            jaxrpcContext.setProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
            try {
                int handlerIndex = this.handlers.size() - 1;
                if (this.falseIndex != -1) {
                    handlerIndex = this.falseIndex;
                }
                Handler currHandler = null;
                while (doNext && handlerIndex >= 0) {
                    HandlerEntry handlerEntry = this.handlers.get(handlerIndex);
                    if (type == HandlerMetaData.HandlerType.ALL || type == handlerEntry.getType()) {
                        currHandler = handlerEntry.getHandler();
                        log.debug((Object)("Handle fault: " + currHandler));
                        doNext = currHandler.handleFault(msgContext);
                    }
                    --handlerIndex;
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                jaxrpcContext.removeProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
                log.debug((Object)("Exit: handleFault with status: " + doNext));
                throw throwable;
            }
            jaxrpcContext.removeProperty(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
            log.debug((Object)("Exit: handleFault with status: " + doNext));
            {
            }
        }
        return doNext;
    }

    protected String traceSOAPPart(String logMsg, SOAPPart soapPart, String lastMessageTrace) {
        try {
            SOAPEnvelopeImpl soapEnv = (SOAPEnvelopeImpl)soapPart.getEnvelope();
            String envStr = SOAPElementWriter.writeElement(soapEnv, true);
            if (envStr.equals(lastMessageTrace)) {
                log.trace((Object)(logMsg + ": unchanged"));
            } else {
                log.trace((Object)(logMsg + "\n" + envStr));
                lastMessageTrace = envStr;
            }
            return lastMessageTrace;
        }
        catch (Exception ex) {
            log.error((Object)"Cannot trace SOAP message", (Throwable)ex);
            return null;
        }
    }

    protected void replaceDirtyHandlers() {
        for (int i = 0; i < this.handlers.size(); ++i) {
            HandlerEntry entry = this.handlers.get(i);
            if (entry.handler.getState() != 0) continue;
            log.debug((Object)("Replacing dirty handler: " + entry.handler));
            try {
                HandlerWrapper handler = new HandlerWrapper((Handler)entry.info.getHandlerClass().newInstance());
                entry.handler = handler;
                handler.init(entry.info);
                continue;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                log.error((Object)("Cannot create handler instance for: " + entry.info), (Throwable)ex);
            }
        }
    }

    protected Handler getHandlerAt(int pos) {
        if (pos < 0 || this.handlers.size() <= pos) {
            throw new IllegalArgumentException("No handler at position: " + pos);
        }
        HandlerEntry entry = this.handlers.get(pos);
        return entry.handler;
    }

    public boolean remove(Object o) {
        return this.handlers.remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.handlers.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.handlers.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.handlers.retainAll(c);
    }

    public int hashCode() {
        return ((Object)this.handlers).hashCode();
    }

    public boolean equals(Object o) {
        return ((Object)this.handlers).equals(o);
    }

    public Iterator iterator() {
        return this.handlers.iterator();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.handlers.subList(fromIndex, toIndex);
    }

    public ListIterator listIterator() {
        return this.handlers.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.handlers.listIterator(index);
    }

    public int size() {
        return this.handlers.size();
    }

    public void clear() {
        this.handlers.clear();
    }

    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    public Object[] toArray() {
        return this.handlers.toArray();
    }

    public Object get(int index) {
        return this.handlers.get(index);
    }

    public Object remove(int index) {
        return this.handlers.remove(index);
    }

    public void add(int index, Object element) {
        this.handlers.add(index, (HandlerEntry)element);
    }

    public int indexOf(Object elem) {
        return this.handlers.indexOf(elem);
    }

    public int lastIndexOf(Object elem) {
        return this.handlers.lastIndexOf(elem);
    }

    public boolean add(Object o) {
        return this.handlers.add((HandlerEntry)o);
    }

    public boolean contains(Object elem) {
        return this.handlers.contains(elem);
    }

    public boolean addAll(int index, Collection c) {
        return this.handlers.addAll(index, c);
    }

    public boolean addAll(Collection c) {
        return this.handlers.addAll(c);
    }

    public Object set(int index, Object element) {
        return this.handlers.set(index, (HandlerEntry)element);
    }

    public Object[] toArray(Object[] a) {
        return this.handlers.toArray(a);
    }

    private class HandlerEntry {
        private HandlerWrapper handler;
        private HandlerInfo info;
        private HandlerMetaData.HandlerType type;

        public HandlerEntry(HandlerWrapper handler, HandlerInfo info, HandlerMetaData.HandlerType type) {
            if (handler == null || info == null) {
                throw new IllegalStateException("Invalid handler entry");
            }
            if (type == null) {
                log.debug((Object)("Using handler type default: " + (Object)((Object)HandlerMetaData.HandlerType.ENDPOINT)));
                type = HandlerMetaData.HandlerType.ENDPOINT;
            }
            this.handler = handler;
            this.info = info;
            this.type = type;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public HandlerInfo getInfo() {
            return this.info;
        }

        public HandlerMetaData.HandlerType getType() {
            return this.type;
        }
    }
}

