/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.jboss.ws.core.CommonSOAP12Binding;
import org.jboss.ws.core.jaxws.SOAPFaultHelperJAXWS;
import org.jboss.ws.core.jaxws.binding.BindingExt;
import org.jboss.ws.core.jaxws.binding.SOAPBindingJAXWS;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAP12BindingJAXWS
extends CommonSOAP12Binding
implements BindingExt,
SOAPBinding {
    private SOAPBindingJAXWS delegate = new SOAPBindingJAXWS();

    public SOAP12BindingJAXWS() {
        this.setMTOMEnabled(false);
    }

    public SOAP12BindingJAXWS(boolean mtomEnabled) {
        this.setMTOMEnabled(mtomEnabled);
    }

    @Override
    public void setSOAPActionHeader(OperationMetaData opMetaData, SOAPMessage reqMessage) {
        this.delegate.setSOAPActionHeader(opMetaData, reqMessage);
    }

    @Override
    public Set<String> getRoles() {
        HashSet<String> soap12Roles = new HashSet<String>(this.delegate.getRoles());
        soap12Roles.add("http://www.w3.org/2003/05/soap-envelope/role/next");
        soap12Roles.add("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        return soap12Roles;
    }

    public void setRoles(Set<String> roles) {
        for (String role : roles) {
            if (!role.equals("http://www.w3.org/2003/05/soap-envelope/role/none")) continue;
            throw new WebServiceException("Attempt to configure the binding to play the none role");
        }
        this.delegate.setRoles(roles);
    }

    public List<Handler> getHandlerChain() {
        return this.delegate.getHandlerChain();
    }

    @Override
    public List<Handler> getHandlerChain(HandlerMetaData.HandlerType handlerType) {
        return this.delegate.getHandlerChain(handlerType);
    }

    public void setHandlerChain(List<Handler> handlerChain) {
        this.delegate.setHandlerChain(handlerChain);
    }

    @Override
    public void setHandlerChain(List<Handler> handlerChain, HandlerMetaData.HandlerType handlerType) {
        this.delegate.setHandlerChain(handlerChain, handlerType);
    }

    @Override
    public SOAPMessage createFaultMessageFromException(Exception ex) {
        return SOAPFaultHelperJAXWS.exceptionToFaultMessage(ex);
    }

    @Override
    protected void throwFaultException(SOAPFaultImpl fault) throws Exception {
        throw SOAPFaultHelperJAXWS.getSOAPFaultException(fault);
    }

    public String getBindingID() {
        return this.isMTOMEnabled() ? "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true" : "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    }
}

