/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util;

import com.icesoft.util.encoding.Base64;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class IdGenerator {
    private String seed;
    private long counter;
    private String ipAddress;
    private static MessageDigest md5;

    public IdGenerator() {
        this(String.valueOf(new Random().nextInt()));
    }

    public IdGenerator(String seed) {
        this.seed = seed.trim();
        this.counter = 0L;
        try {
            this.ipAddress = InetAddress.getLocalHost().getHostAddress();
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized String newIdentifier() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(++this.counter);
        buffer.append(System.currentTimeMillis());
        buffer.append(this.seed);
        buffer.append(this.ipAddress);
        buffer.append(Math.random());
        byte[] digest = md5.digest(buffer.toString().getBytes());
        byte[] encodedDigest = Base64.encodeForURL(digest);
        return new String(encodedDigest);
    }
}

